      $ set ans85 noosvs mf defaultbyte"00"
       IDENTIFICATION DIVISION.
       PROGRAM-ID. WinTwoA.
      *    
      *    Programm 
      *    zum Kapitel  :  4.2 Ausrichten von Texten
      *
      *    Programm Name:  WinTwoA.CBL
      *
      *    bersetzung  :  COBOL WINTWOA OMF(obj) ANS85;
      *                    LINK WINTWOA+CBLWGUI+CBLWINA, WINTWOA.EXE,
      *                         WINTWOA,COBLIBW+COBLIB+COBW,
      *                         WINTWOA.DEF /noe/nod
      *                    (Siehe auch Seite 12-13 in COBOL USER GUIDE)
      *
      *    Start mit    :  WIN WINTWOA <RETURN>
      *
      *    Stand        :  16. 7. 93 NWK
      *
       SPECIAL-NAMES.
		CALL-CONVENTION 3 is WINAPI.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      *
      *    Definition der Konstanten
      *
       78  WM-PAINT                   VALUE h"000F".
       78  WM-DESTROY                 VALUE h"0002".
      *
      *    Ausrichtung der Texte
      *
       78  TA-Left                    VALUE  0.
       78  TA-Right                   VALUE  2.
       78  TA-Center                  VALUE  6.
       78  TA-BaseLine                VALUE 24.
      *
      *    Konstante die die Gre des Markers bestimmt
      *
       78  MarkerGroesse              VALUE  5.
      
       01  MyWndProc                   PROCEDURE-POINTER.
       01  MyClassName                 PIC X(0020) VALUE 
					   "Welcome1" & x"00".
       01  MyData.
	   03  loop-flag               PIC x(0001) VALUE 'C'.
	       88  loop-end            VALUE 'E'.
	   03  bool                    PIC 9(0004) COMP-5.
	       88  boolTRUE            VALUE 1.
	       88  boolFALSE           VALUE 0.

	   COPY "WNDCLASS.CPY".
	   COPY "MSG1.CPY".
       
       LOCAL-STORAGE SECTION.
       01  MarkerColor                 PIC  9(0009) COMP-5.
       01  TextPosition                PIC s9(0004) COMP-5.

       01  xText                       PIC s9(0004) COMP-5.
       01  yText                       PIC s9(0004) COMP-5.
       
       01  MyData.
	   03 mResult                  PIC 9(0009) COMP-5.
	   03 tmpFlag                  PIC 9(0004) COMP-5.
	   03 hWindow                  PIC 9(0004) COMP-5.

	01  hps                        PIC x(0002) COMP-5.

	    COPY "PPAINT.CPY".
	    COPY "RECT.CPY".

      *
      *    Felder werden zur Positionierung der Zeichenketten
      *    bentigt.
      *
       01  yLineHeight                 PIC s9(0004) COMP-5.
      *
      *    Subscript der Tabelle und Laufvariable der Schleife
      *
       01  nLauf                       PIC 9(0002).

       LINKAGE SECTION.
	   COPY "LINKAGE1.CPY".

       PROCEDURE DIVISION WINAPI.
       MSWindowsInit SECTION.
	   CALL  "PC_WIN_STARTUP".
	   STOP RUN.

       ENTRY "WinMain" WINAPI USING hInst, 
				    hPrevInstance,
				    lpszCmdLine,
				    nCmdShow.

       MyWinMain section.
	   IF hPrevInstance EQUAL 0

	      MOVE 3 TO style
	      SET lpfnWndProc TO ENTRY "MyWndProc"

	      MOVE 0     TO cbClsExtra
	      MOVE 0     TO cbWndExtra
	      MOVE hInst TO hInstance

	      CALL  WINAPI "__LoadIcon" 
		    USING BY VALUE 0 SIZE 2
			  BY VALUE h"00007f00" SIZE 4
	      RETURNING hIcon

	      CALL  WINAPI "__LoadCursor" 
		    USING BY VALUE 0 SIZE 2
			  BY VALUE h"00007f00" SIZE 4
	      RETURNING hCursor

	      CALL  WINAPI "__GetStockObject" 
		    USING BY VALUE 0 SIZE 2
	      RETURNING hbrBackground

	      SET lpszMenuName  TO NULL
	      SET lpszClassName TO ADDRESS OF MyClassName

	      CALL  WINAPI '__RegisterClass' 
		    USING WndClass
	      RETURNING tmpFlag

	      IF tmpFlag EQUAL 0
		 EXIT PROGRAM RETURNING 0
	      END-IF

	   END-IF

	   CALL  WINAPI "__CreateWindow" 
		 USING BY REFERENCE MyClassName
		       BY REFERENCE "COBOL & Windows" & x"00"
		       BY VALUE h"00CF0000" SIZE 4
		       BY VALUE h"8000" SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE h"8000" SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE hInst
		       BY VALUE 0 SIZE 4
	   RETURNING hWindow

	   CALL  WINAPI "__ShowWindow" 
		 USING BY VALUE hWindow
		       BY VALUE nCmdShow

	   CALL  WINAPI "__UpdateWindow" 
		 USING BY VALUE hWindow

	   PERFORM UNTIL loop-end

	      CALL  WINAPI '__GetMessage' 
		    USING BY REFERENCE msg
			  BY VALUE 0 SIZE 2
			  BY VALUE 0 SIZE 2
			  BY VALUE 0 SIZE 2
	      RETURNING bool

	      IF boolFALSE

		 SET loop-end TO true

	      ELSE
		 CALL  WINAPI '__TranslateMessage'
		       USING BY reference msg

		 CALL  WINAPI '__DispatchMessage'
		       USING BY reference msg

	      END-IF

	   END-PERFORM

	   EXIT PROGRAM RETURNING msg-wParam
	   STOP RUN.


       MyWindowProcedure SECTION.
       ENTRY "MyWndProc" USING BY VALUE hWnd
			       BY VALUE iMessage
			       BY VALUE wParam
			       BY VALUE lParam.

	   MOVE 0 TO mResult
	   EVALUATE iMessage

	   WHEN WM-PAINT
		CALL  WINAPI '__BeginPaint'
		      USING BY VALUE hwnd
			    BY reference ppaint
		RETURNING hps

	 
		CALL  WINAPI '__GetClientRect'
		      USING BY VALUE hwnd
			    BY reference Rect
      *
      *         Berechnen der Ausgabeposition
      *
      *                 Spalte ermitteln
      *  
		COMPUTE xText = nRight / 2
      *
      *                 Zeile ermitteln (hier die erste Zeile)
      *
		COMPUTE yLineHeight = nBottom / 6
      *
      *              Zeile bergeben, yLineHeight wird noch gebraucht
      * 
		MOVE yLineHeight TO yText

      *
      *              Laufzhler initialisieren
      *
      *
			ADD TA-Left, TA-BaseLine GIVING TextPosition
			CALL WINAPI '__SetTextAlign'           
			     USING BY VALUE Hdc
				   BY VALUE TextPosition
      *
      *                 Ausgabe des Textes (Der String ist in einer
      *                 Tabelle hinterlegt.)
      *
			CALL WINAPI '__TextOut' 
			     USING BY VALUE Hdc
				   BY VALUE xText
				   BY VALUE yText
				   BY REFERENCE "Positionierung" & x"00"
				   BY VALUE 14 SIZE 2

			PERFORM DrawMarker
      *
      *                 Nchste Zeile berechnen
      *

			ADD yLineHeight TO yText
			ADD TA-Center, TA-BaseLine GIVING TextPosition
			CALL WINAPI '__SetTextAlign'           
			     USING BY VALUE Hdc
				   BY VALUE TextPosition
      *
      *                 Ausgabe des Textes (Der String ist in einer
      *                 Tabelle hinterlegt.)
      *
			CALL WINAPI '__TextOut' 
			     USING BY VALUE Hdc
				   BY VALUE xText
				   BY VALUE yText
				   BY REFERENCE "Positionierung" & x"00"
				   BY VALUE 14 SIZE 2

			Perform DrawMarker
      *
      *                 Nchste Zeile berechnen
      *
			ADD yLineHeight TO yText
			ADD TA-Right, TA-BaseLine GIVING TextPosition
			CALL WINAPI '__SetTextAlign'           
			     USING BY VALUE Hdc
				   BY VALUE TextPosition
      *
      *                 Ausgabe des Textes (Der String ist in einer
      *                 Tabelle hinterlegt.)
      *
			CALL WINAPI '__TextOut' 
			     USING BY VALUE Hdc
				   BY VALUE xText
				   BY VALUE yText
				   BY REFERENCE "Positionierung" & x"00"
				   BY VALUE 14 SIZE 2
		PERFORM DrawMarker                
	      
		CALL  WINAPI '__EndPaint'
		      USING BY VALUE hwnd
			    BY reference ppaint

	   WHEN WM-DESTROY
		CALL  WINAPI '__PostQuitMessage' 
		      USING BY VALUE 0 SIZE 2

	   WHEN OTHER
		CALL  WINAPI "__DefWindowProc"
		      USING BY VALUE hWnd
			    BY VALUE iMessage
			    BY VALUE wParam
			    BY VALUE lParam
		RETURNING mResult

	   END-EVALUATE

	   EXIT PROGRAM RETURNING mResult.
       DrawMarker Section.
       DrawMarker10.
      *
      *    Farbe der aktuellen Position lesen
      *
	   CALL WinApi '__GetPixel' 
			USING BY VALUE hdc
			      BY VALUE xText 
			      BY VALUE yText
	   RETURNING MarkerColor
      *
      *   Einer-Komplement des Frabwertes bilden
      *   (In 'C' wrde man '~' nutzen, geht in COBOL aber nicht
      *    also wird das ganze mit -1 mulipliziert, Thomas mge mir
      *    verzeihen...)
      *
	   COMPUTE MarkerColor = MarkerColor * -1
      *
      *   Ein Pixel an der aktuellen Position setzen
      *
	   CALL WinApi '__SetPixel'
		USING BY VALUE hdc
		      BY VALUE xText
		      BY VALUE yText
		      BY VALUE MarkerColor
      *
      *   Laufzhler initialisieren
      *
	   MOVE 0 TO nLauf  
      *
      *   In der Schleife wird der Marker (ein kleines Kreuz) 
      *   aufgebaut und Ausgegeben...
      *
	   PERFORM UNTIL nLauf > MarkerGroesse
      *
      *        Laufzhler um eins erhhen
      *
		ADD 1 to nLauf                   
      *    
      *        Aktuelle Position berechnen
      *
	   Compute xText = xText + nLauf

		CALL WinApi '__GetPixel' 
			     USING BY VALUE hdc
				   BY VALUE xText
				   BY VALUE yText
		RETURNING MarkerColor

		COMPUTE MarkerColor = MarkerColor * -1
	   
		CALL WinApi '__SetPixel'
			     USING BY VALUE hdc
			     BY VALUE xText
			     BY VALUE yText
			     BY VALUE MarkerColor
      *
      *    Neue Position berechnen
      *
		COMPUTE xText = xText - ( nLauf * 2 )

		CALL WinApi '__GetPixel' 
			     USING BY VALUE hdc
				   BY VALUE xText
				   BY VALUE yText
		RETURNING MarkerColor

		COMPUTE MarkerColor = MarkerColor * -1

		CALL WinApi '__SetPixel'
			     USING BY VALUE hdc
			     BY VALUE xText
			     BY VALUE yText
			     BY VALUE MarkerColor
		
		COMPUTE xText = xText + nLauf
		COMPUTE yText = yText + nLauf

		CALL WinApi '__GetPixel' 
			     USING BY VALUE hdc
				   BY VALUE xText
				   BY VALUE yText
		RETURNING MarkerColor

		COMPUTE MarkerColor = MarkerColor * -1

		CALL WinApi '__SetPixel'
			     USING BY VALUE hdc
				   BY VALUE xText
				   BY VALUE yText
				   BY VALUE MarkerColor
				    
		 COMPUTE yText = yText - (nLauf * 2 )
  
		 CALL WinApi '__GetPixel' 
			      USING BY VALUE hdc
				    BY VALUE xText
				    BY VALUE yText
		 RETURNING MarkerColor

		 COMPUTE MarkerColor = MarkerColor * -1

		 CALL WinApi '__SetPixel'
		      USING BY VALUE hdc
			    BY VALUE xText
			    BY VALUE yText
			    BY VALUE MarkerColor
      *
      *    Ursprngliche Position restaurieren
      *
		 COMPUTE yText = yText + nLauf

	   END-PERFORM.

       MrkEx.
	   Exit.

