      $ set ans85 noosvs mf defaultbyte"00"
       IDENTIFICATION DIVISION.
       PROGRAM-ID. WinTree.
      *
      *    Programm
      *    zum Kapitel   : 8 Eingabefunktion unter WINDOWS
      *
      *    Programm Name : WinTree.CBL
      *
      *    bersetzung   : Wie in COBOL USER GUIDE Seite 12-13
      *                    beschrieben, oder mit der BATCH-Datei
      *                    CO.BAT, die auf der Begleitdiskette
      *                    zu finden ist.
      *
      *    Start mit     : WIN WINTREE <RETURN>
      *
      *    Stand         : 16. 7. 93 NWK
      *
       SPECIAL-NAMES.
		call-convention 3 is WINAPI.
      
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      *
      *     Konstanten der Fenster-Prozedure
      *
	78  WM-CREATE                  VALUE h"0001".
	78  WM-PAINT                   VALUE h"000F".
	78  WM-DESTROY                 VALUE h"0002".

	78  WM-KILLFOCUS               VALUE h"0008".
	78  WM-SETFOCUS                VALUE h"0007".
      *
      *     CURSOR.H    =>  Cursorformen
      *     WSWINDOW.H  =>  Fensterdeklarationen
      *     TASTEN.H    =>  Tastendeklaration (ESC, DEL u.s.w.)
      *     WMKEY.H     =>  Meldungen ber Tastenaktivitten
      *
	   copy "CURSOR.H". 
	   copy "WSWINDOW.H".
	   copy "TASTEN.H".
	   copy "WMKEY.H".
      *
      *    WndClass.CPY => Classenstruktur des Fensters
      *    Message.CPY  => Record zur Aufnahme der Meldungen
      *    LOOP.CPY     => Record zur Steuerung der Meldeschleife
      *
	   COPY "WNDCLASS.CPY".
	   COPY "MESSAGE.CPY".
	   COPY "LOOP.CPY".

       01  WindowsTitel                PIC X(0034) VALUE
	   "COBOL, WINDOWS und die Texteingabe".   
       01  MyWndProc                   PROCEDURE-POINTER.
       01  MyClassName                 PIC x(0020) VALUE
				       "WELCOME1" & X"00".

       78  BuffSIZE                    VALUE 40.
       
       01  Konvert.
	   03 KovertText               PIC x(0002) COMP-X.

       01  CharBuffer                  PIC x(0020).
       01  CharBufferLen               PIC 9(0004) COMP-5.
       01  EingabeFeld.
	   03 EingabeByte              PIC x(0001) occurs BuffSize.
       01  SubScript                   PIC 9(0002)  value 0.
       01  nZeichenZahl                PIC 9(0002)  value 0.
       01  nCounter                    PIC 9(0002) .
       01  nLauf                       PIC 9(0002).
       01  dwSize.
	   03 dwWidth                  PIC 9(0004) COMP-5.
	   03 dwHigth                  PIC 9(0004) COMP-5.

       01  xCaretPos                   PIC 9(0004) COMP-5.
       01  yCaretPos                   PIC 9(0004) COMP-5.

       01  HdcCaret                    PIC 9(0004) COMP-5.
       01  info1.
	    03 Info1Text               PIC x(0020) value
	       "Ihre Eingabe bitte: ".
	    03 Info1Len                PIC 9(0004) COMP-5 value 20.

       01  yLineHeight                 PIC 9(0004) COMP-5.
       01  xLeftMargin                 PIC 9(0004) COMP-5.

      
       LOCAL-STORAGE SECTION.
      *    LOGFONT.CPY  => Datensatz zur Schriftwahl
      *    PPAINT.CPY   => Datensatz mit der PAINT Struktur
      *    TM.CPY       => Datensatz zur Bestimmung der FONT-Mae
      *
	   COPY "LOGFONT.CPY".
	   COPY "PPAINT.CPY".
	   COPY "TM.CPY".

       01  MyData.
	   03 mResult                  PIC 9(0009) COMP-5.
	   03 TmpFlag                  PIC 9(0004) COMP-5.
	   03 hWindow                  PIC 9(0004) COMP-5.

       01  Hps                         PIC X(0004) COMP-5.
   
       01 Work-Data.
	  03 bBool                     PIC 9(0004) COMP-5 VALUE 1.
	  03 Window-Type               PIC X(0004) COMP-5.
	  03 C-1                       PIC X(0002) COMP-5 VALUE 1.

       01  Wndproc-Data.
	   03 CxChar                   PIC S9(0004) COMP-5.
	   03 CxCaps                   PIC S9(0004) COMP-5.
	   03 CyChar                   PIC S9(0004) COMP-5.
	   03 CxClient                 PIC S9(0004) COMP-5.
	   03 CyClient                 PIC S9(0004) COMP-5.
	   03 MaxWidth                 PIC S9(0004) COMP-5.
	   03 VscrollPos               PIC S9(0004) COMP-5.
	   03 VscrollMax               PIC S9(0004) COMP-5.
	   03 HscrollPos               PIC S9(0004) COMP-5.
	   03 HscrollMax               PIC S9(0004) COMP-5.
	   
       01  Work-Local-Data.
	   03 Longresult               PIC   X(0004) COMP-5.
	   03 hHwindow                 PIC   X(0002) COMP-5.
	   03 I                        PIC  S9(0004) COMP-5.
	   03 X                        PIC  S9(0004) COMP-5.
	   03 Y                        PIC  S9(0004) COMP-5.
	   03 PaintBeg                 PIC  S9(0004) COMP-5.
	   03 PaintEnd                 PIC  S9(0004) COMP-5.
	   03 VscrollInc               PIC  S9(0004) COMP-5.
	   03 HscrollInc               PIC  S9(0004) COMP-5.
	   03 Temp                     PIC  S9(0004) COMP-5.
	   03 Temp2                    PIC  S9(0004) COMP-5.
	   03 Disp-Item                PIC -Z(0004)9.
      *
      *    BufferText => Zur Aufnahme der FONT Bezeichnung
      *    BufferLen  => Zur Aufnahme der Lnge des Bufferinhaltes
      *
       01  BufferText                  PIC  X(0080).    
       01  BufferLen                   PIC S9(0004) COMP-5.

       LINKAGE SECTION.
	   COPY "LINKAGE1.CPY".

       PROCEDURE DIVISION WINAPI.
       MSWindowsInit SECTION.

	   CALL  "PC_WIN_STARTUP".
	   STOP RUN.

       ENTRY "WinMain" WINAPI USING hInst, 
				    hPrevInstance,
				    lpszCmdLine,
				    nCmdShow.

       MyWinMain section.
	   IF hPrevInstance EQUAL 0

	      MOVE 3 TO style
	      SET lpfnWndProc TO ENTRY "MyWndProc"

	      MOVE 0     TO cbClsExtra
	      MOVE 0     TO cbWndExtra
	      MOVE hInst TO hInstance

	      CALL  WINAPI "__LoadIcon" 
		    USING BY VALUE 0 SIZE 2
			  BY VALUE h"00007f00" SIZE 4
	      RETURNING hIcon

	      CALL  WINAPI "__LoadCursor" 
		    USING BY VALUE 0 SIZE 2
			  BY VALUE h"00007f00" SIZE 4
	      RETURNING hCursor

	      CALL  WINAPI "__GetStockObject" 
		    USING BY VALUE 0 SIZE 2
	      RETURNING hbrBackground

	      SET lpszMenuName  TO NULL
	      SET lpszClassName TO ADDRESS OF MyClassName

	      CALL  WINAPI '__RegisterClass' 
		    USING WndClass
	      RETURNING tmpFlag

	      IF tmpFlag EQUAL 0
		 EXIT PROGRAM RETURNING 0
	      END-IF

	   END-IF

	   CALL  WINAPI "__CreateWindow" 
		 USING BY REFERENCE MyClassName
		       BY REFERENCE WindowsTitel
		       BY VALUE h"00CF0000" SIZE 4
		       BY VALUE h"8000" SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE h"8000" SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE hInst
		       BY VALUE 0 SIZE 4
	   RETURNING hWindow

	   CALL  WINAPI "__ShowWindow" 
		 USING BY VALUE hWindow
		       BY VALUE nCmdShow

	   CALL  WINAPI "__UpdateWindow" 
		 USING BY VALUE hWindow

	   PERFORM UNTIL loop-end

	      CALL  WINAPI '__GetMessage' 
		    USING BY REFERENCE msg
			  BY VALUE 0 SIZE 2
			  BY VALUE 0 SIZE 2
			  BY VALUE 0 SIZE 2
	      RETURNING bool

	      IF boolFALSE

		 SET loop-end TO true

	      ELSE
		 CALL  WINAPI '__TranslateMessage'
		       USING BY reference msg

		 CALL  WINAPI '__DispatchMessage'
		       USING BY reference msg

	      END-IF

	   END-PERFORM

	   EXIT PROGRAM RETURNING msg-wParam
	   STOP RUN.

	MyWindowProcedure SECTION.
	ENTRY "MyWndProc" USING
			  BY VALUE hWnd
			  BY VALUE iMessage
			  BY VALUE wParam
			  BY VALUE lParam.
	   
	   MOVE 0 TO mResult
      *
      *    Auswerten der Meldungen
      *
	   EVALUATE iMessage
      *
      *       WM-CHAR
      *       Es wurde eine Taste gedrckt
      *
	      WHEN WM-CHAR
      *
      *            Auswertung der Taste
      *
		   EVALUATE wParam
      *
      *            BackSpace
      *
		   WHEN VK-BACK
      *
      *            BackSpace wurde gedrckt
      *
		   IF SubScript equal 0 then
		      PERFORM ErrorBeep
		   ELSE
		      SUBTRACT 1 FROM SubScript
		      MOVE SubScript TO nLauf

		      PERFORM UNTIL nLauf = nZeichenZahl

			 ADD 1 TO nLauf
			 MOVE EingabeByte( nLauf + 1) TO
				 EingabeByte( nLauf )
			 MOVE x"00" TO EingabeByte( nLauf + 1)

		      END-Perform

		      SUBTRACT 1 FROM nZeichenZahl
		      PERFORM ZeigeCharBuffer

		   END-IF 
      *
      *            Beliebige andere Taste
      *
		   WHEN OTHER
      *
      *                 Zeichen in den Buffer bertragen
      *
			PERFORM CharToBuffer
      *
      *                 Ausgaben ungltig
      *
			CALL WINAPI '__InvalidateRect' USING
				     BY VALUE HwnD
				     BY VALUE 0 SIZE 2
				     BY VALUE 0 SIZE 2
      *
      *                 Bufferinhalt neu Ausgeben
      *
			PERFORM ZeigeCharBuffer
      *
      *            Zeichenbehandlung Ende
      *
		   END-EVALUATE
      *
      *       WM-CREATE
      *
	      WHEN WM-CREATE
      *
      *       Ausgabeposition ermitteln
      *
		   PERFORM  CreatePos
      *
      *       WM-PAINT
      *       Ausgabebereich definieren und Label ausgeben
      *
	     WHEN WM-PAINT
		  CALL WINAPI '__BeginPaint' USING
			       BY VALUE Hwnd
			       BY REFERENCE PPaint
		  
		  CALL WINAPI '__TextOut' USING
			       BY VALUE Hdc
			       BY VALUE 100 SIZE 2
			       BY VALUE 100 SIZE 2
			       BY REFERENCE Info1Text
			       BY VALUE Info1Len

		  CALL WINAPI '__EndPaint' USING
			       BY VALUE Hwnd
			       BY REFERENCE PPaint

	     WHEN WM-DESTROY
		  CALL WINAPI '__PostQuitMessage' USING
			       BY VALUE 0 SIZE 2

	      WHEN WM-KILLFOCUS
      *
      *       Eingabe beenden
      *
		   CALL WINAPI '__DestroyCaret'

	     WHEN WM-KEYDOWN
      *
      *      Cursor wurde bewegt...
      *
		  PERFORM CursorPos
	     WHEN WM-SETFOCUS
      *
      *      Eingabe Erlaubnis generiert
      *

		  PERFORM CreateCaret

	     WHEN OTHER
		  CALL WINAPI "__DefWindowProc" USING
			       BY VALUE hWnd
			       BY VALUE iMessage
			       BY VALUE wParam
			       BY VALUE lParam                  
		  RETURNING mResult
	   END-EVALUATE
	   EXIT PROGRAM RETURNING mResult.
      *
      *    ------------------------------------------------------------
      *    Dienstroutinen
      *    ------------------------------------------------------------

       CursorPos.

	   EVALUATE wParam

	      WHEN VK-DELETE
	
		   IF SubScript EQUAL nZeichenZahl THEN
		      PERFORM ErrorBeep

		   ELSE
		      MOVE SubScript TO nLauf

		      PERFORM UNTIL nLauf = nZeichenZahl

			 ADD 1 TO nLauf
			 MOVE EingabeByte( nLauf + 1) TO
				 EingabeByte( nLauf )
			 MOVE x"00" TO EingabeByte( nLauf + 1)

		      END-Perform

		      SUBTRACT 1 FROM nZeichenZahl
		      PERFORM ZeigeCharBuffer

		   END-IF 
	   
	      WHEN VK-END

		   MOVE nZeichenZahl TO SubScript
		   PERFORM CaretPos
			 
	      WHEN VK-HOME

		   MOVE 0 TO SubScript
		   PERFORM CaretPos

	      WHEN VK-LEFT

		   IF  SubScript > 0  THEN
		       SUBTRACT 1 FROM SubScript
		       PERFORM CaretPos

		    ELSE
		       PERFORM ErrorBeep

		    END-IF

	      WHEN VK-RIGHT

		   IF SubScript < nZeichenZahl THEN
		      ADD 1 TO SubScript
		      PERFORM CaretPos

		   ELSE
		      PERFORM ErrorBeep

		   END-IF

	   END-EVALUATE.

	   MOVE nZeichenZahl TO CharBufferLen        
	   PERFORM ZeigeCharBuffer.

       CaretPos.
      *
      *    Caret (Cursor) ausgeben
      *
	   CALL WINAPI '__GetDc' USING
			BY VALUE Hwnd
	   RETURNING Hdc

	   MOVE EingabeFeld TO CharBuffer
	   MOVE SubScript TO CharBufferLen

	   CALL WINAPI '__GetTextExtent' USING
			BY VALUE Hdc
			BY REFERENCE CharBuffer
			BY VALUE CharBufferLen
	   RETURNING dwSize
	   
	   CALL WINAPI '__ReleaseDC' USING
			BY VALUE Hwnd
			BY VALUE Hdc

	   COMPUTE xCaretPos = dwWidth + xLeftMargin

	   CALL WINAPI '__SetCaretPos' USING
			BY VALUE xCaretPos
			BY VALUE 100 SIZE 2.
	    
       CreateCaret.
      *
      *    Caret erzeugen
      *
	   CALL WINAPI '__CreateCaret' USING
			BY VALUE Hwnd
			BY VALUE 0 SIZE 2
			BY VALUE 0 SIZE 2
			BY VALUE yLineHeight

	    PERFORM CaretPos

	    CALL WINAPI '__ShowCaret' USING
			 BY VALUE Hwnd.

       CreatePos.
      *
      *    Caret Prosition bestimmen
      *
      *    Handle besorgen
      *
	   CALL WINAPI '__GetDc' USING
			BY VALUE Hwnd
	   RETURNING Hdc
      *
      *    Informationen ber den FONT holen
      *
	   CALL WINAPI '__GetTextMetrics' USING
			BY VALUE Hdc
			BY REFERENCE Tm
      *
      *    Mae berechnen
      *
	   COMPUTE yLineHeight = TmHeight + TmExternalLeading 
	   MOVE TmAveCharWidth TO xLeftMargin 
      *
      *    Textlnge (Ihre Eingabe bitte :...)
      *    
	   CALL WINAPI '__GetTextExtent' USING
			BY VALUE Hdc
			BY REFERENCE Info1Text
			BY VALUE Info1Len
	   RETURNING dwSize
      *
      *    Position des Eingabefeldes Berechnen
      *
	   COMPUTE xLeftMargin = xLeftMargin + 100 + dwWidth
	   COMPUTE yCaretPos = yLineHeight + 100

      *
      *    Freigabe Handle
      *
	   CALL WINAPI '__ReleaseDC' USING
			BY VALUE Hwnd
			BY VALUE Hdc.
	   

       CharToBuffer.
      *
      *    Zeichen in Buffer bertragen
      *
	   IF ( nZeichenZahl= BuffSIZE ) THEN
	      PERFORM ErrorBeep
	      MOVE wParam TO Konvert
	      MOVE Konvert TO EingabeByte( BuffSIZE )

	   ELSE
	      MOVE wParam TO Konvert
	      IF SubScript = nZeichenZahl THEN
		 ADD 1 TO SubScript
			  nZeichenZahl

	      ELSE
		 ADD 1 TO SubScript

	      END-IF
	      MOVE Konvert TO EingabeByte( SubScript)

	   END-IF.

       ZeigeCharBuffer.
      *
      *    Buffer Anzeigen
      *
	   CALL WINAPI '__GetDC' USING
			BY VALUE HWnd
	   RETURNING hdc
	  
	   MOVE EingabeFeld TO CharBuffer

	   PERFORM CaretPos

	   MOVE nZeichenZahl TO CharBufferLen             
		
	   CALL WINAPI '__textout' USING
			BY VALUE hdc
			BY VALUE xLeftMargin
			BY VALUE 100 SIZE 2
			BY REFERENCE CharBuffer
			BY VALUE CharBufferLen

	   PERFORM EraseLastPos

	   CALL WINAPI '__releaseDC' USING
			BY VALUE hwnd
			BY VALUE hdc.
 
       EraseLastPos.
      *
      *    Zeichen hinter der Ausgabe lschen
      *
	   CALL WINAPI '__GetTextExtent' USING
			BY VALUE Hdc
			BY REFERENCE CharBuffer
			BY VALUE CharBufferlen
	   RETURNING dwSize

	   COMPUTE xLeftMargin = xLeftMargin + dwWidth

	   CALL WINAPI '__TextOut' USING
			BY VALUE hdc                   
			BY VALUE xLeftMargin
			BY VALUE 100 SIZE 2
			BY REFERENCE '    '
			BY VALUE 4 SIZE 2

	   COMPUTE xLeftMargin = xLeftMargin - dwWidth.
	
       
       ErrorBeep.
      *
      *    Signalton ausgeben
      *
	   CALL WINAPI '__MessageBeep' USING
			BY VALUE 0 SIZE 2.
