      $ set ans85 noosvs mf defaultbyte"00"
       IDENTIFICATION DIVISION.
       PROGRAM-ID. WinOne.
      *    
      *    Programm 
      *    zum Kapitel  :  2 und 4.1 
      *
      *    Programm Name:  WinOne.CBL
      *
      *    bersetzung  :  COBOL WINONE OMF(obj) ANS85;
      *                    LINK WINONE+CBLWGUI+CBLWINA, WINONE.EXE,
      *                         WINONE,COBLIBW+COBLIB+COBW,
      *                         WINONE.DEF /noe/nod
      *                    (Siehe auch Seite 12-13 in COBOL USER GUIDE)
      *
      *    Start mit    :  WIN WINONE <RETURN>
      *
      *    Stand        :  16. 7. 93 NWK
      *

			      
       SPECIAL-NAMES.
		CALL-CONVENTION 3 is WINAPI.
      
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      *
      *    Definition der Konstanten
      *
      *
      *    Nachrichten der Meldungsschleife
      *
       78  WM-PAINT                   VALUE h"000F".
       78  WM-DESTROY                 VALUE h"0002".
      *
      *    Ausrichtungsflags fr den Text
      *
       78  DT-Center                   VALUE h"0001".
       78  DT-VCenter                  VALUE h"0004".
       78  DT-SingleLine               VALUE h"0020".

      *    -------------------------------------------------------------
      *    Definition von Datenfeldern
      *    -------------------------------------------------------------
      *
       01  MyWndProc                   PROCEDURE-POINTER.
       01  MyClassName                 PIC X(0020) VALUE 
					   "Welcome1" & x"00".
       01  MyData.
	   03  loop-flag               PIC x(0001) VALUE 'C'.
	       88  loop-end            VALUE 'E'.
	   03  bool                    PIC 9(0004) COMP-5.
	       88  boolTRUE            VALUE 1.
	       88  boolFALSE           VALUE 0.

	    COPY "WNDCLASS.CPY".
	    COPY "MSG1.CPY".

       LOCAL-STORAGE SECTION.
      *
      *    Datensatz der zweiten Ausgabeversion wie in Kapitel
      *    4.1 des Buches beschrieben.
      *
       01  DrawRecord.
           03 TextPosition             PIC s9(0004) COMP-5.
           03 TextString               PIC  X(0040).
           03 LenOffString             PIC s9(0004) COMP-5.

       01  MyData.
	   03 mResult                  PIC 9(0009) COMP-5.
	   03 tmpFlag                  PIC 9(0004) COMP-5.
	   03 hWindow                  PIC 9(0004) COMP-5.

	01  hps                        PIC x(0002) COMP-5.

	    COPY "PPAINT.CPY".

       LINKAGE SECTION.
	   COPY "LINKAGE1.CPY".

       PROCEDURE DIVISION WINAPI.
       MSWindowsInit SECTION.

	   CALL  "PC_WIN_STARTUP".
	   STOP RUN.

       ENTRY "WinMain" WINAPI USING hInst, 
				    hPrevInstance,
				    lpszCmdLine,
				    nCmdShow.

       MyWinMain section.
	   IF hPrevInstance EQUAL 0

	      MOVE 3 TO style
	      SET lpfnWndProc TO ENTRY "MyWndProc"

	      MOVE 0     TO cbClsExtra
	      MOVE 0     TO cbWndExtra
	      MOVE hInst TO hInstance

	      CALL  WINAPI "__LoadIcon" 
		    USING BY VALUE 0 SIZE 2
			  BY VALUE h"00007f00" SIZE 4
	      RETURNING hIcon

	      CALL  WINAPI "__LoadCursor" 
		    USING BY VALUE 0 SIZE 2
			  BY VALUE h"00007f00" SIZE 4
	      RETURNING hCursor

	      CALL  WINAPI "__GetStockObject" 
		    USING BY VALUE 0 SIZE 2
	      RETURNING hbrBackground

	      SET lpszMenuName  TO NULL
	      SET lpszClassName TO ADDRESS OF MyClassName

	      CALL  WINAPI '__RegisterClass' 
		    USING WndClass
	      RETURNING tmpFlag

	      IF tmpFlag EQUAL 0
		 EXIT PROGRAM RETURNING 0
	      END-IF

	   END-IF

	   CALL  WINAPI "__CreateWindow" 
		 USING BY REFERENCE MyClassName
		       BY REFERENCE "COBOL & Windows" & x"00"
		       BY VALUE h"00CF0000" SIZE 4
		       BY VALUE h"8000" SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE h"8000" SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE hInst
		       BY VALUE 0 SIZE 4
	   RETURNING hWindow

	   CALL  WINAPI "__ShowWindow" 
		 USING BY VALUE hWindow
		       BY VALUE nCmdShow

	   CALL  WINAPI "__UpdateWindow" 
		 USING BY VALUE hWindow

	   PERFORM UNTIL loop-end

	      CALL  WINAPI '__GetMessage' 
		    USING BY REFERENCE msg
			  BY VALUE 0 SIZE 2
			  BY VALUE 0 SIZE 2
			  BY VALUE 0 SIZE 2
	      RETURNING bool

	      IF boolFALSE

		 SET loop-end TO true

	      ELSE
		 CALL  WINAPI '__TranslateMessage'
		       USING BY reference msg

		 CALL  WINAPI '__DispatchMessage'
		       USING BY reference msg

	      END-IF

	   END-PERFORM

	   EXIT PROGRAM RETURNING msg-wParam
	   STOP RUN.


       MyWindowProcedure SECTION.
       ENTRY "MyWndProc" USING BY VALUE hWnd
			       BY VALUE iMessage
			       BY VALUE wParam
			       BY VALUE lParam.

	   MOVE 0 TO mResult
	   EVALUATE iMessage

	   WHEN WM-PAINT
      *
      *         Ausgabebereich bestimmen 
      *
		CALL  WINAPI '__BeginPaint'
		      USING BY VALUE hwnd
			    BY reference ppaint
		RETURNING hps
      *
      *         --------------------------------------------------------
      *         Ausgabe eines Textes durch die API-Funktion 
      *         __DrawText. Wie im Kapitel 2 beschrieben.
      *         --------------------------------------------------------         
      *
      *         
                CALL WinApi '__FillRect'
                     USING BY VALUE hps
                           BY REFERENCE rcl
                           BY VALUE hbrBackGround
      *
      *          Ausgabe des Textes durch die API-Funktion __DrawText,
      *          es handelt sich hierbei um den Aufruf wie er in Kapitel
      *          2 des Buches beschrieben wurde.
      * 

                CALL WinApi '__DrawText'
                     USING BY VALUE hps
                           BY REFERENCE
                              "Hallo WINDOWS, hier ist COBOL..." & x"00"
                           BY VALUE 32 SIZE 2
                           BY REFERENCE rcl
                           BY VALUE h"0025" SIZE 2
      *
      *         Ausgabe des Textes durch die API-Funktion __DrawText,
      *         es handelt sich hierbei um den Aufruf wie er im Kapitel
      *         4.1 des Buches Beschrieben wurde.
      *         Mchten Sie diese Version Testen men die Kommentar-
      *         sterne in der Spalte 7 entfernt werden.
      *         --------------------------------------------------------
      *         Initialisieren der Datenfelder
      *
      *          ADD DT-Center,
      *              DT-VCenter,
      *              DT-SingleLine GIVING TextPosition

      *          MOVE "Hallo WINDOWS, hier ist COBOL..." & x"00"
      *               TO TextString
          
      *          MOVE 32 TO LenOffString

      *          CALL WinApi '__DrawText'
      *               USING BY VALUE hps
      *                     BY REFERENCE TextString
      *                     BY VALUE LenOffString
      *                     BY REFERENCE rcl
      *                     BY VALUE TextPosition
      *
      *         Ausgabebereich bzw. Handle auf diesen 
      *         wieder freigeben          
         
		CALL  WINAPI '__EndPaint'
		      USING BY VALUE hwnd
			    BY reference ppaint

	   WHEN WM-DESTROY
		CALL  WINAPI '__PostQuitMessage' 
		      USING BY VALUE 0 SIZE 2

	   WHEN OTHER
		CALL  WINAPI "__DefWindowProc"
		      USING BY VALUE hWnd
			    BY VALUE iMessage
			    BY VALUE wParam
			    BY VALUE lParam
		RETURNING mResult

	   END-EVALUATE

	   EXIT PROGRAM RETURNING mResult.
      *
      *    End of File WinOne.CBL
      *