      $ set ans85 noosvs mf defaultbyte"00"
       IDENTIFICATION DIVISION.
       PROGRAM-ID. WinMouse.
      *
      *    Programm
      *    zum Kapitel   : 6 Eingabefunktion unter WINDOWS
      *
      *    Programm Name : WinMouse.CBL
      *
      *    bersetzung   : Wie in COBOL USER GUIDE Seite 12-13
      *                    beschrieben, oder mit der BATCH-Datei
      *                    CO.BAT, die auf der Begleitdiskette
      *                    zu finden ist.
      *
      *    Start mit     : WIN WINMOUSE <RETURN>
      *
      *    Stand         : 16. 7. 93 NWK
      *
      
       SPECIAL-NAMES.
		call-convention 3 is WINAPI.
       DATA DIVISION.
       WORKING-STORAGE SECTION.

       78  WM-PAINT                    value h"000F".
       78  WM-DESTROY                  value h"0002".
       78  WM-CREATE                   value h"0001".       
       78  WM-SETCURSOR                value h"0020".
	   COPY "CURSOR.H".
	   COPY "MouseMsg.H".

       78  HtClient                    value 1.
       01  MyWndProc                   procedure-pointer.

       01  WindowTitel                 pic x(0029) value
	   "COBOL & WINDOWS und die Muse".
       01  MyClassName                 pic x(0020) value 
	   "Welcome1" & x"00".

	    COPY "LOOP.CPY".
	    COPY "WndClass.CPY".
	    COPY "MESSAGE.CPY".
	    COPY "MouseTxt.CPY".
	    COPY "TM.CPY".

	01  nCounter                   pic 9(0001) value 1.

	01  MouseCounter               pic 9(0002).
	    88 MouseCounterArrow       value 0.
	    88 MouseCounterCross       value 1.

	01  MakeNewMouse               pic 9(0001).
	    88 MakeNewMouseTrue        value 1.
      *
      *    Handle der MouseCursor
      *
	01  HdcMouseArrow              pic 9(0004) comp-5.
	01  HdcMouseCross              pic 9(0004) comp-5.
      *
      *    Koordinaten des zu treffenden Bereiches
      *
	01  MouseRcl.
	    03 MxLeft                  pic S9(0004) comp-5.
	    03 MyTop                   pic S9(0004) comp-5.
	    03 MxRight                 pic S9(0004) comp-5.
	    03 MyBottom                pic S9(0004) comp-5.
      *
      *     Rckgabe der Funktion PtInRect
      * 
       01   Treffer                    pic  9(0004) comp-5.
      *
      *     Zweiter Parameter der Funktion PtInRect
      *     (Aktuelle Position des Cursors)
      *
       01   Pt.
	    03 PtX                     pic s9(0004) comp-5.
	    03 PtY                     pic s9(0004) comp-5.
      *
      *     Buffer zur allgemeine Ausgabe durch TEXTOUT
      *
	01  texttext.
	     03 BufferText             pic x(0005).
      *
      *     Rckgabe der Funktion GetTextExtent
      *
	01  dwSize.
	    03 dwWidth                 pic 9(0004) comp-5.
	    03 dwHeight                pic 9(0004) comp-5.
      
       LOCAL-STORAGE SECTION.
       01  MyData.
	   03  mResult                 pic 9(0009) comp-5.
	   03  tmpFlag                 pic 9(0004) comp-5.
	   03  hWindow                 pic 9(0004) comp-5.

       01  yLineHeight                 pic 9(0004) comp-5.

       01  xLeftMargin                 pic 9(0004) comp-5.

       01  hps                         pic x(0004) comp-5.
	
	   COPY "PPAINT.CPY".

       LINKAGE SECTION.
	   COPY "LINKAGE2.CPY".

       PROCEDURE DIVISION WINAPI.
       MSWindowsInit SECTION.

	   CALL  "PC_WIN_STARTUP".
	   STOP RUN.

       ENTRY "WinMain" WINAPI USING hInst, 
				    hPrevInstance,
				    lpszCmdLine,
				    nCmdShow.

       MyWinMain section.
	   IF hPrevInstance EQUAL 0

	      MOVE 3 TO style
	      SET lpfnWndProc TO ENTRY "MyWndProc"

	      MOVE 0     TO cbClsExtra
	      MOVE 0     TO cbWndExtra
	      MOVE hInst TO hInstance

	      CALL  WINAPI "__LoadIcon" 
		    USING BY VALUE 0 SIZE 2
			  BY VALUE h"00007f00" SIZE 4
	      RETURNING hIcon

	      CALL  WINAPI "__LoadCursor" 
		    USING BY VALUE 0 SIZE 2
			  BY VALUE h"00007f00" SIZE 4
	      RETURNING hCursor

	      CALL  WINAPI "__GetStockObject" 
		    USING BY VALUE 0 SIZE 2
	      RETURNING hbrBackground

	      SET lpszMenuName  TO NULL
	      SET lpszClassName TO ADDRESS OF MyClassName

	      CALL  WINAPI '__RegisterClass' 
		    USING WndClass
	      RETURNING tmpFlag

	      IF tmpFlag EQUAL 0
		 EXIT PROGRAM RETURNING 0
	      END-IF

	   END-IF

	   CALL  WINAPI "__CreateWindow" 
		 USING BY REFERENCE MyClassName
		       BY REFERENCE WindowTitel
		       BY VALUE h"00CF0000" SIZE 4
		       BY VALUE h"8000" SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE h"8000" SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE hInst
		       BY VALUE 0 SIZE 4
	   RETURNING hWindow

	   CALL  WINAPI "__ShowWindow" 
		 USING BY VALUE hWindow
		       BY VALUE nCmdShow

	   CALL  WINAPI "__UpdateWindow" 
		 USING BY VALUE hWindow

	   PERFORM UNTIL loop-end

	      CALL  WINAPI '__GetMessage' 
		    USING BY REFERENCE msg
			  BY VALUE 0 SIZE 2
			  BY VALUE 0 SIZE 2
			  BY VALUE 0 SIZE 2
	      RETURNING bool

	      IF boolFALSE

		 SET loop-end TO true

	      ELSE
		 CALL  WINAPI '__TranslateMessage'
		       USING BY reference msg

		 CALL  WINAPI '__DispatchMessage'
		       USING BY reference msg

	      END-IF

	   END-PERFORM

	   EXIT PROGRAM RETURNING msg-wParam
	   STOP RUN.
      
       MyWindowProcedure SECTION.
       ENTRY "MyWndProc" USING
			     BY VALUE hWnd
			     BY VALUE iMessage
			     BY VALUE wParam
			     BY VALUE lParam.
	     
	   MOVE 0 TO mResult

	   EVALUATE iMessage
      *
      *    Maus wurde bewegt
      *
	   WHEN Wm-SetCursor

		IF MakeNewMouseTrue 
		   AND MouselWord EQUAL HTClient THEN

		   CALL WinApi '__MessageBeep' USING 
				BY VALUE 0 SIZE 2

		   IF MouseCounterArrow THEN
		      CALL WinApi '__SetCursor' USING
				   BY VALUE hdcMouseCross

		   ELSE
		      CALL WinApi '__SetCursor' USING
				   BY VALUE HdcMouseArrow

		   END-IF

		   MOVE 0 TO MakeNewMouse

		END-IF
      *
      *    Ausgabebereich vorbereiten
      *
	   WHEN WM-CREATE

		CALL WinApi '__LoadCursor'  USING
			     BY VALUE 0 SIZE 2
			     BY VALUE IDC-ARROW SIZE 4
		RETURNING hdcMouseArrow

		CALL WinApi '__LoadCursor'  USING
			     BY VALUE 0 SIZE 2
			     BY VALUE IDC-CROSS SIZE 4
		RETURNING HdcMouseCross
	

		CALL WinApi '__GetDc' USING
			     BY VALUE Hwnd
		RETURNING Hdc

		CALL WinApi '__GetTextMetrics' USING
			     BY VALUE Hdc
			     BY REFERENCE Tm

		COMPUTE yLineHeight = TmHeight + TmExternalLeading
		MOVE TmAveCharWidth TO xLeftMargin
		
		CALL WinApi '__ReleaseDc' USING
			     BY VALUE Hwnd
			     BY VALUE Hdc


	   WHEN WM-RBUTTONDOWN
      *
      *    Rechte Maustaste gedrckt
      *
		MOVE 140 TO MsgPtX
		MOVE "J " TO BufferText
		PERFORM SayButtonPush
	   
	   WHEN WM-RBUTTONUP
      *
      *    Rechte Maustaste losgelassen
      *
		MOVE 140 TO MsgPtx                 
		MOVE "N " TO BufferText
		PERFORM SayButtonPush

	   WHEN WM-MBUTTONDOWN
      *
      *    Mittlere Maustaste gedrckt
      *
		MOVE 120 TO MsgPtX
		MOVE "J " TO BufferText
		PERFORM SayButtonPush
	   
	   WHEN WM-MBUTTONUP
      *
      *    Mittlere Maustaste losgelassen
      *
		MOVE 120 TO MsgPtx                 
		MOVE "N " TO BufferText
		PERFORM SayButtonPush

	   WHEN WM-LBUTTONDOWN                
      *
      *    Linke Maustaste gedrckt
      *
		MOVE MouselWord TO Ptx
		MOVE MousehWord TO Pty

		CALL WinApi '__PtInRect' USING
			     BY REFERENCE MouseRcl
			     BY VALUE Pt
		RETURNING Treffer

		IF Treffer EQUAL 1 THEN
		   MOVE 1 TO MakeNewMouse

		   IF MouseCounterArrow THEN
		      MOVE 1 TO MouseCounter

		   ELSE
		      MOVE 0 TO MouseCounter

		   END-IF

		END-IF

		MOVE 100 TO MsgPtX
		MOVE "J " TO BufferText
		PERFORM SayButtonPush
 
	   WHEN WM-LBUTTONUP
      *
      *    Linke Maustaste losgelassen
      *
		MOVE 100 TO MsgPtx
		MOVE "N " TO BufferText                
		PERFORM SayButtonPush
		
	   WHEN WM-MOUSEMOVE
      *
      *    Mauszeiger wurde bewegt
      *
		CALL WinApi '__GetDc' USING
			     BY VALUE Hwnd
		RETURNING Hdc

		MOVE mouselWord TO buffertext

		CALL WinApi '__TextOut' USING
			     BY VALUE Hdc
			     BY VALUE 220 SIZE 2
			     BY VALUE 60 SIZE 2
			     BY REFERENCE textText
			     BY VALUE 5 SIZE 2

		MOVE MousehWord TO BufferText
		CALL WinApi '__TextOut' USING
			     BY VALUE Hdc
			     BY VALUE 220 SIZE 2
			     BY VALUE 80 SIZE 2
			     BY REFERENCE TextText
			     BY VALUE 4 SIZE 2
	      
		CALL WinApi '__ReleaseDc' USING
			     BY VALUE Hwnd
			     BY VALUE Hdc
	   WHEN WM-PAINT
      *
      *    WM-PAINT
      *    Ausgabebereichen vorbereiten und Label im
      *    Fenster plazieren bzw. Ausgeben
      *
		CALL WinApi '__BeginPaint' USING
			     BY VALUE Hwnd
			     BY REFERENCE PPaint
		RETURNING Hps

		MOVE 40 TO msgptx

		PERFORM VARYING nCounter FROM 1 BY 1
			UNTIL nCounter > 5

		    ADD 20 TO msgptx        
		    CALL WinApi '__TextOut' USING
				 BY VALUE Hdc
				 BY VALUE 20 SIZE 2
				 BY VALUE msgptx
				 BY REFERENCE InfoElement( nCounter )
				 BY VALUE 30 SIZE 2

		END-PERFORM

		MOVE zero TO nCounter
		MOVE 100 TO msgptx
		MOVE "N" TO BufferText

		PERFORM VARYING nCounter FROM 1 BY 1 
			UNTIL nCounter > 3

			PERFORM SayButtonPush
			ADD 20 TO MsgPtx

		END-PERFORM  


		CALL WinApi '__TextOut' USING
			     BY VALUE Hdc
			     BY VALUE 320 SIZE 2
			     BY VALUE 60 SIZE 2
			     BY REFERENCE 'Die andere Form bitte'
			     BY VALUE 21 SIZE 2

		CALL WinApi '__GetClientRect' USING
			     BY VALUE Hwnd
			     BY REFERENCE MouseRcl

		MOVE 60 TO MyTop
		
		CALL WinApi '__GetTextExtent' USING
			     BY VALUE Hdc
			     BY REFERENCE 'Die andere Form bitte'
			     BY VALUE 21 SIZE 2
		RETURNING dwSize

		COMPUTE MyBottom = MyTop + dwHeight
		MOVE 320 TO MxLeft 
		COMPUTE MxRight = MXLeft + dwWidth
	      
		CALL WinApi '__EndPaint' USING
			     BY VALUE Hwnd
			     BY REFERENCE PPaint
				   
	   WHEN WM-DESTROY
      *
      *    Ende der aktuellen Instance vorbereiten
      *

		CALL WinApi '__PostQuitMessage' USING
			     BY VALUE 0 SIZE 2

	   WHEN other
      *
      *    Behandlung der meldungen die bis hier nicht
      *    von der Prozedure bearbeitet wurden
      *
	      CALL WinApi "__DefWindowProc" USING
			   BY VALUE hWnd
			   BY VALUE iMessage
			   BY VALUE wParam
			   BY VALUE lParam
	      RETURNING mResult

	   end-evaluate
	   exit program RETURNING mResult.

       SayButtonPush.
      *
      *   Ausgabe das eine Maustaste gedrckt wurde
      *
	   CALL WinApi '__GetDc' USING
			BY VALUE Hwnd
	   RETURNING Hdc      

	   CALL WinApi '__TextOut' USING
			BY VALUE Hdc
			BY VALUE 220 SIZE 2
			BY VALUE msgptx
			BY REFERENCE BufferText
			BY VALUE 4 SIZE 2

	   CALL WinApi '__ReleaseDc' USING
			BY VALUE Hwnd
			BY VALUE Hdc
