      $ set ans85 noosvs mf defaultbyte"00"
       IDENTIFICATION DIVISION.
       PROGRAM-ID. WinBox2.

       SPECIAL-NAMES.
		call-convention 3 is WINAPI.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
	 
       01  WindowTitel                 PIC X(0034) VALUE
	   "COBOL, WINDOWS und der Dialog".   

       01  lpWndProc                   PROCEDURE-POINTER.
       01  lpEingabeDialog             PROCEDURE-POINTER.
       01  lpRadioDialog               PROCEDURE-POINTER.
       01  lpFileDialog                PROCEDURE-POINTER.

       01  MyClassName                 PIC x(0020) VALUE
	   "WELCOME1" & X"00".
      *    ------------------------------------------------------------
      *
      *    ------------------------------------------------------------
	   78 WM-COMMAND               value h"0111".
	   78 WM-DESTROY               value h"0002".
	   78 WM-CREATE                value h"0001".
	   78 WM-PAINT                 value h"000F".
	   78 WM-QUIT                  value h"12".
	   78 WM-INITDIALOG            value h"0110".
	   78 WM-GETTEXTLENGTH         value h"0E".

	   78 IDM-EINGABE              value  1.
	   78 IDM-RADIO                value  2.           
	   78 IDM-LIST                 value  3.

	   78 IDM-INFO                 value 98.
	   78 IDM-EXIT                 value 99.

	   78 ID-ERSTER                value 200.
	   78 ID-ZWEITER               value 201.
	   78 ID-DRITTER               value 202.

	   78 ID-NAME                  value 400.
	   78 ID-OK                    value 401.
	   78 ID-CANCEL                value 402.
	   
	   78 ID-FILENAME              value 300.
	   78 ID-FILELIST              value 301.
	   78 ID-DIRLIST               value 302.
	   78 ID-CURDIR                value 303.          

	   78  LBN-SELCHANGE           value   1.
	   78  LBN-DBLCLK              value   2.

	   78  EN-CHANGE               value h"0300".

      *    ------------------------------------------------------------
      *
      *    ------------------------------------------------------------
       01  hWndMenu                    pic 9(0004) comp-5.
       01  hButton                     pic 9(0004) comp-5.

       01  Buffer                      pic x(0040).
       01  BufferLen                   pic 9(0004) comp-5.
       01  DirBuffer                   pic x(0040).
       01  DirBufferLen                pic 9(0004) comp-5.
       01  ButtonNr                    pic 9(0004) comp-5.
	   88 ButtonOk                 value 200 201 202.
       01  Leer                        pic 9(0004) comp-5.
	   COPY "CURSOR.H". 
	   COPY "WSWINDOW.H".
	   COPY "WNDCLASS.CPY".
	   COPY "MESSAGE.CPY".
	   COPY "LOOP.CPY".
       local-storage section.
	   COPY "PPAINT.CPY".
       01  MyData.
	   03 mResult                  PIC 9(0009) COMP-5.
	   03 TmpFlag                  PIC 9(0004) COMP-5.
	   03 hWindow                  PIC 9(0004) COMP-5.

       01  Hps                         PIC X(0004) COMP-5.
   
       01 Work-Data.
	  03 bBool                     PIC 9(0004) COMP-5 VALUE 1.
	  03 Window-Type               PIC X(0004) COMP-5.
	  03 C-1                       PIC X(0002) COMP-5 VALUE 1.

       01  Wndproc-Data.
	   03 CxChar                   PIC S9(0004) COMP-5.
	   03 CxCaps                   PIC S9(0004) COMP-5.
	   03 CyChar                   PIC S9(0004) COMP-5.
	   03 CxClient                 PIC S9(0004) COMP-5.
	   03 CyClient                 PIC S9(0004) COMP-5.
	   03 MaxWidth                 PIC S9(0004) COMP-5.
	   03 VscrollPos               PIC S9(0004) COMP-5.
	   03 VscrollMax               PIC S9(0004) COMP-5.
	   03 HscrollPos               PIC S9(0004) COMP-5.
	   03 HscrollMax               PIC S9(0004) COMP-5.
	   
      *
      *    Allgemeine Datenfelder zur Positionierung von Texten
      *
       01  Work-Local-Data.
	   03 Longresult               PIC   X(0004) COMP-5.
	   03 hHwindow                 PIC   X(0002) COMP-5.
	   03 I                        PIC  S9(0004) COMP-5.
	   03 X                        PIC  S9(0004) COMP-5.
	   03 Y                        PIC  S9(0004) COMP-5.
	   03 PaintBeg                 PIC  S9(0004) COMP-5.
	   03 PaintEnd                 PIC  S9(0004) COMP-5.
	   03 VscrollInc               PIC  S9(0004) COMP-5.
	   03 HscrollInc               PIC  S9(0004) COMP-5.
	   03 Temp                     PIC  S9(0004) COMP-5.
	   03 Temp2                    PIC  S9(0004) COMP-5.
	   03 Disp-Item                PIC -Z(0004)9.
       LINKAGE SECTION.
	   copy "LINKAGE2.CPY".
       PROCEDURE DIVISION WINAPI.
       MSWindowsInit SECTION.

	   CALL  "PC_WIN_STARTUP".
	   STOP RUN.

       ENTRY "WinMain" WINAPI USING hInst, 
				    hPrevInstance,
				    lpszCmdLine,
				    nCmdShow.

       MyWinMain section.
	   IF hPrevInstance EQUAL 0

	      MOVE 3 TO style
	      SET lpfnWndProc TO ENTRY "MyWndProc"

	      MOVE 0     TO cbClsExtra
	      MOVE 0     TO cbWndExtra
	      MOVE hInst TO hInstance

	      CALL  WINAPI "__LoadIcon" 
		    USING BY VALUE 0 SIZE 2
			  BY VALUE h"00007f00" SIZE 4
	      RETURNING hIcon

	      CALL  WINAPI "__LoadCursor" 
		    USING BY VALUE 0 SIZE 2
			  BY VALUE h"00007f00" SIZE 4
	      RETURNING hCursor
	      CALL WinApi "__LoadMenu"
		   USING BY VALUE hInstance
			 BY REFERENCE "WinBox2" & x"00"
	      RETURNING hWndMenu

	      CALL  WINAPI "__GetStockObject" 
		    USING BY VALUE 0 SIZE 2
	      RETURNING hbrBackground

	      SET lpszMenuName  TO NULL
	      SET lpszClassName TO ADDRESS OF MyClassName

	      CALL  WINAPI '__RegisterClass' 
		    USING WndClass
	      RETURNING tmpFlag

	      IF tmpFlag EQUAL 0
		 EXIT PROGRAM RETURNING 0
	      END-IF

	   END-IF

	 
	   CALL  WINAPI "__CreateWindow" 
		 USING BY REFERENCE MyClassName
		       BY REFERENCE WindowTitel
		       BY VALUE h"00CF0000" SIZE 4
		       BY VALUE h"8000" SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE h"8000" SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE hWndMenu
		       BY VALUE hInst
		       BY VALUE 0 SIZE 4
	   RETURNING hWindow

	   CALL  WINAPI "__ShowWindow" 
		 USING BY VALUE hWindow
		       BY VALUE nCmdShow

	   CALL  WINAPI "__UpdateWindow" 
		 USING BY VALUE hWindow

	   PERFORM UNTIL loop-end

	      CALL  WINAPI '__GetMessage' 
		    USING BY REFERENCE msg
			  BY VALUE 0 SIZE 2
			  BY VALUE 0 SIZE 2
			  BY VALUE 0 SIZE 2
	      RETURNING bool

	      IF boolFALSE

		 SET loop-end TO true

	      ELSE
		 CALL  WINAPI '__TranslateMessage'
		       USING BY reference msg

		 CALL  WINAPI '__DispatchMessage'
		       USING BY reference msg

	      END-IF

	   END-PERFORM

	   EXIT PROGRAM RETURNING msg-wParam
	   STOP RUN.


       ENTRY "MyWndProc" USING
			 BY VALUE hWnd
			 BY VALUE iMessage
			 BY VALUE wParam
			 BY VALUE lParam.
	     
	   MOVE 0 TO mResult
      *
      *    Bearbeiten der Meldungen
      *

	   evaluate iMessage
      *
      *    Menmeldung
      *
	      WHEN WM-COMMAND

		EVALUATE wParam
      *
      *         Erster Menpunkt
      *
		WHEN IDM-EINGABE

		     SET lpEingabeDialog TO ENTRY 'Dialog2' 

		     CALL WinApi '__DialogBox' USING
				  BY VALUE hInstance
				  BY REFERENCE 'TEXTEINGABE'& x"00"
				  BY VALUE hWnd
				  BY VALUE lpEingabeDialog

		     CALL WinApi '__FreeProcInstance' USING
				  BY VALUE lpEingabeDialog

		     
		     CALL WinApi '__MessageBox' USING
				  BY VALUE hWnd
				  BY REFERENCE Buffer 
				  BY REFERENCE 'Die Eingabe' & x"00"
				  BY VALUE h"0040" size 2

	      WHEN IDM-RADIO
      *
      *       Zweiter Menpunkt
      *
		   set lpRadioDialog TO entry 'RadioAbt'

		   CALL WinApi '__DialogBox' USING
				BY VALUE hInstance
				BY REFERENCE 'RADIOBUTTON'& x"00"
				BY VALUE hWnd
				BY VALUE lpRadioDialog

		   CALL WinApi '__FreeProcInstance' USING
				BY VALUE lpRadioDialog

		   if ButtonOk then
			
		       MOVE "Button Nr:" TO Buffer
		       compute ButtonNr = ButtonNr - ID-ERSTER + 1
		       MOVE ButtonNr TO Buffer( 12:4 )
		       MOVE x"00" TO Buffer( 17:1 )

		   else

		       MOVE "Keine Auswahl" TO buffer

		   end-if

		   CALL WinApi '__MessageBox' USING
				BY VALUE hWnd
				BY REFERENCE Buffer
				BY REFERENCE
				   'Gewhlter Button' & x"00"
				BY VALUE h"0040" size 2

	      WHEN IDM-LIST
      *
      *       Dritter Menpunkt
      *
		   set lpFileDialog TO entry 'FileDirList'

		   CALL WinApi '__DialogBox' USING
				BY VALUE hInstance
				BY REFERENCE 'OPENFILE'& x"00"
				BY VALUE hWnd
				BY VALUE lpFileDialog

		   CALL WinApi '__FreeProcInstance' USING
				BY VALUE lpEingabeDialog

		   if Buffer( 1:3 ) = "*.*" then

		      CALL WinApi '__MessageBox' USING
				   BY VALUE hWnd
				   BY REFERENCE
				      'Keine Datei ausgewhlt' & x"00"
				   BY REFERENCE
				      'DateiDialog' & x"00"
				   BY VALUE h"0040" size 2

		   else

		      CALL WinApi '__MessageBox' USING
				   BY VALUE hWnd
				   BY REFERENCE Buffer
				   BY REFERENCE
				      'DateiDialog' & x"00"
				   BY VALUE h"0040" size 2
 
		   end-if

	      WHEN IDM-INFO
      *
      *       INFO im Hauptmen
      *
		   CALL WinApi '__MessageBox' USING
				BY VALUE hWnd
				BY REFERENCE
				   'Thomas: Es geht auch ohne C++'
				    & x"00"
				BY REFERENCE 'Info...'
				BY VALUE h"0030" size 2

	      WHEN IDM-EXIT
      *
      *       Menpunkt BEENDEN
      *

		   CALL WinApi '__DestroyWindow' USING
				BY VALUE Hwnd
		     
	      end-evaluate

	   WHEN WM-DESTROY
		CALL WinApi '__PostQuitMessage' USING
			     BY VALUE 0 size 2

	   WHEN other
		CALL WinApi '__DefWindowProc' USING
			     BY VALUE hWnd
			     BY VALUE iMessage
			     BY VALUE wParam
			     BY VALUE lParam
		RETURNING mResult
     
	   end-evaluate
	   exit program RETURNING mResult.
      * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
      *    F E N S T E R P R O C E D U R E Nr. 2 (Dialogbox)
      * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

      DialogUndEingabe section.
	   entry 'Dialog2' USING 
			   BY VALUE hWnd
			   BY VALUE iMessage
			   BY VALUE wParam
			   BY VALUE lParam.

	   MOVE 0 TO mResult.
	   evaluate iMessage

	     WHEN WM-INITDIALOG
		  CALL WinApi '__SetDlgItemText' USING
			       BY VALUE hWnd
			       BY VALUE 400 size 2
			       BY REFERENCE 'Ihr Name'& x"00"

	     WHEN WM-COMMAND
	       evaluate wParam
		 WHEN ID-OK
		   CALL WinApi '__GetDlgItemText' USING
				BY VALUE hWnd
				BY VALUE 400 size 2
				BY REFERENCE Buffer
				BY VALUE 20 size 2

		   CALL WinApi '__EndDialog' USING
				BY VALUE hWnd
				BY VALUE 1 size 2

		 WHEN ID-CANCEL
		    CALL WinApi '__EndDialog' USING
				 BY VALUE hWnd
				 BY VALUE 0 size 2
	       WHEN other
		CALL WinApi '__DefWindowProc' USING
			     BY VALUE hWnd
			     BY VALUE iMessage
			     BY VALUE wParam
			     BY VALUE lParam
		RETURNING mResult
		    
	       
	       end-evaluate

	     WHEN other
		CALL WinApi '__DefWindowProc' USING
			     BY VALUE hWnd
			     BY VALUE iMessage
			     BY VALUE wParam
			     BY VALUE lParam
		RETURNING mResult
	       
	     
	     end-evaluate
	     exit program RETURNING mResult.
      * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
      *    F E N S T E R P R O C E D U R E Nr. 3 (RadioButton)
      * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

       RadioKommunikations section.
	   entry 'RadioAbt' USING 
			   BY VALUE hWnd
			   BY VALUE iMessage
			   BY VALUE wParam
			   BY VALUE lParam.

	   MOVE 0 TO mResult.
	   evaluate iMessage

	     WHEN WM-INITDIALOG
		  CALL WinApi '__CheckRadioButton' USING
			       BY VALUE hWnd
			       BY VALUE ID-ERSTER size 2
			       BY VALUE ID-DRITTER size 2
			       BY VALUE ID-ERSTER size 2

		 CALL WinApi '__CheckDlgButton' USING
			      BY VALUE hWnd
			      BY VALUE ID-ERSTER size 2
			      BY VALUE 1 size 2

		 MOVE ID-ERSTER TO ButtonNr

	     WHEN WM-COMMAND
	       evaluate wParam
		 WHEN ID-ERSTER THRU ID-DRITTER
		      
		      CALL WinApi '__CheckDlgButton' USING
				   BY VALUE hWnd
				   BY VALUE ButtonNr 
				   BY VALUE 0 size 2
		  
		     CALL WinApi '__CheckDlgButton' USING
				  BY VALUE hWnd
				  BY VALUE wParam 
				  BY VALUE 1 size 2
		    MOVE wParam TO ButtonNr  
		      
		 WHEN ID-OK
		   
		   CALL WinApi '__EndDialog' USING
				BY VALUE hWnd
				BY VALUE 1 size 2

		 WHEN ID-CANCEL
		    MOVE 0 TO ButtonNr
		    CALL WinApi '__EndDialog' USING
				 BY VALUE hWnd
				 BY VALUE 0 size 2

		 WHEN other
		    CALL WinApi '__DefWindowProc' USING
				 BY VALUE hWnd
				 BY VALUE iMessage
				 BY VALUE wParam
				 BY VALUE lParam
		    RETURNING mResult
		    
	       
	       end-evaluate

	     WHEN other
		CALL WinApi '__DefWindowProc' USING
			     BY VALUE hWnd
			     BY VALUE iMessage
			     BY VALUE wParam
			     BY VALUE lParam
		RETURNING mResult
	       
	     
	     end-evaluate
	     exit program RETURNING mResult.
      * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
      *    F E N S T E R P R O C E D U R E Nr. 4 (DateiListe)
      * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
       DateiListe section.
	   entry 'FileDirList' USING 
			   BY VALUE hWnd
			   BY VALUE iMessage
			   BY VALUE wParam
			   BY VALUE lParam.

	   MOVE 0 TO mResult.
	   evaluate iMessage

	     WHEN WM-INITDIALOG
		  MOVE "*.*" TO Buffer
		  MOVE x"00" TO Buffer( 4:1)
		  
		  CALL WinApi '__DlgDirList' USING
			       BY VALUE hWnd
			       BY REFERENCE Buffer
			       BY VALUE ID-DIRLIST size 2
			       BY VALUE ID-CURDIR size 2
			       BY VALUE h"C010" size 2
			       
		 CALL WinApi '__DlgDirList' USING
			      BY VALUE hWnd
			      BY REFERENCE Buffer
			      BY VALUE ID-FILELIST size 2
			      BY VALUE ID-CURDIR size 2
			      BY VALUE h"0000" size 2
			      
		 CALL WinApi '__SetDlgItemText' USING
			      BY VALUE hWnd
			      BY VALUE ID-FILENAME size 2
			      BY REFERENCE Buffer
							       
		  CALL WinApi '__GetDlgItem' USING
			       BY VALUE hWnd
			       BY VALUE ID-OK size 2
		  RETURNING hButton
		  
		  CALL WinApi '__EnableWindow' USING
			       BY VALUE hButton
			       BY VALUE 0 size 2
	   
	     WHEN WM-COMMAND
	       evaluate wParam
		 WHEN ID-FILENAME
		      if wNotify = EN-CHANGE then

			 CALL WinApi '__SendMessage' USING
				      BY VALUE hCtrl
				      BY VALUE WM-GETTEXTLENGTH size 2
				      BY VALUE 0 size 2
				      BY VALUE 0 size 4

			 RETURNING Leer

			 CALL WinApi '__MessageBeep' USING
				      BY VALUE hWnd
				      BY REFERENCE Buffer
				      BY REFERENCE "uu" & x"00"
				      BY VALUE h"0040" size 2

			 CALL WinApi '__GetDlgItem' USING
				      BY VALUE hWnd
				      BY VALUE ID-OK size 2
			 RETURNING hButton

			 CALL WinApi '__EnableWindow' USING
				      BY VALUE hButton
				      BY VALUE Leer 
			 
		      end-if
		 WHEN ID-FILELIST
		      if wNotify = LBN-DBLCLK then

			 CALL WinApi '__DlgDirSelect' USING
				      BY VALUE hWnd
				      BY REFERENCE Buffer
				      BY VALUE ID-FILELIST size 2

			 CALL WinApi '__SetDlgItemText' USING
				      BY VALUE hWnd
				      BY VALUE ID-FILENAME size 2
				      BY REFERENCE Buffer

		      end-if

		 WHEN ID-DIRLIST
		      MOVE wNotify TO buffer

     
		      if wNotify = LBN-SELCHANGE THEN
			 CALL WinApi '__messagebeep' USING 
				      BY VALUE 0 size 2  
			 CALL WinApi '__DlgDirSelect' USING
				      BY VALUE hWnd
				      BY REFERENCE DirBuffer
				      BY VALUE ID-DIRLIST size 2
			 CALL WinApi '__LStrLen' USING
				      BY REFERENCE DirBuffer 
			 RETURNING DirBufferLen
			 MOVE Buffer TO 
			      DirBuffer( DirBufferLen:BufferLen )

			 CALL WinApi '__SetDlgItemText' USING
				      BY VALUE hWnd
				      BY VALUE ID-FILENAME size 2
				      BY REFERENCE DirBuffer
		      end-if

		      if wNotify = LBN-DBLCLK then
			 
			 CALL WinApi '__DlgDirSelect' USING
				      BY VALUE hWnd
				      BY REFERENCE DirBuffer
				      BY VALUE ID-DIRLIST size 2

			 CALL WinApi '__DlgDirList' USING
				      BY VALUE hWnd
				      BY REFERENCE DirBuffer
				      BY VALUE ID-DIRLIST size 2
				      BY VALUE ID-CURDIR size 2
				      BY VALUE h"C010" size 2

			 CALL WinApi '__DlgDirList' USING
				      BY VALUE hWnd
				      BY REFERENCE DirBuffer
				      BY VALUE ID-FILELIST size 2
				      BY VALUE ID-CURDIR size 2
				      BY VALUE h"0000" size 2

			 CALL WinApi '__LStrLen' USING
				      BY REFERENCE DirBuffer 
			 RETURNING DirBufferLen
			 MOVE Buffer TO 
			      DirBuffer( DirBufferLen:BufferLen )


			 CALL WinApi '__SetDlgItemText' USING
				      BY VALUE hWnd
				      BY VALUE ID-FILENAME
				      BY REFERENCE Buffer
		      end-if                
		 WHEN ID-OK
		   
		   CALL WinApi '__EndDialog' USING
				BY VALUE hWnd
				BY VALUE 1 size 2

		 WHEN ID-CANCEL
		    
		    MOVE "*.*" TO Buffer
		    CALL WinApi '__EndDialog' USING
				 BY VALUE hWnd
				 BY VALUE 0 size 2

		 WHEN other
		    CALL WinApi '__DefWindowProc' USING
				 BY VALUE hWnd
				 BY VALUE iMessage
				 BY VALUE wParam
				 BY VALUE lParam
		    RETURNING mResult
		    
	       
	       end-evaluate

	     WHEN other
		CALL WinApi '__DefWindowProc' USING
			     BY VALUE hWnd
			     BY VALUE iMessage
			     BY VALUE wParam
			     BY VALUE lParam
		RETURNING mResult
	       
	     
	     end-evaluate
	     exit program RETURNING mResult.
