/************************************************************************/
/* This Rexx EXEC will run Personal AS Version 2 in an OS/2 session.    */
/*                                                                      */
/* It will change the environment variables in the OS/2 session         */
/* and start the Personal AS Version 2 exe.                             */
/*                                                                      */
/* After installing Version 3, if you had Version 2 installed, you      */
/* should now have two additional environment variables set in your     */
/* CONFIG.SYS called DSSPATHV2 and DSSDIRV2 which point to the          */
/* location that Personal AS Version 2 is installed and it's working    */
/* directory respectively. These are used in this program to determine  */
/* the location of the version 2 exe.                                   */
/*                                                                      */
/* To run it, you must also have a . in your libpath.                   */
/*                                                                      */
/* Personal AS Version 3 must not be running or started up while this   */
/* program is running.                                                  */
/************************************************************************/

/* Pick up any parameters to run with this                   */
arg parms

/* Check for the correct environment                         */
share = 'OS2ENVIRONMENT'
dirlocation = VALUE('DSSDIRV2',,share)
pathlocation = VALUE('DSSPATHV2',,share)
If dirlocation = '' | pathlocation = '' Then Do
   Say "Environment not compatible for running this program"
   Exit
End
Else Do

/* set up the DSS enviroment variables                            */
   say VALUE('DSSDIR',dirlocation,share)

   say VALUE('DSSPATH',pathlocation,share)

/* get the actual location of EFDAS1 from the DSSPATHV2 variable */
   if substr(pathlocation,length(pathlocation)) <> ';' then
     pathlocation = pathlocation || ';'

   actualpath =''
   do until pathlocation = ''
     x = pos(";",pathlocation);
     thisdir = substr(pathlocation,1,x-1)
     pathlocation = substr(pathlocation,x+1)
     If (substr(thisdir,length(thisdir),1) = '\') Then
       filename = thisdir || "EFDAS1.EXE"
     Else
       filename = thisdir || "\EFDAS1.EXE"
     If Stream(filename,'c','query exists') = '' then do
        actualpath = thisdir
        pathlocation = ''
     end
   end
   if actualpath='' then do
      Say "Cannot find Version 2 EFDAS1.EXE in DSSPATHV2"
      Exit
   end

/* and set up the other environment variables             */
   path = VALUE('PATH',,share)
   newpath = actualpath || ';' || path
   say VALUE('PATH',newpath,share)

   help = VALUE('HELP',,share)
   newhelp = actualpath || ';' || help
   say VALUE('HELP',newhelp,share)

   dpath = VALUE('DPATH',,share)
   newdpath = actualpath || ';' || dpath
   say VALUE('DPATH',newdpath,share)

/* set the current drive and path to that of the version 2 exe */
   drive = substr(actualpath,1,1)
   If length(actualpath) > 3 Then
     dir = substr(actualpath,4)

   command = drive || ':'
   command
   'CD\'
   If dir <> '' Then Do
     command = 'cd' dir
     command
   End

/* and run it                                         */
   If parms <> ' ' Then
     parms
   Else
     'EFDAS1.EXE' parms

End
'Exit'
