/*****************************************************************************/
/*                                                                           */
/* REXX command file to remove all changed made to the OS2.INI file          */
/* during installation and make the profile obejct deletable.                */
/*                                                                           */
/* Copyright IBM Corp, 1992                                                  */
/*                                                                           */
/*****************************************************************************/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

'@ECHO OFF'

'@setobj "<EFDPASPROPERTIES>" "NODELETE=NO" 1>nul 2>&1'

result = SysIni(,'EFDIprocs','BaseTemplatesInstalled','DELETE:')
result = SysIni(,'EFDIprocs','ADTemplatesInstalled','DELETE:')

/*************************************************/
/* Deregister any previously registered classes. */
/*************************************************/

old_classes.0 = 25
old_classes.1 = 'EFDGenericIproc'
old_classes.2 = 'EFDChartsIproc'
old_classes.3 = 'EFDChartIproc'
old_classes.4 = 'EFDTableIproc'
old_classes.5 = 'EFDProcedureIproc'
old_classes.6 = 'EFDProceduresIproc'
old_classes.7 = 'EFDApplicationIproc'
old_classes.8 = 'EFDCalculatorIproc'
old_classes.9 = 'EFDCommandIproc'
old_classes.10= 'EFDQueryIproc'
old_classes.11= 'EFDReportIproc'
old_classes.12= 'EFDSchemaIproc'
old_classes.13= 'EONMakeIproc'
old_classes.14= 'EONMenuIproc'
old_classes.15= 'EONProgramIproc'
old_classes.16= 'EONWindowIproc'
old_classes.17= 'EOKGanttIproc'
old_classes.18= 'EOKLogicIproc'
old_classes.19= 'EOKProjectIproc'
old_classes.20= 'EOKCalendarIproc'
old_classes.21= 'EOKResourceIproc'
old_classes.22= 'EOKActivityIproc'
old_classes.23= 'EOLStatisticsIproc'
old_classes.24= 'EOJPlanIproc'
old_classes.25= 'EFDProperties'

call SysQueryClassList "class_list."
old_class_already_found = 0
do i = 1 to class_list.0
  PARSE VAR class_list.i class dll .
  do j = 1 to old_classes.0
    if class = old_classes.j then
    do
      if \ old_class_already_found then
      do
        old_class_already_found = 1
        say ' '
        say 'Deregistering previously registered PAS classes:'
      end
      say '    ' || class
      call SysDeregisterObjectClass class
    end
  end
end

say ' '
say 'Clearing out template entries from the OS2.INI file.'
result = SysIni(,'PM_Workplace:Templates','ALL:','output')
do i = 1 to output.0
  string = substr(output.i,1,3)
  if((string = 'EFD') | (string = 'EOJ') | (string = 'EOK') | (string = 'EOL') | (string = 'EON'))then
  do
    result = SysIni(,'PM_Workplace:Templates',output.i,'DELETE:')
  end
end

say ' '
say 'De-registering PAS file types from the shell.'

pas_types.0  = 21
pas_types.1  = 'IBMAPPLICATN'
pas_types.2  = 'IBMCALCULATOR'
pas_types.3  = 'IBMCHART'
pas_types.4  = 'IBMCOMMAND'
pas_types.5  = 'IBMPROCEDURE'
pas_types.6  = 'IBMQUERY'
pas_types.7  = 'IBMREPORT'
pas_types.8  = 'IBMSCHEMA'
pas_types.9  = 'IBMTABLE'
pas_types.10 = 'IBMGANTT'
pas_types.11 = 'IBMLOGIC'
pas_types.12 = 'IBMPROJECT'
pas_types.13 = 'IBMCALENDAR'
pas_types.14 = 'IBMRESOURCE'
pas_types.15 = 'IBMACTIVITY'
pas_types.16 = 'IBMMAKE'
pas_types.17 = 'IBMMENU'
pas_types.18 = 'IBMPROGRAM'
pas_types.19 = 'IBMWINDOW'
pas_types.20 = 'IBMPLAN'
pas_types.21 = 'IBMSTATISTICS'
result = SysIni(,'PMWP_ASSOC_TYPE','ALL:','output')
do i = 1 to output.0
  do j = 1 to pas_types.0
    if output.i = pas_types.j then
    do
      result = SysIni(,'PMWP_ASSOC_TYPE',output.i,'DELETE:')
      leave
    end
  end
end

say ' '
say ' ** The PAS IPROCS have been de-installed and you must now RE-BOOT **'
say ' '
exit

Exit 0
