/* PSF/2 Corrective Service Diskette install CMD file   930524    */
  /* Check to see if called as part of update process             */
  PARSE ARG control etc.;
  IF control<>'20G0759' THEN CALL HELP;
  /* Initialize program variables                                 */
  CALL INIT;

  /* Check to make sure PSF/2 is installed, and path is valid for */
  /* setting attributes.  Set attributes to R/W.                  */
  IF FILESTATE(psf2bin'\'baseexe)<>0 THEN
    'attrib -r 'psf2path'\*.* /S';
  ELSE IF FILESTATE(psf2tt'\'ttexe)<>0 THEN
    'attrib -r 'psf2patt'\*.* /S';

  /* Erase file DUVSREB.EXC if it exists                          */
  IF FILESTATE(psf2tt'\DUVSREB.EXC')<>0 THEN
    'erase 'psf2tt'\DUVSREB.EXC ';

  /* Erase file DUVSRMSG.EXC if it exists                         */
  IF FILESTATE(psf2tt'\DUVSRMSG.EXC')<>0 THEN
    'erase 'psf2tt'\DUVSRMSG.EXC ';

  /* Erase file DUVSREB.EXE if it exists                          */
  IF FILESTATE(psf2tt'\DUVSREB.EXE')<>0 THEN
    'erase 'psf2tt'\DUVSREB.EXE ';

  /* Erase file DUVSRMSG.EXE if it exists                         */
  IF FILESTATE(psf2tt'\DUVSRMSG.EXE')<>0 THEN
    'erase 'psf2tt'\DUVSRMSG.EXE ';

  /* Erase file DUVSREBM.MVS if it exists                         */
  IF FILESTATE(psf2tt'\DUVSREBM.MVS')<>0 THEN
    'erase 'psf2tt'\DUVSREBM.MVS ';

  /* Erase file DUVS5AEX.MVS if it exists                         */
  IF FILESTATE(psf2tt'\DUVS5AEX.MVS')<>0 THEN
    'erase 'psf2tt'\DUVS5AEX.MVS ';

  /* Erase file DUVSREBM.VM if it exists                          */
  IF FILESTATE(psf2tt'\DUVSREBM.VM')<>0 THEN
    'erase 'psf2tt'\DUVSREBM.VM ';

  /* Erase file DUVS5AEX.VM if it exists                          */
  IF FILESTATE(psf2tt'\DUVS5AEX.VM')<>0 THEN
    'erase 'psf2tt'\DUVS5AEX.VM ';

  /* Erase file DUVSLINK.JCL if it exists                         */
  IF FILESTATE(psf2tt'\DUVSLINK.JCL')<>0 THEN
    'erase 'psf2tt'\DUVSLINK.JCL ';

  /* Backup TT configuration file if it exists, and erase file    */
  /* DUVSHOST.CMD                                                 */
  IF FILESTATE(psf2tt'\DUVSHOST.CMD')<>0 THEN
  DO
    'copy 'psf2tt'\DUVSHOST.CMD 'psf2tt'\DUVSHOST.BAK';
    'erase 'psf2tt'\DUVSHOST.CMD ';
  END;

  /* Erase file DOSWORD.BOO if it exists                          */
  IF FILESTATE(psf2path'\DOSWORD.BOO')<>0 THEN
    'erase 'psf2path'\DOSWORD.BOO ';
  IF FILESTATE(psf2patt'\DOSWORD.BOO')<>0 THEN
    'erase 'psf2patt'\DOSWORD.BOO ';

  /* Erase file NOVELL.BOO if it exists                           */
  IF FILESTATE(psf2path'\NOVELL.BOO')<>0 THEN
    'erase 'psf2path'\NOVELL.BOO ';
  IF FILESTATE(psf2patt'\NOVELL.BOO')<>0 THEN
    'erase 'psf2patt'\NOVELL.BOO ';

  /* Erase file TT.BOO if it exists                               */
  IF FILESTATE(psf2path'\TT.BOO')<>0 THEN
    'erase 'psf2path'\TT.BOO ';
  IF FILESTATE(psf2patt'\TT.BOO')<>0 THEN
    'erase 'psf2patt'\TT.BOO ';

  /* Erase file DOSWORD.APF if it exists                          */
  IF FILESTATE(psf2path'\DOSWORD.AFP')<>0 THEN
    'erase 'psf2path'\DOSWORD.AFP ';
  IF FILESTATE(psf2patt'\DOSWORD.AFP')<>0 THEN
    'erase 'psf2patt'\DOSWORD.AFP ';

  /* Erase file NOVTT.AFP if it exists                            */
  IF FILESTATE(psf2path'\NOVTT.AFP')<>0 THEN
    'erase 'psf2path'\NOVTT.AFP ';
  IF FILESTATE(psf2patt'\NOVTT.AFP')<>0 THEN
    'erase 'psf2patt'\NOVTT.AFP ';

  /* Erase file DOSWORD.TXT if it exists                          */
  IF FILESTATE(psf2path'\DOSWORD.TXT')<>0 THEN
    'erase 'psf2path'\DOSWORD.TXT ';
  IF FILESTATE(psf2patt'\DOSWORD.TXT')<>0 THEN
    'erase 'psf2patt'\DOSWORD.TXT ';

  /* Erase file NOVELL.TXT if it exists                           */
  IF FILESTATE(psf2path'\NOVELL.TXT')<>0 THEN
    'erase 'psf2path'\NOVELL.TXT ';
  IF FILESTATE(psf2patt'\NOVELL.TXT')<>0 THEN
    'erase 'psf2patt'\NOVELL.TXT ';

  /* Erase file TT.TXT if it exists                               */
  IF FILESTATE(psf2path'\TT.TXT')<>0 THEN
    'erase 'psf2path'\TT.TXT ';
  IF FILESTATE(psf2patt'\TT.TXT')<>0 THEN
    'erase 'psf2patt'\TT.TXT ';

  /* Erase file DOSWORD.INF if it exists                          */
  IF FILESTATE(psf2path'\DOSWORD.INF')<>0 THEN
    'erase 'psf2path'\DOSWORD.INF ';
  IF FILESTATE(psf2patt'\DOSWORD.INF')<>0 THEN
    'erase 'psf2patt'\DOSWORD.INF ';

  /* Erase file NOVELL.INF if it exists                           */
  IF FILESTATE(psf2path'\NOVELL.INF')<>0 THEN
    'erase 'psf2path'\NOVELL.INF ';
  IF FILESTATE(psf2patt'\NOVELL.INF')<>0 THEN
    'erase 'psf2patt'\NOVELL.INF ';

  /* Erase file TT.INF if it exists                               */
  IF FILESTATE(psf2path'\TT.INF')<>0 THEN
    'erase 'psf2path'\TT.INF ';
  IF FILESTATE(psf2patt'\TT.INF')<>0 THEN
    'erase 'psf2patt'\TT.INF ';

  /* Erase file PRT.INF if it exists                              */
  IF FILESTATE(psf2path'\PRT.INF')<>0 THEN
    'erase 'psf2path'\PRT.INF ';
  IF FILESTATE(psf2patt'\PRT.INF')<>0 THEN
    'erase 'psf2patt'\PRT.INF ';

  /* Erase file WDRIVER.INF if it exists                          */
  IF FILESTATE(psf2path'\WDRIVER.INF')<>0 THEN
    'erase 'psf2path'\WDRIVER.INF ';
  IF FILESTATE(psf2patt'\WDRIVER.INF')<>0 THEN
    'erase 'psf2patt'\WDRIVER.INF ';

  /* Erase file PSF2.INF if it exists                             */
  IF FILESTATE(psf2path'\BINSHARE\BOOK\PSF2.INF')<>0 THEN
    'erase 'psf2path'\BINSHARE\BOOK\PSF2.INF ';
  IF FILESTATE(psf2patt'\BINSHARE\BOOK\PSF2.INF')<>0 THEN
    'erase 'psf2patt'\BINSHARE\BOOK\PSF2.INF ';

  /* Leave when finished                                          */
  CALL QUIT;
EXIT;
FILESTATE:; parse arg fid;
  /* This module tries to locate file. Returns >0 if file found   */
  rc=LENGTH(STREAM(fid,'C','QUERY EXISTS'));
RETURN(rc);
INIT:;
  /* Initialize program variables                                 */
  env='OS2ENVIRONMENT';
  psf2path=VALUE('AINCODEPATH',,env);
  psf2patt=VALUE('PSF2INST',,env);
  psf2pawk=VALUE('AINWORKPATH',,env);
  psf2bin=psf2path'\bin';
  psf2tt=psf2patt'\duvtt';
  dpfexe='AINHR.EXE';
  baseexe='AINMAIN.EXE';
  ttexe='DUVMAP.PRI';
RETURN;
HELP:;
  /* This module provides help                                    */
  say '**************************************************************';
  say '*  This CMD file must be run using UPDATE.                   *';
  say '**************************************************************';
  CALL QUIT;
RETURN;
QUIT:;
EXIT;
