/* PSF/2 Corrective Service Diskette install CMD file   930524    */
  /* Check to see if called as part of update process             */
  PARSE ARG control etc.;
  IF control<>'20G0759' THEN CALL HELP;

  /* Initialize program variables                                 */
  CALL INIT;

  /* Backup version file if it exists                             */
  IF FILESTATE(psf2pawk'\VERSION')<>0 THEN
    'copy 'psf2pawk'\VERSION 'psf2pawk'\VERSION.BAK';

  /* Check for DPF installed and use appropriate control file     */
  IF FILESTATE(psf2bin'\'baseexe)=0 THEN ctlfile='updateb.ctl';
  ELSE IF FILESTATE(psf2bin'\'dpfexe)=0 THEN ctlfile='updated.ctl';
  ELSE ctlfile='update.ctl';

  /* Perform the install                                          */
  'install /M 'ctlfile;

  /* Update the profiles                                          */
  IF (ctlfile <> 'updateb.ctl') THEN
    psf2bin'\fixprof.exe';

  /* Leave when finished                                          */
  CALL QUIT;
EXIT;
FILESTATE:; parse arg fid;
  /* This module tries to locate file. Returns >0 if file found   */
  rc=LENGTH(STREAM(fid,'C','QUERY EXISTS'));
RETURN(rc);
INIT:;
  /* Initialize program variables                                 */
  env='OS2ENVIRONMENT';
  psf2path=VALUE('AINCODEPATH',,env);
  psf2patt=VALUE('PSF2INST',,env);
  psf2pawk=VALUE('AINWORKPATH',,env);
  psf2bin=psf2path'\bin';
  psf2tt=psf2patt'\duvtt';
  dpfexe='AINHR.EXE';
  baseexe='AINMAIN.EXE';
  ttexe='DUVMAP.PRI';
RETURN;
HELP:;
  /* This module provides help                                    */
  say '**************************************************************';
  say '*  This CMD file must be run using UPDATE.                   *';
  say '**************************************************************';
  CALL QUIT;
RETURN;
QUIT:;
EXIT;
