@echo off
echo.
echo PC Tools for Windows 2.0
echo March 22, 1994 Patch
echo.
echo      Allows DiskFix, Optimizer, Undelete, and Wipe Delete features of
echo      PC Tools for Windows 2.0 to work when Windows for Workgroups 3.11
echo      32-bit File Access (VFAT) is enabled.
echo.
echo      Copyright (C)1994 Central Point Software, Inc.
echo      Portions Copyright (C)1994 Microsoft Corp.
echo.

REM
REM Make sure required parameters are present.
REM
if '%1'=='' goto BADPARAMS
if '%2'=='' goto BADPARAMS

REM
REM Make sure specified Windows directory is valid and contains Windows
REM for Workgroups 3.11.
REM
chkdate %2\SYSTEM.INI
if errorlevel 1 goto BADWINDOWS
chkdate %2\SYSTEM\VFAT.386 /t0311
if errorlevel 1 goto BADWINDOWS

REM
REM Make sure specified PC Tools for Windows 2.0 directory is valid and
REM contains valid version 2.0 installation.
REM
chkdate %1\WNCPS2.DLL /d940122 /t0200
if errorlevel 3 goto CHECKGERMAN
if errorlevel 1 goto BADPCTW
goto CHECKLANGUAGE

:CHECKGERMAN
chkdate %1\WNCPS2.DLL /d940202 /t0200
if errorlevel 3 goto CHECKFRENCH
if errorlevel 1 goto BADPCTW
goto CHECKLANGUAGE

:CHECKFRENCH
chkdate %1\WNCPS2.DLL /d940203 /t0200
if errorlevel 3 goto BADPCTWVERSION
if errorlevel 1 goto BADPCTW
goto CHECKLANGUAGE

:CHECKLANGUAGE

REM
REM Make sure at least one language directory exists.
REM

if exist %1\ENGLISH\WNCPS2L.RSL goto BEGINPATCH
if exist %1\GERMAN\WNCPS2L.RSL goto BEGINPATCH
if exist %1\FRENCH\WNCPS2L.RSL goto BEGINPATCH

goto BADPCTWNOLANGUAGE

:BEGINPATCH

REM
REM Begin patch process
REM

echo.
echo Patching PC Tools for Windows files....
patch %1 base.rtp
if not exist %1\english\wncps2l.rsl goto SYSCONFRGR
patch %1 sc_us.rtp
goto PATCHENGLISH

:SYSCONFRGR
patch %1 sc_frgr.rtp

:PATCHENGLISH
if not exist %1\english\wncps2l.rsl goto PATCHGERMAN
echo Patching English language files....
patch %1\english english.rtp

:PATCHGERMAN
if not exist %1\german\wncps2l.rsl goto PATCHFRENCH
echo Patching German language files....
patch %1\german german.rtp

:PATCHFRENCH
if not exist %1\french\wncps2l.rsl goto COPYVXDS
echo Patching French language files....
patch %1\french french.rtp

:COPYVXDS
echo.
echo Copying virtual device drivers to %2\SYSTEM directory....
copy VFATHLP.386 %2\SYSTEM\VFATHLP.386
copy CP32SUP.386 %2\SYSTEM\CP32SUP.386

:ADDTOINI
echo Adding device drivers to %2\SYSTEM.INI file....
addini %2\SYSTEM.INI PATCH01.INI
if errorlevel 1 goto ADDINIERROR
echo.
echo Your old %2\SYSTEM.INI file has been renamed to
echo %2\SYSTEM.PT? where ? can be a number from 0 to 9.
echo.

:ENDPATCH

echo *** PATCH INSTALLATION COMPLETE ***
echo.

goto END

:ADDINIERROR

echo.
echo An error occurred while attempting to configure your
echo %2\SYSTEM.INI file.  Your previous SYSTEM.INI file
echo has been restored.  If there is a %2\SYSTEM.PTC file
echo on your system, this file contains the changes that were attempted.
echo.
echo Possible causes for the error include:
echo      PATCH01.INI does not exist in the directory containing PATCH01.BAT.
echo      SYSTEM.INI is marked as a system, hidden, or read-only file.
echo      The drive containing Windows is full or write-protected.
echo.
echo Please refer to the README file to complete the patch installation.
echo.

goto END

:BADPCTWNOLANGUAGE

echo.
echo No language resource directory was detected immediately under the
echo specified PC Tools for Windows directory,
echo %1.
echo If you have placed the language files somewhere other than the default
echo location, a manual patch installation is necessary.

goto BADPARAMS

:BADPCTW

echo.
echo The PC Tools for Windows directory you specified,
echo %1,
echo does not contain a PC Tools for Windows installation.

goto BADPARAMS

:BADPCTWVERSION
echo.
echo The PC Tools for Windows directory you specified,
echo %1,
echo does not contain a version 2.0 installation.

goto BADPARAMS

:BADWINDOWS

echo.
echo The Windows directory you specified,
echo %2,
echo is not a valid Windows directory, or it does not contain Windows for
echo Workgroups 3.11.

goto BADPARAMS

:BADPARAMS

echo.
echo Syntax:
echo.
echo    PINSTALL [PCTW2 Directory] [Windows Directory]
echo.
echo    Directories must be completely specified, including drive letter.
echo    Do not include a trailing backslash when specifying directories.
echo    e.g., PINSTALL D:\CPS D:\WINDOWS
echo.
echo    If you specified both directories and you are certain that the
echo    directories are valid, then a manual installation of the patch may be
echo    necessary.  Please refer to the README file for instructions on how to
echo    perform a manual install.
echo.

goto END

:END
