#ifndef USERTSR_H
#define USERTSR_H

/*------------------------------------------------------------------------*/
/* defines                                                                */
/*------------------------------------------------------------------------*/
#define TSR_SIGNATURE               0x38F6
#define TSR_INTERRUPT               0x7c
#define DRIVER_TYPE_USERPROC        'U'
#define DRIVER_LABEL_SIZE           8

#define USERPROC_ALPHA              'A'       /* parameter is string   */
#define USERPROC_LONG               'L'       /* -/- pointer to long   */
#define USERPROC_DOUBLE             'D'       /* -/- pointer to double */
#define USERPROC_PASCAL             0xff      /* Pascal function flag  */

#define MODULE_LABEL_LEN            DRIVER_LABEL_SIZE
#define FUNC_NAME_LEN               20

#define NULL_PTR                    ((void far *) 0)
#define MIN(a,b)                    (((a) < (b)) ? (a) : (b))

#define USERPROC_MAX_PARM           16    /* maximum number of parameters */

/*------------------------------------------------------------------------*/
/* types                                                                  */
/*------------------------------------------------------------------------*/
typedef
   unsigned char Uchar;
typedef
   unsigned short Ushort;
typedef
   unsigned long Ulong;

typedef     /* structure used internally for communication */
   struct
   {
      void far *next_tsr_item;
      Ushort    sign;                          /* must be TSR_SIGNATURE */
      Ushort    psp_seg;
      Ushort    driver_type;                   /* DRIVER_TYPE_USERPROC */
      Uchar     driver_label[DRIVER_LABEL_SIZE];
      void far *driver_info;
      Ushort    use_cnt;
   } TSR_ITEM;

typedef     /* structure defining module function */
   struct
   {
       Uchar far *func_name;      /* name of function              */
       void  far *func_addr;      /* pointer to function           */
       Ushort     arg_cnt;        /* number of arguments           */
       Uchar far *arg_attrs;      /* string of attributes A,L,D    */
       Ushort     flags;          /* USERPROC_PASCAL - Pascal mode */
   }  FUNC_DSC;

typedef     /* structure defining module */
   struct
   {
      Ushort         use_cnt;         /* number of magics used by      */
      void     far  *ini_func_addr;   /* called upon initialization    */
      void     far  *trm_func_addr;   /* called upon termination       */
      Ushort         func_cnt;        /* number of functions in module */
      FUNC_DSC far  *func_dsc_tbl;    /* function table                */
      Uchar    far  *module_name;     /* name of module                */
      Ushort         context_hdl;
   } TSR_MODULE;

/*-----------------------------------------------------------------------*/
/* Functions                                                             */
/*-----------------------------------------------------------------------*/
void cdecl userproc_tsr (TSR_MODULE *tsr_module, Ulong mem_required);

#endif /* USERTSR_H */

