/*------------------------------------------------------------------------*/
/* This module contains the USERPROC startup routine, userproc_tsr().     */
/* The startup routine is called first thing from within the main()       */
/* function, and its purpose is to setup internal structures and to       */
/* locate the .EXE as a TSR.  You should not have to modify this module.  */
/*------------------------------------------------------------------------*/
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#define USERTSR_C
#include "usertsr.h"

/*-----------------------------------------------------------------------*/
/* vars                                                                  */
/*-----------------------------------------------------------------------*/
static Ushort   TSR_INT = TSR_INTERRUPT;
static TSR_ITEM TSR_item =
   {NULL_PTR, TSR_SIGNATURE, 0, DRIVER_TYPE_USERPROC, {0}, NULL_PTR};

/*------------------------------------------------------------------------*/
/*                                                                        */
/*------------------------------------------------------------------------*/
void cdecl userproc_tsr (TSR_MODULE *tsr_module, Ulong mem_required)
{
   Ushort   far *mem_high;
   TSR_ITEM far **tsr_base;
   TSR_ITEM     *tsr_item;
   Uchar        *env_str;
   Uchar        *tmp_str;
   union  REGS  regs;
   int          len;
   Ushort       mem_amount;
   int          alloc_cnt;
   Uchar       *alloc_ptr[10];
   void    far *p;

   /*--------------------*/
   /* fill new structure */
   /*--------------------*/
   TSR_item.driver_info = tsr_module;
   memset (TSR_item.driver_label, ' ', DRIVER_LABEL_SIZE);
   len = strlen ((char *) tsr_module->module_name);
   if (len > DRIVER_LABEL_SIZE)
      len = DRIVER_LABEL_SIZE;
   memcpy (TSR_item.driver_label, tsr_module->module_name, len);

   /*------------------------------*/
   /* compute TSR interrupt        */
   /*------------------------------*/
   if((env_str = (Uchar *) getenv("MGTSR")) != NULL_PTR)
      TSR_INT = (Ushort) strtol ((char *) env_str, (char **) &tmp_str, 16);

   /*-------------------------*/
   /* check if loaded already */
   /*-------------------------*/
   FP_SEG (tsr_base) = 0;
   FP_OFF (tsr_base) = TSR_INT * 4;
   tsr_item = *tsr_base;
   while (tsr_item != NULL_PTR)
   {
      if (tsr_item->sign == TSR_SIGNATURE &&
          tsr_item->driver_type == TSR_item.driver_type &&
          memicmp (tsr_item->driver_label, TSR_item.driver_label,
                   DRIVER_LABEL_SIZE) == 0)
         return;
      tsr_item = tsr_item->next_tsr_item;
   }

   /*------------------------------*/
   /* leave hole for needed memory */
   /*------------------------------*/
   alloc_cnt = 0;
   while (mem_required > 0L)
   {
      mem_amount = (Ushort) MIN (64000L, mem_required);
      mem_required -= (Ulong) mem_amount;
      alloc_ptr[alloc_cnt++] = malloc (mem_amount);
   }
   mem_high = malloc (1);    /* dead byte! */
   while (alloc_cnt > 0)
      free (alloc_ptr[--alloc_cnt]);

   /*----------------*/
   /* set our vector */
   /*----------------*/
   FP_SEG (tsr_base) = 0;
   FP_OFF (tsr_base) = TSR_INT * 4;

   /*------------------------------*/
   /* fix new structure in a chain */
   /*------------------------------*/
   TSR_item.psp_seg = _psp;
   p = &TSR_item;
   tsr_module->context_hdl = FP_SEG(p);    /* TSR's DS register */
   TSR_item.next_tsr_item = *tsr_base;
   *tsr_base = &TSR_item;

   /*----------*/
   /* make TSR */
   /*----------*/
   regs.x.ax = 0x3100;
   regs.x.dx = FP_SEG(mem_high) - _psp + (2048 >> 4) + 2;
   intdos (&regs, &regs);
}

