
/*

$Header: unix2dos.c

$Project: <NFS for Netware/386>, <UNIX To DOS translation util - DOS version>

$Creator: <Wen H. Chiu>	$

$Locker:  $

$Source: /proj/nwnfs2/REL2.0/s_xlat/unix/RCS/unix2dos.c,v $


 *****************************************************************************
 *
 *	(C) Copyright 1989, 1990 Novell, Inc.
 *	All Rights Reserved.
 *
 *	This program is an unpublished copyrighted work which is proprietary
 *	to Novell, Inc. and contains confidential information that is not
 *	to be reproduced or disclosed to any other person or entity without
 *	prior written consent from Novell, Inc. in each and every instance.
 *
 *	WARNING:  Unauthorized reproduction of this program as well as
 *	unauthorized preparation of derivative works based upon the
 *	program or distribution of copies by sale, rental, lease or
 *	lending are violations of federal copyright laws and state trade
 *	secret laws, punishable by civil and criminal penalties.
 *
 ****************************************************************************

*/

#include <stdio.h>
#include <fcntl.h>
#include <project.h>

#define START 0
#define CRFOUND 1

#define RBYTES 4096

char rbuf[RBYTES];
FILE *rfp;

print_argmsg()
{
	printf("\n  Usage: unix2dos source_file [ > dest_file]\n");
	exit(-1);
}

print_rmsg(file)
char *file;
{
	printf("read error from source file %s\n", file);
	fclose(rfp);
	exit(-1);
}

print_wmsg(file)
char *file;
{
	printf("write error to destination file %s\n", file);
	fclose(rfp);
	exit(-1);
}

main(argc, argv)
int argc;
char *argv[];
{
	int rlen, len, i;
	char c;

	if (argc < 2)
		print_argmsg();

	if (!(rfp=fopen(argv[1], "rb"))) {
		printf("can't open source file %s\n", argv[1]);
		exit(-1);
	}

#ifdef ON_DOS
	/* set mode of stdout to binary */
	if ((setmode(fileno(stdout), O_BINARY)) == 1) {
		printf("can't set stdout to binary mode\n");
		exit(-1);
	}
#endif

	do {
		if ((rlen=fread(rbuf, 1, RBYTES, rfp)) == -1)
			print_rmsg(argv[1]);

		if (rlen == 0)
			break;

		len = rlen;
		i = 0;
		while (len--) {
			c = rbuf[i++];
			switch (c) {
				case '\n':
					if (fwrite("\r\n", 1, 2, stdout) < 2)
						print_wmsg(argv[2]);
					break;
				default:
					if (fwrite(&c, 1, 1, stdout) < 1)
						print_wmsg(argv[2]);
					break;
			};
		};
	} while (rlen == RBYTES);
	
	fclose(rfp);
	exit(0);
}
