#ifndef __PCBTOOLS_H
#define __PCBTOOLS_H

#define bool  char
#define TRUE  1
#define FALSE 0

#ifndef SEEK_CUR
#define SEEK_CUR        1
#define SEEK_END        2
#define SEEK_SET        0
#endif

/* use byte alignment for all structure in this header file */
#if defined _MSC_VER
#pragma pack(1)
#elif __TURBOC__ >= 0x400
#pragma option -a-
#endif

#define  OPEN_DENYRDWR 0x10     /* share mode: deny read/write */
#define  OPEN_DENYWRIT 0x20     /* share mode: deny write access */
#define  OPEN_DENYREAD 0x30     /* share mode: deny read access */
#define  OPEN_DENYNONE 0x40     /* share mode: deny none */
#define  OPEN_READ     0x00     /* open for read access */
#define  OPEN_WRIT     0x01     /* open for write access */
#define  OPEN_RDWR     0x02     /* open for read/write access */
#define  OPEN_APPEND   0x04     /* added to OPEN_WRIT, opens for APPEND */
#define  OPEN_CREATE   0x08     /* added to OPEN_WRIT. makes a NEW file */
#define  OPEN_ALREADY  0x100    /* used to dup an opened file handle */
#define  OPEN_NORMAL   0x00     /* create normal attribute file */
#define  OPEN_RDONLY   0x01     /* create read-only file */
#define  OPEN_HIDDEN   0x02     /* create hidden file */
#define  OPEN_SYSTEM   0x04     /* create system file */
#define  OPEN_VOLUME   0x08     /* create volume label */

#define CUR_BLANK   0
#define CUR_NORMAL  1
#define CUR_BLOCK   2
#define CUR_INSERT  3

#define CNF_USR      0
#define CNF_REG      ConfByteLen
#define CNF_EXP      ConfByteLen * 2
#define CNF_CON      ConfByteLen * 3
#define CNF_MFL      ConfByteLen * 4
#define CNF_JOINED   0
#define CNF_SCANNED  ConfByteLen

#define TRIGGER1   0
#define TRIGGER4   64
#define TRIGGER8   128
#define TRIGGER14  192

#ifndef PCBTOOLS_HDR
#define PCBTOOLS_HDR


enum {SEC_A=0,SEC_B,SEC_C,SEC_D,SEC_E,SEC_F,SEC_G,SEC_H,SEC_I,SEC_J,SEC_K,
SEC_L,SEC_M,SEC_N,SEC_O,SEC_P,SEC_Q,SEC_R,SEC_S,SEC_T,SEC_U,SEC_V,SEC_W,SEC_X,
SEC_Y,SEC_Z,SEC_OPEN,SEC_CHAT,SEC_REG,SEC_NONREG,SEC_USER,SEC_WHO,SEC_BATCH,
SEC_EDIT,SEC_TEST,USERSEC };

enum {SEC_READCOMMENTS=0,SEC_READALLMAIL,SEC_SYSOPLEVEL,SEC_MOVEMSG,SEC_1,
SEC_2,SEC_3,SEC_4,SEC_5,SEC_6,SEC_7,SEC_8,SEC_9,SEC_10,SEC_11,SEC_12,SEC_13,
SEC_14,SEC_SUBS,SEC_EDITALL,SEC_READONLY,SEC_15,SEC_BROADCAST,SEC_VIEWPRIV,
SEC_GENERICMSGS,SEC_EDITHDR,SEC_PROTECT,SEC_OVERWRITE,SEC_UNUSED,SEC_KEEPMSG,
SEC_SEERETRCPT,SYSOPSEC };

enum {PCB_BLUE=9, PCB_GREEN, PCB_CYAN, PCB_RED, PCB_MAGENTA, PCB_YELLOW, PCB_WHITE };
enum {NOHELP,HLP_MORE};

typedef enum {WATCHKBD=1, WATCHSESSION=2, READUSERSYS=4, SHOWSTATUSLINE=8, LMRS=16, CONFFLAGS=32, TPA=64, NOCLS=128} openstatus;
typedef enum {NONE, BLANKLINE, HELP, NAME, CONFREG, COMMENT, MODEMSTATS } statlinetype;
typedef enum {OFFLINE, LOCAL, REMOTE } onlinetype;
typedef enum {DEFAULTS=0,ECHODOTS=1,FIELDLEN=2,UPCASE=4,STACKED=8,ERASELINE=16,NEWLINE=32,LFBEFORE=64,LFAFTER=128,LOGIT=256,LOGITLEFT=512,GUIDE=1024,WORDWRAP=2048,YESNO=2049,NOCLEAR=4096,BELL=8192,HIGHASCII=16384,AUTO=32768U} displaytype;
typedef enum {MOREPROMPT,PRESSENTER } moretype;
typedef enum {NOALTERNATE=0,GRAPHICS=1,SECURITY=2,LANGUAGE=4} displayfiletype;
typedef enum {LEFTJUSTIFY, SPACERIGHT } padtype;
typedef enum {NOCHANGE,FORCENONSTOP,FORCECOUNTLINES} startdisplaytype;
typedef enum {NEWTIME, CONFTIME, CREDTIME} timereasontype;
typedef enum {SHELLDIRECT, SHELLVIACOMMAND} shelltype;
typedef enum {WAITFOROKAY, DONTWAIT} modemverifytype;

#ifndef BASREAL
  #define BASREAL  1
  typedef unsigned char bassngl[4];
  typedef unsigned char basdble[8];
#endif

typedef struct {      /* struct used with dosfopen, dosfgets, & dosfclose */
  int      handle;    /* dos file handle */
  char     *buffer;   /* pointer to buffer space */
  unsigned bufsize;   /* size of the buffer associated with this file */
  unsigned offset;    /* offset of current pointer in buffer space */
  unsigned end;       /* last valid character in buffer space */
  bool     status;    /* file status indicator */
} DOSFILE;

typedef struct {
  bool         PrintLog;               /* TRUE if the 'log' printer is turned on */
  bool         Alarm;                  /* TRUE if the alarm is toggled on */
  bool         ForceScreenOff;         /* TRUE if the screen was FORCED off by pressing F9 */
  bool         LoggingUserOff;         /* TRUE if we're in the process of logging the user off */
  bool         TimeAdjustedForEvent;   /* TRUE if the time online has been adjusted */
  bool         Kbd;                    /* TRUE if last char was input from the keyboard */
  bool         InChat;                 /* TRUE if we are currently in sysop chat */
  bool         Poff;                   /* TRUE if @POFF@ was issued */
  bool         KbdTimedOut;            /* TRUE if keyboard timer expired */
  bool         UseAlias;               /* TRUE if user wants to use his alias */
  char         SysopFlag;              /* 'N' of Sysop Next, 'X' if Exit to DOS or ' ' */
  char         FirstName[26];          /* the first name of the caller */
  char         DisplayName[26];        /* real name or sysop name */
  char         LastDateOnStr[9];       /* from users file - last date on */
  statlinetype StatLine;               /* type of help displayed on status line */
  statlinetype OldStatLine;            /* previous value of StatLine */
  long         UserRecNo;              /* record number in the users file */
  int          SuspendMinute;          /* time when activity should be suspended */
  int          EventMinute;            /* time when event should be run */
  int          EndEventMinute;         /* last minute possible for event to run */
  int          LogonMinute;            /* time when the caller logged on in minutes since midnight */
  int          CreditMinutes;          /* time credit for uploads and sysop chat */
  unsigned     JulianLogonDate;        /* date when the caller logged on (julian) */
  char         LogonDate[9];           /* date when the caller logged on (MM/DD/YY) */
  char         LogonTime[9];           /* time when the caller logged on (HH:MM:SS) */
  unsigned     Conference;             /* current conference number */
  int          CurSecLevel;            /* current security level */
  bool         WatchForStopChar;       /* used to signal when StopChar is monitored */
  char         StatusLine1;            /* line number of top status line */
  char         StatusLine2;            /* line number of top status line */
  int          ConfAddSec;             /* added security from joining a conference */
  int          ConfAddTime;            /* added time from joining a conference */
  int          SysLimit;               /* caller's time limit from pcboard.sys */
  int          OverrideLimit;          /* SessionLimit passed to initdoor() */
  char         Language;               /* number of language chosen */
  char         MultiLangExt[5];        /* filename extension for multilingual operation */
  bool         AppendText;             /* indicate DisplayText should be appended */
  char         DisplayText[80];        /* special @-variable display text */
} statustype;

typedef struct {
  bool     Screen;            /* TRUE if the screen should be displayed */
  bool     GraphicsMode;      /* TRUE if caller requested graphics */
  bool     RipMode;           /* TRUE if caller requested RIP graphics */
  bool     WatchKbdClock;     /* FALSE if we want to ignore the KEYBOARD clock */
  bool     WatchSessionClock; /* FALSE if we want to ignore the SESSION clock */
  unsigned KbdTimer;          /* Number of clock ticks for keyboard timer */
  char     WarnMinute;        /* Minute to warn on prior to session timeout */
} controltype;

typedef struct {
  char       ComPortNumber;     /* e.g. COM1 = 1 */
  char       DataBits;          /* e.g. 8 or 7 */
  onlinetype Online;            /* type of online connection */
  long       CarrierSpeed;      /* modem to modem speed */
  long       ConnectSpeed;      /* connect speed displayed to caller */
  long       ModemSpeed;        /* pc to modem speed */
  bool       LostCarrier;       /* TRUE if carrier was lost */
  bool       IgnoreCDLoss;      /* TRUE if we need to process something after CD is lost */
  bool       ErrorCorrected;    /* TRUE if caller logged on in error corrected mode */
  bool       HstMode;           /* TRUE if we detected an HST modem */
} asytype;

typedef struct {
  bool         AbortPrintout;    /* TRUE if system should abort a printout */
  bool         CountLines;       /* TRUE if system is currently counting lines displayed */
  unsigned char NumLinesPrinted; /* a count of the number of lines displayed since last pause */
  bool         AutoMore;         /* TRUE if auto answer more? prompt after 10 seconds */
  bool         WasNonStop;       /* TRUE if last printout was in non-stop mode */
  bool         WasAborted;       /* TRUE if last printout was aborted */
  unsigned char PageLen;         /* caller's current page length */
  bool         ShowOnScreen;     /* TRUE if data should be shown on screen */
  bool         Break;            /* TRUE if current display can be interrupted at the More Prompt */
  char         DefaultColor;     /* default caller as chosen by the sysop */
  char         NumScrnLines;     /* number of lines on the local display screen */
} disptype;

typedef struct {
  char Version[52];        /* pcboard version */
  char Sysop[16];          /* sysop display name */
  char Password[14];       /* sysop local password */
  bool UseRealName;        /* true if use sysop real name instead of 'SYSOP' */
  bool Graphics;           /* graphics in local mode */
  int  SysopSec[SYSOPSEC]; /* sysop function security levels */
  char HlpLoc[32];         /* location of help files */
  char SecLoc[32];         /* location of security message files */
  char ChtLoc[32];         /* location of chat files */
  char TxtLoc[32];         /* location of pcbtext files */
  char NdxLoc[32];         /* location of index files */
  char TmpLoc[32];         /* location of temporary files */
  char UsrFile[32];        /* name of users file */
  char InfFile[32];        /* name of users info file */
  char ClrFile[32];        /* name and location of callers file */
  char CnfFile[32];        /* name and location of conference data file */
  char PwdFile[32];        /* name and location of pwrd file */
  char FscFile[32];        /* name and location of fsec file */
  char UscFile[32];        /* name and location of upsec file */
  char TcnFile[32];        /* name and location of tcan file */
  char WlcFile[32];        /* name and location of welcome file */
  char NewFile[32];        /* name and location of newuser file */
  char ClsFile[32];        /* name and location of closed file */
  char WrnFile[32];        /* name and location of warning file */
  char ExpFile[32];        /* name and location of expired file */
  char NetFile[32];        /* name and location of USERNET.DAT file */
  char CnfMenu[32];        /* name and location of conference join menu */
  char RegFile[32];        /* name and location of newreg file questions */
  char AnsFile[32];        /* name and location of non-reg user's answer file*/
  char TrnFile[32];        /* name and location of protocol data file */
  char DldFile[32];        /* name and location of download summary file */
  char LogOffScr[32];      /* name and loc of logoff script questionnaire */
  char LogOffAns[32];      /* name and loc of logoff script answers */
  char MultiLang[32];      /* name and loc of pcbml.dat file */
  char GroupChat[32];      /* name and loc of group chat topic/intro file */
  char ColorFile[32];      /* name and loc of PCBFILER.DEF file */
  unsigned char Seconds;   /* seconds to wait for connect */
  char ModemPort[8];       /* modem comm port (COM1:, COM2: or NONE) */
  long ModemSpeed;         /* modem baud rate */
  bool LockSpeed;          /* lock in the modem port speed */
  char ModemInit[42];      /* modem initialization string */
  char ModemOff[32];       /* modem off-hook string */
  bool DisableCTS;         /* disable CTS/RTS checking */
  bool NotUsed;            /* no longer used - undefined */
  bool FastComm;           /* using a FastComm */
  bool ResetModem;         /* perform modem reset during recycle */
  bool OffHook;            /* take modem off-hook during recycle */
  bool Packet;             /* running under a packet switch network */
  bool AnswerRing;         /* answer on true ring detect */
  bool Allow7E1;           /* allow 7,E,1 callers */
  bool AllowLowBaud;       /* allow low baud callers */
  char AllowLowStrt[6];    /* start time of low baud */
  char AllowLowStop[6];    /* stop time of low baud */
  long LowBaudLimit;       /* highest low baudrate denied */
  int  ModemDelay;         /* modem delay time */
  char RingsRequired;      /* number of rings required before picking up */
  char IrqNum;             /* IRQ number for non-standard comm ports */
  int  BaseAddress;        /* BASE address for non-standard comm ports */
  bool LeaveDtrUp;         /* leave DTR up on exit to DOS */
  bool ShareIRQs;          /* share IRQs on MCA buses */
  bool DisableScan;        /* disable message base scan prompt */
  bool DisableCls;         /* disable screen clear after 3 minutes */
  bool DisableEdits;       /* disable registration edits */
  bool DisableFilter;      /* disable high order ascii filter */
  bool DisableQuick;       /* disable quick logon */
  bool DisablePassword;    /* disable password check on return from DOS */
  bool MultiLingual;       /* support multi-lingual operation */
  bool AllowPwrdOnly;      /* allow only password changes */
  bool ClosedBoard;        /* run system as a closed board */
  bool NonGraphics;        /* run in non-graphics mode only */
  bool ExitToDos;          /* exit to dos after each caller */
  bool IncludeCity;        /* include user's city/state in node chat display */
  bool EliminateSnow;      /* eliminate screen snow */
  bool SubscriptMode;      /* run in subscription mode */
  bool AllowEscCodes;      /* allow ESC codes in messages */
  bool AllowCCs;           /* allow CC: messages */
  bool Validate;           /* valide TO: name */
  bool LastReadUpdate;     /* update Last Read pointer afer new msg */
  bool EnforceTime;        /* enforce daily time limit */
  char DisplayNews;        /* display news only if changed since last call */
  bool DisableCTSdrop;     /* disable CTS drop during disk writes */
  char KbdTimeout;         /* num of minutes for keyboard timeout */
  int  MaxScrollBack;      /* maximum lines in scrollback buffer */
  bool FastText;           /* pre-load pcbtext file */
  bool FastCnames;         /* pre-load cnames file */
  bool UploadBy;           /* include Upload By: in upload description */
  bool TestUploads;        /* test files after upload */
  bool ShowSettings;       /* include settings display on login */
  bool AllowShell;         /* allow shelling to DOS */
  bool Slaves;             /* use Slave Card updating */
  int  SubscriptionDays;   /* default days in new subscription period */
  int  SubscriptWarning;   /* days prior to subscription expiration */
  bool Network;            /* running under a network */
  int  NodeNum;            /* node number of this node */
  char NetTimeout;         /* network timeout delay (20-99 seconds) */
  char ChatDelay;          /* node chat delay inveral when idle (5-99 sec) */
  char BoardName[66];      /* name of board */
  char CapFile[9];         /* name of message capture file */
  char ViewBatch[32];      /* name and loc of batch file to view archives */
  char ViewExt[5];         /* archive extension */
  char FuncKeys[10][62];   /* function key definitions */
  unsigned NumConf;        /* number of conferences (1 thru 65534) */
  unsigned NumAreas;       /* number of conference areas (Main=1 thru 65535) */
  int  MaxMsgLines;        /* maximum message lines allowed (1-255) */
  char DefaultColor;       /* default foreground color */
  char DefaultIntensity;   /* default intensity (0 or 1) */
  bool EventActive;        /* timed event active */
  char EventTime[8];       /* time to activate event '00:00' */
  char EventSuspend;       /* minutes to suspend board activity before event */
  bool EventStopUplds;     /* stop uploads initiation during suspense time */
  bool EventSlide;         /* slide event if user online */
  char UploadBufSize;      /* upload buffer size (4-32) */
  bool DisableDriveCheck;  /* disable upload drive size check */
  char ParallelPortNum;    /* parallel port number (1-3 or 0) */
  unsigned StopFreeSpace;  /* stop uploads when free space < #K */
  int  MaxTotalMsgs;       /* total maximum messages in a capture file */
  int  MaxConfMsgs;        /* maximum messages per conference in capture */
  bool QuickScan;          /* default to 'Y Q' message scanning */
  bool ScanAll;            /* default to 'Y A' message scanning */
  char MinPriorToEvent;    /* stop upload minutes prior to an event */
  bool UseNewAskFile;      /* use NEWASK plus built-in questions */
  bool AllowOneName;       /* allow one-name users to log into system */
  char DefExpiredLevel;    /* default expired security level */
  bool StopClockOnCap;     /* stop the clock during capture file download */
  char SysopStart[6];      /* start time to allow sysop page */
  char SysopStop[6];       /* stop  time to allow sysop page */
  bool LogCallerNumber;    /* log caller number to disk */
  bool LogConnectStr;      /* log connect string to disk */
  bool LogSecLevel;        /* log security level to disk */
  bool ConfPwrdAdjust;     /* re-read PWRD upon joining a conference */
  bool ConfirmCaller;      /* confirm caller name */
  bool AllowPwrdComment;   /* allow password failure comment */
  bool GuardLogoff;        /* guard logoff command */
  char NumDescLines;       /* number of upload description lines */
  char UserLevels[USERSEC];/* user security levels */
  char ChatFile[32];       /* name and location of chat.dat */
  char StatsFile[33];      /* name and location of pcbstats.dat */
  char ChatMenu[33];       /* name and location of CHAT menu */
  char NoAnsi[33];         /* name and location of NOANSI file */
  char SlowDrives[27];     /* drive letters for slow drives */
  char SwapPath[33];       /* path to swap file */
  bool Swap;               /* swap out during normal shell? */
  bool NoBatchUp;          /* don't allow batch uploads / force first name */
  bool ForceMain;          /* force comments to main board */
  bool Foreign;            /* LineSeparator and tilde changes */
  bool MonitorModem;       /* watch for incompleted connections */
  bool No16550;            /* force 16550 to be treated as a 16450 */
  bool Force16550A;        /* force 16450 to be treated as a 16550 */
  bool AutoReset;          /* reset modem every 5 minutes while waiting */
  bool Float;              /* float node number */
  bool PromoteBatch;       /* promote D and U commands to DB and UB */
  bool AutoRegConf;        /* automatically register new user in all confs */
  bool ScanBlts;           /* scan bulletins when joining a conference */
  bool AutoMakeMsgs;       /* create msgs file if missing */
  bool VerifyCDLoss;       /* verify cd loss before recycling */
  bool Encrypt;            /* encrypt users file */
  int  UploadCredit;       /* time credit (times 10, i.e. 25 = 2.5 credit) */
  int  ByteCredit;         /* byte credit (times 10, i.e. 25 = 2.5 credit) */
  char NewDefaultColor;    /* color code for default color */
  char MsgHdr1Color;       /* color for DATE line of message header */
  char MsgHdr2Color;       /* color for TO   line of message header */
  char MsgHdr3Color;       /* color for FROM line of message header */
  char MsgHdr4Color;       /* color for SUBJ line of message header */
  char MsgHdr5Color;       /* color for READ line of message header */
  char MsgHdr6Color;       /* color for CONF line of message header */
  char Origin[61];         /* ORIGIN information */
  char EventDatFile[33];   /* name and location of EVENT.DAT */
  char EventFiles[33];     /* location of event files */
  char CmdLst[32];         /* name/location of CMD.LST to use for defaults */
  bool RequirePwrdToExit;  /* Require Local Password to drop PCBoard to DOS */
  int  EnvSize;            /* requested size for DOS's environment */
  char LowBaudSecOverride; /* Security Level to override low baud limit */
  char AllFilesList[33];   /* name and location of all files DLPATH.LST */
  bool EnableFido;         /* enable FIDO setup and processing */
  char FidoConfig[33];     /* FIDO import/export configuration file */
  char FidoIndex[33];      /* FIDO area index (conference cross-ref) */
  bool PromptToReadMail;   /* ask to read mail waiting */
  char LogOnScr[32];       /* name and loc of logon script questionnaire */
  char LogOnAns[32];       /* name and loc of logon script answers */
  char QwkFile[9];         /* name of qwk packet file */
  char FileTcan[32];       /* name of File Trashcan for stopping uploads */
  bool SwapDuringBat;      /* TRUE if $$logon or $$logoff.bat should swap */
  bool UserSysDuringBat;   /* TRUE if users.sys should be made for $$logon */
  bool DefaultGraphics;    /* TRUE to default to graphics mode on login */
  char SlowDriveBat[32];   /* batch file to run after slow-drive copy */
  bool AllowAliasChange;   /* TRUE if ALIAS can be changed after setting it */
  bool ExcludeLocals;      /* TRUE if local logins should be ignored */
  int  PwrdUpdate;         /* Number of days PWRD is valid before expiring */
  int  PwrdWarn;           /* Number of days prior to WARN of PWRD expiring */
  bool RecordGroupChat;    /* TRUE if group chat should be captured to disk */
  bool ShowAlias;          /* TRUE if sysop wants ALIAS shown in USERNET */
  char MinPwrdLen;         /* Minimum Password Length when PSA is installed */
  bool AllowHandles;       /* TRUE if handles are allowed in Group Chat */
} pcbdattype;

typedef struct {
  char Name[14];           /* conference name */
  bool PublicConf;         /* new user default registration */
  bool AutoRejoin;         /* auto-rejoin for this conference */
  bool ViewMembers;        /* allow viewing conference members */
  bool PrivUplds;          /* make uploads private */
  bool PrivMsgs;           /* make all messages private */
  bool EchoMail;           /* is this an Echo-Mail conference */
  int  ReqSecLevel;        /* security required to join PUBLIC conference */
  int  AddSec;             /* additional security level added after join */
  int  AddTime;            /* additional time added after join */
  char MsgBlocks;          /* number of message base index blocks */
  char MsgFile[32];        /* name and location of messages file */
  char UserMenu[32];       /* name and location of Users Menu */
  char SysopMenu[32];      /* name and location of Sysops Menu */
  char NewsFile[32];       /* name and location of Conference News */
  char PubUpldSort;        /* sort type for public upload DIR file */
  char UpldDir[29];        /* name and location of public upload DIR file */
  char PubUpldLoc[26];     /* public upload location */
  char PrvUpldSort;        /* sort type for public upload DIR file */
  char PrivDir[29];        /* name and location of private upload DIR file */
  char PrvUpldLoc[26];     /* private upload location */
  char DrsMenu[29];        /* name and location of conference doors menu */
  char DrsFile[33];        /* name and location of DOORS.LST file */
  char BltMenu[29];        /* name and location of conference blt menu */
  char BltNameLoc[33];     /* name and location of BLT.LST file */
  char ScrMenu[29];        /* name and location of conference scripts menu */
  char ScrNameLoc[33];     /* name and location of SCRIPT.LST */
  char DirMenu[29];        /* name and location of directories menu */
  char DirNameLoc[33];     /* name and location of DIR.LST file */
  char PthNameLoc[33];     /* name and location of DLPATH.LST file */
  bool ForceEcho;          /* turn off echo question, force all msgs to echo */
  bool ReadOnly;           /* do not allow ANY msgs to be entered in conf    */
  bool NoPrivateMsgs;      /* do not allow PRIVATE msgs to be entered        */
  char RetReceiptLevel;    /* level required to request return receipts      */
  bool RecordOrigin;       /* Record ORIGIN in messages                      */
  bool PromptForRouting;   /* Prompt user for ROUTING information            */
  bool AllowAliases;       /* Allow aliases to be used                       */
  bool ShowIntroOnRA;      /* Show the Conf INTRO in the middle of R A scan  */
  char ReqLevelToEnter;    /* Security Level required to enter messages      */
  char Password[13];       /* password reqd to join if private               */
  char Intro[32];          /* name/location of conference INTRO file         */
  char AttachLoc[32];      /* location for file attachment storage           */
  char RegFlags[4];        /* RXS flags for automatic conf registration      */
  char AttachLevel;        /* level required to attach files to messages     */
  char CarbonLimit;        /* max number of names in carbon list             */
  char CmdLst[32];         /* name/location of CMD.LST use instead of default*/
  bool OldIndex;           /* maintain old MSGS indexes?                     */
  bool LongToNames;        /* allow long TO: names to be entered             */
  char CarbonLevel;        /* level required to enter @LIST@ messages        */
} pcbconftype;

typedef struct {
  unsigned Version;           /* PCBoard version number (i.e. 145) */
  long     RecNo;             /* Record number from USER's file */
  unsigned SizeOfRec;         /* Size of "fixed" user record */
  unsigned NumOfAreas;        /* Number of conference areas (Main=1 thru 65535) */
  unsigned NumOfBitFields;    /* Number of Bit Map fields for conferences */
  unsigned SizeOfBitFields;   /* Size of each Bit Map field */
  char     AppName[15];       /* Name of the Third Party Application (if any) */
  unsigned AppVersion;        /* Version number for the application (if any) */
  unsigned AppSizeOfRec;      /* Size of a "fixed length" record (if any) */
  unsigned AppSizeOfConfRec;  /* Size of each conference record (if any) */
  long     AppRecOffset;      /* Offset of AppRec into USERS.INF record (if any) */
  bool     Updated;           /* TRUE if the USERS.SYS file has been updated */
} syshdrtype;


#ifdef _MSC_VER
/* MSC makes structures that are as small as the smallest type used.  So    */
/* with an "int Dirty:1" it forces the entire structure to be TWO BYTES in  */
/* size even though the total element size is only 8 bits.  Therefore, MSC  */
/* is compiled with "char" as the type instead of "int".  However, Turbo C  */
/* does not like using "char".  AARGH!  So we test for the MSC compiler and */
/* compile using "char" for MSC, and "int" for Turbo C */

typedef struct {
  char Dirty    :1;            /* Dirty Flag (meaning file has been updated) */
  char MsgClear :1;            /* User's choice for screen clear after messages */
  char HasMail  :1;            /* Indicates if NEW mail has been left for user */
  char DontAskFSE:1;           /* Used with FSEDefault, if set, don't prompt caller */
  char FSEDefault:1;           /* Use Full Screen Editor */
  char ScrollMsgBody:1;        /* Scroll message body when reading */
  char ShortHeader:1;          /* Display short message header */
  char WideEditor:1;           /* Use wide editor when entering messages */
} packedbyte;
typedef struct {
  char UnAvailable:1;          /* Unavailable for chat */
  char Reserved:7;
} packedbyte2;
#else
typedef struct {
  int Dirty    :1;             /* Dirty Flag (meaning file has been updated) */
  int MsgClear :1;             /* User's choice for screen clear after messages */
  int HasMail  :1;             /* Indicates if NEW mail has been left for user */
  int DontAskFSE:1;            /* Used with FSEDefault, if set, don't prompt caller */
  int FSEDefault:1;            /* Use Full Screen Editor */
  int ScrollMsgBody:1;         /* Scroll message body when reading */
  int ShortHeader:1;           /* Display short message header */
  int WideEditor:1;            /* Use wide editor when entering messages */
} packedbyte;
typedef struct {
  int UnAvailable:1;           /* Unavailable for chat */
  int Reserved:7;
} packedbyte2;
#endif

typedef struct {               /* DOS format for bit packed date fields */
  int  Day   :5;                /* 5 bit integer representing the Day */
  int  Month :4;                /* 4 bit integer representing the Month */
  int  Year  :7;                /* 7 bit integer representing the Year MINUS 80 */
} datetype;

#ifndef EXTENDED_USER_INFO
#define EXTENDED_USER_INFO
typedef struct {
  char  Street[2][51];
  char  City[26];
  char  State[11];
  char  Zip[11];
  char  Country[16];
} addresstypez;

typedef struct {
  char     Previous[3][13];
  unsigned LastChange;
  unsigned TimesChanged;
  unsigned ExpireDate;
} passwordtypez;

typedef struct {
  char  Line[5][61];
} notestypez;

typedef struct {
  unsigned FirstDateOn;
  unsigned NumSysopPages;
  unsigned NumGroupChats;
  unsigned NumComments;
  unsigned Num300;
  unsigned Num1200;
  unsigned Num2400;
  unsigned Num9600;
  unsigned Num14400;
  unsigned NumSecViol;
  unsigned NumNotReg;
  unsigned NumReachDnldLim;
  unsigned NumFileNotFound;
  unsigned NumPwrdErrors;
  unsigned NumVerifyErrors;
} callerstattype;
#endif

typedef struct {
  char           Name[26];           /* Name (NULL terminated) */
  char           City[25];           /* City (NULL terminated) */
  char           Password[13];       /* Password (NULL terminated) */
  char           BusDataPhone[14];   /* Business or Data Phone (NULL terminated) */
  char           HomeVoicePhone[14]; /* Home or Voice Phone (NULL terminated) */
  unsigned       LastDateOn;         /* Julian date for the Last Date On */
  char           LastTimeOn[6];      /* Last Time On (NULL Terminated) */
  bool           ExpertMode;         /* 1=Expert, 0=Novice */
  char           Protocol;           /* Protocol (A thru Z) */
  packedbyte     PackedFlags;        /* Bit packed flags */
  datetype       DateLastDirRead;    /* Date for Last DIR Scan (most recent file) */
  int            SecurityLevel;      /* Security Level */
  unsigned       NumTimesOn;         /* Number of times the caller has connected */
  unsigned char  PageLen;            /* Page Length when display data on the screen */
  unsigned       NumUploads;         /* Total number of FILES uploaded */
  unsigned       NumDownloads;       /* Total number of FILES downloaded */
  long           DailyDnldBytes;     /* Number of BYTES downloaded so far today */
  char           UserComment[31];    /* Comment field #1 (NULL terminated) */
  char           SysopComment[31];   /* Comment field #1 (NULL terminated) */
  int            ElapsedTimeOn;      /* Number of minutes online */
  unsigned       RegExpDate;         /* Julian date for Registration Expiration Date */
  int            ExpSecurityLevel;   /* Expired Security Level */
  unsigned       LastConference;     /* Number of the conference the caller was in */
  unsigned long  TotDnldBytes;       /* Total number of BYTES downloaded */
  unsigned long  TotUpldBytes;       /* Total number of BYTES uploaded */
  bool           DeleteFlag;         /* 1=delete this record, 0=keep */
  long           RecNum;             /* Record Number in USERS.INF file */
  packedbyte2    Flags;
  char           Reserved[8];        /* Bytes 390-397 from the USERS file */
  unsigned long  MsgsRead;           /* Number of messages the user has read in PCB */
  unsigned long  MsgsLeft;           /* Number of messages the user has left in PCB */
  bool           AliasSupport;
  char           Alias[26];
  bool           AddressSupport;
  addresstypez   Address;
  bool           PasswordSupport;
  passwordtypez  PwrdHistory;
  bool           VerifySupport;
  char           Verify[26];
  bool           StatsSupport;
  callerstattype Stats;
  bool           NotesSupport;
  notestypez     Notes;
} userrectype;

typedef struct {
  int  DateFormat;
  char DollarSym[5];
  char ThousandSep[2];
  char FractionSep[2];
  char DateSep[2];
  char TimeSep[2];
  char CurrencyFmt;
  char SigDigits;
  char TimeFmt;
  char (far *upchar)(char Al);
  char DataSep[2];
  char Reserved[10];
} countrytype;

#endif

extern asytype     Asy;
extern char        B16550;
extern char        B16550A;
extern char        B8250;
extern char far *  ConfReg;
extern char far *  ConfFlags;
extern long far *  MsgReadPtr;
extern unsigned    ConfByteLen;
extern controltype Control;
extern disptype    Display;
extern char *      DoorParams;
extern bool        ErrorLevel;
extern bool        ForceUpdate;
extern char        RTSoff;
extern char        PcbDir[30];
extern bool        UseAnsi;
extern pcbdattype  PcbData;
extern statustype  Status;
extern syshdrtype  UserSysHdr;
extern userrectype UserSys;
extern void *      TPAstatic;
extern void *      TPAdynamic;
extern char        mask_alphanum[];
extern char        mask_yesno[];
extern char        mask_num[];
extern char        mask_atoz[];
extern long        Scrn_Addr;
extern char        YesChar;
extern char        NoChar;
extern char        SystemYesChar;
extern char        SystemNoChar;
extern countrytype Country;

#ifdef __cplusplus
extern "C" {
#endif

extern int  (pascal *ringdetect)(void);
extern int  (pascal *ctsokay)(void);
extern int  (pascal *inbytes)(void);
extern int  (pascal *outbytes)(void);
extern int  (pascal *framingerrors)(void);
extern int  (pascal *overrunerrors)(void);
extern int  (pascal *parityerrors)(void);
extern int  (pascal *cdstillup)(void);
extern int  (pascal *online)(void);
extern int  (pascal *bauddivisor)(long PortSpeed);
extern void (pascal *setport)(int BaudDivisor,int DataBits);
extern void (pascal *turnoffdtr)(void);
extern void (pascal *turnondtr)(void);
extern void (pascal *turnoffrts)(void);
extern void (pascal *turnonrts)(void);
extern void (pascal *turnonxmit)(void);
extern void (pascal *clearoutbuf)(void);
extern void (pascal *clearinbuf)(void);
extern void (pascal *commgo)(void);
extern void (pascal *commstop)(void);
extern void (pascal *commpause)(void);
extern int  (pascal *checkcomm)(void);
extern int  (pascal *comminkey)(void);
extern int  (pascal *cgetstr)(char *pStr, int StrLen);
extern int  (pascal *cgetbuf)(char *Buf, int BufLen);
extern void (pascal *csendbyte)(unsigned char ByteToSend);
extern void (pascal *csendstr)(char *pStr, int StrLen);
#define RingDetect ringdetect()
#define CTSokay ctsokay()
#define InBytes inbytes()
#define OutBytes outbytes()
#define FramingErrors framingerrors()
#define OverrunErrors overrunerrors()
#define ParityErrors parityerrors()

int  pascal initdoor(char *Name, int SessionLimit, int KbdTimeout, openstatus OpenStatus);
void pascal closedoor(bool UpdateUserSys);
void pascal goodbye(bool UpdateUserSys);
void pascal println(char *Str);

void pascal dosinit(void);
void pascal pcbinit(void);
char * pascal strnchr(char *Str, char C, int Len);
int   pascal dosappendcheck(char *path, int access);
int   pascal dosopencheck(char *path, int access);
int   pascal doscreatecheck(char *path, int access, unsigned mode);
int   pascal writecheck(int handle, void *buffer, unsigned count);
int   pascal readcheck(int handle, void *buffer, unsigned count);
int   pascal dosappend(char *FileName, int OpenFlags);
void  pascal dosclose(int handle);
int   pascal doscommit(int Handle);
int   pascal doscreate(char *FileName, int OpenFlags, int Attributes);
int   pascal dosfclose(DOSFILE *file);
int   pascal dosfgets(char *Str, unsigned MaxChars, DOSFILE *file);
int   pascal dosfputs(char *Str, DOSFILE *file);
int   pascal dosflush(DOSFILE *file);
int   pascal dosfopen(char *FileName, int OpenFlags, DOSFILE *file);
int   pascal dosfread(void *Buffer, unsigned NumChars, DOSFILE *file);
int   pascal dosfwrite(void *Buffer, unsigned NumChars, DOSFILE *file);
long  pascal dosfseek(DOSFILE *file, long distance, char method);
int   pascal doslockcheck(int handle, long offset, long length);
long  pascal doslseek(int handle, long distance, char method);
int   pascal dosread(int handle, void *buf, unsigned len);
void  pascal dosrewind(DOSFILE *file);
int   pascal dossetbuf(DOSFILE *file, unsigned BufSize);
int   pascal doswrite(int handle, void *buf, unsigned len);
int   pascal dosdup(int OldHandle);
int   pascal dosopen(char *FileName, int OpenFlags);

void pascal atclosing(void);
void pascal bell(void);
void pascal print(char *Str);
void pascal printcls(void);
void pascal moreprompt(moretype Type);
void pascal newline(void);
void pascal freshline(void);
void pascal println(char *Str);
void pascal printxlated(char *Str);
void pascal printdefcolor(void);
void pascal printcolor(int ColorNum);
void pascal backupcleareol(int NumColumns);
void pascal backup(int NumColumns);
void pascal forward(int NumColumns);
void pascal movecursor(int X, int Y);
void pascal cleareol(void);
void pascal turnkbdtimeron(void);
void pascal inputfield(char *Buffer, int PcbTextNum, int MaxLen, displaytype Display, int HelpNum, char *Mask);
int  pascal inputfieldint(int Default, char *Prompt, int Color, int MaxLen, displaytype DisplayCtrl, int HelpNum);
long pascal inputfieldlong(long Default, char *Prompt, int Color, int MaxLen, displaytype DisplayCtrl, int HelpNum);
void pascal inputfieldstr(char *Buffer, char *Prompt, int Color, int MaxLen, displaytype Display, int HelpNum, char *Mask);
void pascal inputfieldreqstr(char *Buffer, char *Prompt, int Color, int MaxLen, int MinLen, displaytype Display, int HelpNum, char *Mask);
int  pascal displayfile(char *Name, displayfiletype Type);
void pascal waitforempty(int Seconds);
void pascal sendbyte(char Byte);
void pascal sendstr(char *Str, int StrLen);
void pascal writelog(char *Str, padtype Pad);
void pascal addchar(char *Str, char Ch);
void pascal stripleft(char *Str, char Ch);
void pascal stripright(char *Str, char Ch);
void pascal setbit(void far *BitStream, int BitNum);
unsigned pascal datetojulian(char *DateStr);
unsigned pascal getjuliandate(void);
char *   pascal juliantodate(unsigned int JD);
void pascal redisplaystatusline(void);
char pascal curcolor(void);
void pascal ansi(char *Str);
char pascal awherex(void);
char pascal awherey(void);
void pascal agotoxy(char X, char Y);
void pascal asetcolor(char NewColor);
void pascal turnonfifo(char TriggerLevel);
void pascal fmemcpy(void far *dest,void far *src,unsigned len);
void pascal fmemset(void far *dest,char c,unsigned len);
void pascal settimer(int Which, long Ticks);
long pascal gettimer(int Which);
void pascal sysopchat();
void pascal checkdisplaystatus(void);
void pascal startdisplay(startdisplaytype Action);
void pascal clearkbdbuffer(void);
int  pascal commportinkey(void);
int pascal kbdinkey(void);
int pascal cinkey(void);
void pascal checkstatus(void);
void * pascal bmalloc(int Size);
void pascal bfree(void *p);
void pascal bfreeall(void);
void far * pascal fbmalloc(long Size);
void pascal fbfree(void far *p);
void pascal fbfreeall(void);
int  pascal minutesleft(void);
void pascal addtime(long Seconds, timereasontype Reason);
void pascal subtime(long Seconds, timereasontype Reason);
void pascal ascii(char *Str, int Num);
void pascal asciispace(char *Str, int Num);
void pascal lascii(char *Str, long Num);
bool pascal substitute(char *Str, char *Search, char *Replace, int MaxLen);
void buildstr(char *Dest, ...);
void pascal tickdelay(int Ticks);
void pascal change(char *Str, char Old, char New);
void pascal displaypcbtext(int PcbTextNum, displaytype Display);
int  pascal savescrnbuffer(void);
void pascal restscrnbuffer(void);
void pascal turndisplayon(bool WriteToDisk);
void pascal turndisplayoff(bool WriteToDisk);
void pascal shelltodos(void);
int  pascal performshell(char *Command, char *Params, shelltype ShellType);
int  pascal tokenize(char *Command);
int  pascal tokenizestr(char *Command);
char * pascal getnexttoken(void);
void pascal addbackslash(char *Str, int MaxLen);
void pascal cls(void);
int  pascal getcursor(void);
void pascal setcursor(int CursorType);
char * pascal datestr(char *DateStr);  /* MM/DD/YY */
void pascal mydelay(int Hundredths);
void pascal fastputc(int Loc,char C);
void pascal fastputch(int Loc, char C, char Color);
void pascal fastprint(int X,int Y,char Str[80],char Attr);
int  pascal xyvalue(int X, int Y);
void pascal giveup(void);
char * pascal timestr1(char *TimeStr);  /* HH:MM:SS */
char * pascal timestr2(char *TimeStr);  /* HH:MM */
long pascal bassngltolong(bassngl Num);
long pascal basdbletolong(basdble Num);
void pascal longtobasdble(basdble New, long Num);
void pascal longtobassngl(bassngl New, long Num);
unsigned char pascal fileexist(char *FileName);
int  pascal isset(void far *BitStream, int BitNum);
void pascal maxstrcpy(char *Dest, char *Srce, int Max);
void pascal padstr(char *Str, char C, int MaxLen);
void pascal unsetbit(char far *BitStream, int BitNum);
int  pascal getconfrecord(unsigned ConfNum, pcbconftype *Conf);
int  pascal opencnames(void);
void pascal closecnames(void);
int  pascal displayhelpfile(int HelpNum);
void pascal customhelp(int HelpNum);
long pascal finduser(char *SrchName);
void pascal slowsendtomodem(char *Str);
int pascal showmodem(char *InBuf, int BufSize, modemverifytype Verify);
int pascal modemcommand(char *Command, modemverifytype Verify);

char * pascal countrydate(char *DateStr);
char * pascal countrydate2(char *DateStr);
char * pascal uncountrydate(char *DateStr);
char * pascal uncountrydate2(char *DateStr);
char * pascal dateformat(void);
char * pascal dateformat2(void);

#ifdef __cplusplus
}
#endif

#endif  /* __PCBTOOLS_H */
