Unit totWIN;
{$I TOTFLAGS.INC}

{Development Notes:
                600 = Close Window
                601 = Moved
                602 = Resized
                610 = Scroll Up One
                611 = Scroll Down One
                612 = Scroll Left one
                613 = Scroll Right one
                614 = Vertical Scroll Bar
                615 = Horizontal Scroll Bar
}

Interface

Uses DOS, CRT, totSYS, totLOOK, totINPUT, totFAST, totMISC;

Type

  WinPtr = ^WinOBJ;
  pWinOBJ = ^WinOBJ;
  WinOBJ = Object
             vBorder: tCoords;
             vOuter: tCoords;
             vClose: Boolean;            {is close icon active}
             vUnderneathPtr: pointer;    {ptr to saved screen}
             vSavedSize: LongInt;        {amount of memory saved}
             vTitle: String;             {window title}
             vBorderAttr: Byte;          {border attribute}
             vTitleAttr: Byte;           {title attribute}
             vBodyAttr: Byte;            {main text attribute}
             vIconsAttr: Byte;           {close and zoom icon attribute}
             vStyle: Byte;               {border style}
             vRemove: Boolean;           {remove the window when done}
             vCursX: Byte;               {saved cursor location}
             vCursY: Byte;               {saved       -"-      }
             vCursTop: Byte;             {saved cursor size}
             vCursBot: Byte;             {saved     -"-    }
             vOldWin: tByteCoords;       {previous window coords}
             vOldWinConfine: Boolean;    {were window coords active}
             vMVisible: Boolean;         {was mouse visible}
             vFillWin: Boolean;          {clear window core when redrawn}
             {methods...}
             Constructor Init;
             Procedure   SetSize (X1, Y1, X2, Y2, Style: Byte);
             Procedure   SetTitle (Title: String);
             Procedure   SetColors (Border, Body, Title, Icons: Byte);
             Procedure   SetRemove (On: Boolean);
             Procedure   SetClose (On: Boolean);
             Procedure   SetWindow;
             Procedure   GetSize (Var X1, Y1, X2, Y2, Style: Byte);
             Function    GetX: Byte;
             Function    GetY: Byte;
             Function    GetStyle: Byte;
             Function    GetBorderAttr: Byte;
             Function    GetTitleAttr: Byte;
             Function    GetBodyAttr: Byte;
             Function    GetIconsAttr: Byte;
             Function    GetRemoveStatus: Boolean;
             Procedure   Save;
             Procedure   PartSave (X1, Y1, X2, Y2: Byte; Var Dest);
             Procedure   PartRestore (X1, Y1, X2, Y2: Byte; Var Source);
             Procedure   ComputeSavedCoords;
             Procedure   DrawCore;
             Procedure   GrowDraw;
             Procedure   Remove;
             Procedure   WinGetKey (Var K: Word; Var X, Y: Byte);
             Procedure   SetBoundary (X1, Y1, X2, Y2: Byte);                  Virtual;
             Procedure   WinKey (Var K: Word; Var X, Y: Byte);                Virtual;
             Procedure   Draw;                                           Virtual;
             Destructor  Done;                                           Virtual;
           End; {WinOBJ}
  
  MoveWinPtr = ^MoveWinOBJ;
  pMoveWinOBJ = ^MoveWinOBJ;
  MoveWinOBJ = Object (WinOBJ)
                 vBoundary: tCoords;       {max area in which window can move}
                 vMoveKey: Word;
                 vAllowMove: Boolean;
                 {methods...}
                 Constructor Init;
                 Procedure   SetMoveKey (K: Word);
                 Procedure   SetAllowMove (On: Boolean);
                 Procedure   BuildBackground (Var BackScr: ScreenOBJ);
                 Procedure   RemoveShadow (Var OriginalScreen: ScreenOBJ);
                 Procedure   RefreshUnderneath (BackScr: ScreenOBJ);
                 Procedure   WMove (UsingMouse: Boolean; OldX, OldY: Byte);
                 Procedure   WinKey (Var K: Word; Var X, Y: Byte);                Virtual;
                 Procedure   SetBoundary (X1, Y1, X2, Y2: Byte);                  Virtual;
                 Destructor  Done;                                           Virtual;
               End; {MoveWinOBJ}

  pScrollWinOBJ = ^ScrollWinOBJ;
  ScrollWinOBJ = Object (MoveWinOBJ)
                   vScrollV: Boolean;       {show vertical scroll bar}
                   vScrollH: Boolean;       {show horizontal scroll bar}
                   {methods ...}
                   Constructor Init;
                   Procedure   SetScrollable (Vert, Horiz: Boolean);
                   Procedure   DrawHorizBar (Current, Max: LongInt);
                   Procedure   DrawVertBar (Current, Max: LongInt);
                   Procedure   Winkey (Var K: Word; Var X, Y: Byte);                Virtual;
                   Procedure   Draw;                                           Virtual;
                   Destructor  Done;                                           Virtual;
                 End; {ScrollWinOBJ}

  StretchWinPtr = ^StretchWinOBJ;
  pStretchWinOBJ = ^StretchWinOBJ;
  StretchWinOBJ = Object (ScrollWinOBJ)
                    vZoomed: Boolean;        {is window zoomed at present}
                    vPreZoom: tCoords;        {size of window in Unzoomed state}
                    vMinWidth: Byte;         {min width of SmartWin}
                    vMinDepth: Byte;         {min depth of SmartWin}
                    vStretchKey: Word;        {keycode for manual stretch}
                    vZoomKey: Word;           {keycode for zoom}
                    vAllowStretch: Boolean;  {is user allowed to stretch}
                    vSmartStretch: Boolean;  {refresh window during stretch}
                    {methods ...}
                    Constructor Init;
                    Procedure   SetMinSize (Width, depth: Byte);
                    Procedure   Stretch (UsingMouse: Boolean; OldX, OldY: Byte);
                    Procedure   SetAllowStretch (On: Boolean);
                    Procedure   ToggleZoom;
                    Procedure   Refresh;
                    Procedure   StretchRefresh;                                 Virtual;
                    Procedure   Winkey (Var K: Word; Var X, Y: Byte);                Virtual;
                    Procedure   Draw;                                           Virtual;
                    Destructor  Done;                                           Virtual;
                  End; {StretchWinOBJ}

Procedure WinInit;

Implementation

{|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
{                                                               }
{     U N I T   P R O C E D U R E S   &   F U N C T I O N S     }
{                                                               }
{|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}

Procedure Error (Err: Byte);
{routine to display error}
Const
  Header = 'WinTOT error: ';
Var
  Msg : String;
Begin
  Case Err Of
    1: Msg := 'Not enough memory to create window';
    2: Msg := 'Invalid window dimensions';
    3: Msg := 'Not enough memory to create SmartWin';
    Else  Msg := 'Unknown Error';
  End; {case}
  WriteLn (Header, Msg);
  {Maybe Add non-fatal compiler directive}
  Halt;
End; {Error}

{||||||||||||||||||||||||||||||||||||}
{                                    }
{    W i n O B J   M E T H O D S     }
{                                    }
{||||||||||||||||||||||||||||||||||||}

Constructor WinOBJ. Init;
{}
Begin
  SetSize (10, 5, 70, 20, 1);
  SetTitle ('');
  SetRemove (True);
  With LookTOT^ Do
    SetColors (WinBorder, WinBody, WinTitle, WinIcons);
  vUnderneathPtr := Nil;
  vMVisible := True;
  vClose := True;
  vFillWin := True;
End; {of const WinOBJ.Init}

Procedure WinOBJ. SetSize (X1, Y1, X2, Y2, Style: Byte);
{}
Begin
  {$IFDEF CHECK}
  If (X2 < X1 + 2)
     Or (Y2 < Y1 + 2)
     Or (Y2 > Screen. Depth)
     Or (X2 > Screen. Width)
  Then
    Error (2);
  {$ENDIF}
  vBorder. X1 := X1;
  vBorder. Y1 := Y1;
  vBorder. X2 := X2;
  vBorder. Y2 := Y2;
  vStyle := Style;
End; {WinOBJ.SetSize}

Procedure WinOBJ. GetSize (Var X1, Y1, X2, Y2, Style: Byte);
{}
Begin
  X1 := vBorder. X1;
  Y1 := vBorder. Y1;
  X2 := vBorder. X2;
  Y2 := vBorder. Y2;
  Style := vStyle;
End; {WinOBJ.GetSize}

Function WinOBJ. GetX: Byte;
{}
Begin
  GetX := vBorder. X1;
End; {WinOBJ.GetX}

Function WinOBJ. GetY: Byte;
{}
Begin
  GetY := vBorder. Y1;
End; {WinOBJ.GetY}

Function WinOBJ. GetStyle: Byte;
{}
Begin
  GetStyle := vStyle;
End; {WinOBJ.GetStyle}

Function WinOBJ. GetBorderAttr: Byte;
{}
Begin
  GetBorderAttr := vBorderAttr;
End; {WinOBJ.GetBorderAttr}

Function WinOBJ. GetTitleAttr: Byte;
{}
Begin
  GetTitleAttr := vTitleAttr;
End; {WinOBJ.GetTitleAttr}

Function WinOBJ. GetBodyAttr: Byte;
{}
Begin
  GetBodyAttr := vBodyAttr;
End; {WinOBJ.GetBodyAttr}

Function WinOBJ. GetIconsAttr: Byte;
{}
Begin
  GetIconsAttr := vIconsAttr;
End; {WinOBJ.GetIconsAttr}

Procedure WinOBJ. SetRemove (On: Boolean);
{}
Begin
  vRemove := On;
End; {Window.SetRemove}

Procedure WinOBJ. SetClose (On: Boolean);
{}
Begin
  vClose := On;
End; {WinOBJ.SetClose}

Function WinOBJ. GetRemoveStatus: Boolean;
{}
Begin
  GetRemoveStatus := vRemove;
End; {WinOBJ.GetRemoveStatus}

Procedure WinOBJ. SetTitle (Title: String);
{}
Begin
  vTitle := Title;
End; {WinOBJ.SetTitle}

Procedure WinOBJ. SetColors (Border, Body, Title, Icons: Byte);
{}
Begin
  If Border <> 0 Then
    vBorderAttr := Border;
  If Title <> 0 Then
    vTitleAttr := Title;
  If Body <> 0 Then
    vBodyAttr := Body;
  If Icons <> 0 Then
    vIconsAttr := Icons;
End; {WinOBJ.SetColors}

Procedure WinOBJ. SetBoundary (X1, Y1, X2, Y2: Byte);
{abstract}
Begin End;

Procedure WinOBJ. ComputeSavedCoords;
{checks shodow position and style and computes saved screen coords}
Begin
  ShadowTOT^. OuterCoords (vBorder, vOuter);
End; {WinOBJ.ComputeSavedCoords}

Procedure WinOBJ. SetWindow;
{}
Begin
  With vBorder Do
    Case vStyle Of
      0: Screen. SetWindow (X1, Y1, X2, Y2);
      6: Screen. SetWindow (Succ (X1), Y1 + 3, Pred (X2), Y2);
      Else Screen. SetWindow (Succ (X1), Succ (Y1), Pred (X2), Pred (Y2) );
    End; {case}
End; {WinOBJ.SetWindow}

Procedure WinOBJ. Save;
{}
Var
  MemoryNeeded: LongInt;
Begin
  ComputeSavedCoords;
  MemoryNeeded := Succ (vOuter. X2 - vOuter. X1) * Succ (vOuter. Y2 - vOuter. Y1) * 2;
  If MaxAvail < MemoryNeeded Then
    Error (1)
  Else
  Begin
    If vUnderneathPtr <> Nil Then
    Begin
      FreeMem (vUnderneathPtr, vSavedSize);
      vUnderneathPtr := Nil;
    End;
    GetMem (vUnderneathPtr, MemoryNeeded);
    PartSave (vOuter. X1, vOuter. Y1, vOuter. X2, vOuter. Y2, vUnderneathPtr^);
    vSavedSize := MemoryNeeded;
    vCursX := Screen. WhereX;
    vCursY := Screen. WhereY;
    Screen. CursSave;
    vCursTop := Screen. CursTop;
    vCursBot := Screen. CursBot;
    Screen. WindowCoords (vOldWin);
    vOldWinConfine := Screen. WindowActive;
  End;
End; {WinOBJ.Save}

Procedure WinOBJ. DrawCore;
{}
Begin
  If (vStyle In [1..5] ) And vClose Then
  Begin
    With vBorder Do
    Begin
      Screen. BoxEngine (X1, Y1, X2, Y2, 4, 4, vBorderAttr, vTitleAttr, vBodyAttr,
      vStyle, vFillWin, vTitle);
      Screen. WriteAT (X1 + 2, Y1, vBorderAttr, '[ ]');
      Screen. WriteAT (X1 + 3, Y1, vIconsAttr, '');
    End;
  End
  Else
    With vBorder Do
      Screen. BoxEngine (X1, Y1, X2, Y2, 0, 0, vBorderAttr, vTitleAttr, vBodyAttr,
      vStyle, vFillWin, vTitle);
  If (vStyle = 6) And vClose Then
    With vBorder Do
      Screen. WriteAT (X1 + 3, Y1, vIconsAttr, '');
End; {WinOBJ.DrawCore}

Procedure WinOBJ. Draw;
{}
Var WasOn: Boolean;
Begin
  vMVisible := Mouse. Visible;
  Save;
  WasOn := Screen. WindowOff;
  ShadowTOT^. DrawShadow (vBorder);
  DrawCore;
  SetWindow;
  If Not vMVisible Then
    Mouse. Show;
End; {WinOBJ.Draw}

Procedure WinOBJ. GrowDraw;
{}
Var
  I, TX1, TY1, TX2, TY2, Ratio : Integer;
  WasOn: Boolean;
Begin
  Save;
  vMVisible := Mouse. Visible;
  WasOn := Screen. WindowOff;
  With vBorder Do
  Begin
    If 2 * (Y2 - Y1 + 1) > X2 - X1 + 1 Then
      Ratio :=   2
    Else
      Ratio :=  1;
    TX2 := (X2 - X1) Div 2 + X1 + 2;
    TX1 := TX2 - 3;                 {needs a box 3 by 3 minimum}
    TY2 := (Y2 - Y1) Div 2 + Y1 + 2;
    TY1 := TY2 - 3;
    If (X2 - X1) < 3 Then
    Begin
      TX2 := X2;
      TX1 := X1;
    End;
    If (Y2 - Y1) < 3 Then
    Begin
      TY2 := Y2;
      TY1 := Y1;
    End;
    Repeat
      Screen. PartClear (TX1, TY1, TX2, TY2, vBodyAttr, ' ');
      If TX1 >= X1 + (1 * Ratio) Then
        TX1 := TX1 - (1 * Ratio)
      Else
        TX1 := X1;
      If TY1 > Y1  Then
        TY1 := TY1 - 1;
      If TX2 + (1 * Ratio) <= X2 Then
        TX2 := TX2 + (1 * Ratio)
      Else
        TX2 := X2;
      If TY2 + 1 <= Y2 Then
        TY2 := TY2 + 1;
      Delay (10);
    Until (TX1 = X1) And (TY1 = Y1) And (TX2 = X2) And (TY2 = Y2);
    DrawCore;
  End;
  ShadowTOT^. DrawShadow (vBorder);
  SetWindow;
  If Not vMVisible Then
    Mouse. Show;
End; {WinOBJ.GrowDraw}

Procedure WinOBJ. PartSave (X1, Y1, X2, Y2: Byte; Var Dest);
{}
Var
  I, w : Byte;
  Wid : Word;
  ScreenAdr: Integer;
  Pntr: pointer;
  Mvisible: Boolean;
Begin
  w := Succ (X2 - X1);
  Pntr := Screen. ScreenPtr;
  Mvisible := Mouse. Visible;
  Wid := Monitor^. Width * 2;
  If MVisible Then
    Mouse. Hide;
  For I :=  Y1 To Y2 Do
  Begin
    ScreenAdr := Pred (I) * Wid + Pred (X1) * 2;
    Screen. MoveFromScreen (Mem [Seg (Pntr^): Ofs (Pntr^) + ScreenAdr],
    Mem [Seg (Dest): Ofs (dest) + (I - Y1) * w * 2],
    w);
  End;
  If MVisible Then
    Mouse. Show;
End; {WinOBJ.PartSave}

Procedure WinOBJ. PartRestore (X1, Y1, X2, Y2: Byte; Var Source);
{}
Var
  I, w : Byte;
  Wid: Word;
  ScreenAdr: Integer;
  Pntr: pointer;
  Mvisible: Boolean;
Begin
  w := Succ (X2 - X1);
  Pntr := Screen. ScreenPtr;
  Wid := Monitor^. Width * 2;
  MVisible := Mouse. Visible;
  If MVisible Then
    Mouse. Hide;
  For I :=  Y1 To Y2 Do
  Begin
    ScreenAdr := Pred (I) * Wid + Pred (X1) * 2;
    Screen. MoveToScreen (Mem [Seg (Source): Ofs (Source) + (I - Y1) * w * 2],
    Mem [Seg (Pntr^): Ofs (Pntr^) + ScreenAdr],
    w);
  End;
  If MVisible Then
    Mouse. Show;
End; {WinOBJ.PartRestore}

Procedure WinOBJ. Remove;
{}
Begin
  If vUnderneathPtr <> Nil Then
  Begin
    Mouse. Hide;
    PartRestore (vOuter. X1, vOuter. Y1, vOuter. X2, vOuter. Y2, vUnderneathPtr^);
    FreeMem (vUnderneathPtr, vSavedSize);
    vUnderneathPtr := Nil;
    If vOldWinConfine Then
      With vOldWin Do
        Screen. SetWindow (X1, Y1, X2, Y2)
    Else
      Screen. ResetWindow;
    Screen. GotoXY (vCursX, vCursY);
    Screen. CursSize (vCursTop, vCursBot);
    If vMVisible Then
      Mouse. Show;
  End;
End; {WinOBJ.Remove}

Procedure WinOBJ. WinGetKey (Var K: Word; Var X, Y: Byte);
{}
Begin
  With key Do
  Begin
    Key. GetInput;
    K := Key. LastKey;
    X := Key. LastX;
    Y := Key. LastY;
    WinKey (K, X, Y);
  End;
End; {WinOBJ.WinGetKey}

Procedure WinOBJ. WinKey (Var K: Word; Var X, Y: Byte);
{}
Begin
  If  (K = 513) And (Y = vBorder. Y1)
      And (X = vBorder. X1 + 3) And vClose
  Then
  Begin
    Remove;
    K := 600;  {Closed}
  End;
End; {WinOBJ.WinKey}

Destructor WinOBJ. Done;
{}
Begin
  If (vRemove) And (vUnderneathPtr <> Nil)  Then
    Remove;
  If vUnderneathPtr <> Nil Then
    FreeMem (vUnderneathPtr, vSavedSize);
End; {WinOBJ.Done}
{||||||||||||||||||||||||||||||||||||||||||||}
{                                            }
{    M o v e W i n O B J   M E T H O D S     }
{                                            }
{||||||||||||||||||||||||||||||||||||||||||||}
{$Q-}
Constructor MoveWinOBJ. Init;
Begin
  WinOBJ. Init;
  vAllowMove := True;
  vMoveKey := LookTOT^. WinMoveKey;
  SetBoundary (1, 1, Monitor^. Width, Monitor^. Depth);
End; {MoveWinOBJ.Init}

Procedure MoveWinOBJ. SetMoveKey (K: Word);
{$Q-}
Begin

End; {MoveWinOBJ.SetMoveKey}

Procedure MoveWinOBJ. SetBoundary (X1, Y1, X2, Y2: Byte);
{$Q-}
Begin
  vBoundary. X1 := X1;
  vBoundary. Y1 := Y1;
  vBoundary. X2 := X2;
  vBoundary. Y2 := Y2;
End; {MoveWinOBJ.SetBoundary}

Procedure MoveWinOBJ. BuildBackground (Var BackScr: ScreenOBJ);
{saves the screen and replaces the contents of the screen
 where the window lies with the image saved behind the window.
}
{$Q-}
Var
  I, w : Byte;
  Wid : Word;
  ImageAdr: Integer;
  Pntr: pointer;
Begin
  BackScr. Save;    {save current screen}
  w := Succ (vOuter. X2 - vOuter. X1);
  Pntr := BackScr. ScreenPtr;
  Wid := Monitor^. Width * 2;
  For I :=  vOuter. Y1 To vOuter. Y2 Do
  Begin
    ImageAdr := Pred (I) * Wid + Pred (vOuter. X1) * 2;
    Move (Mem [Seg (vUnderneathPtr^): Ofs (vUnderneathPtr^) + (I - vOuter. Y1) * w * 2],
    Mem [Seg (Pntr^): Ofs (Pntr^) + ImageAdr],
    w * 2);
  End;
End; {MoveWinOBJ.BuildBackground}

Procedure MoveWinOBJ. RefreshUnderneath (BackScr: ScreenOBJ);
{Takes image from saved screen and moves it to the window's saved
 image at UnderneathPtr.
}
{$Q-}
Var
  I, w : Byte;
  Wid : Word;
  ImageAdr: Integer;
  Pntr: pointer;
Begin
  {dispose of window memory, and get required memory}
  FreeMem (vUnderneathPtr, vSavedSize);
  w := Succ (vOuter. X2 - vOuter. X1);
  vSavedSize := Succ (vOuter. Y2 - vOuter. Y1) * W * 2;
  GetMem (vUnderneathPtr, vSavedSize);
  Pntr := BackScr. ScreenPtr;
  Wid := Monitor^. Width * 2;
  For I :=  vOuter. Y1 To vOuter. Y2 Do
  Begin
    ImageAdr := Pred (I) * Wid + Pred (vOuter. X1) * 2;
    Move (Mem [Seg (Pntr^): Ofs (Pntr^) + ImageAdr],
    Mem [Seg (vUnderneathPtr^): Ofs (vUnderneathPtr^) + (I - vOuter. Y1) * w * 2],
    w * 2);
  End;
End; {MoveWinOBJ.RefreshUnderneath}

Procedure MoveWinOBJ. RemoveShadow (Var OriginalScreen: ScreenOBJ);
{}
{$Q-}
Begin
  If vOuter. X1 < vBorder. X1 Then   {shadowleft}
    OriginalScreen. PartDisplay (vOuter. X1, vOuter. Y1, Pred (vBorder. X1), vOuter. Y2, vOuter. X1, vOuter. Y1);
  If vOuter. X2 > vBorder. X2 Then   {shadowright}
    OriginalScreen. PartDisplay (Succ (vBorder. X2), vOuter. Y1, vOuter. X2, vOuter. Y2, Succ (vBorder. X2), vOuter. Y1);
  If vOuter. Y1 < vBorder. Y1 Then   {shadowUp}
    OriginalScreen. PartDisplay (vOuter. X1, vOuter. Y1, vOuter. X2, Pred (vBorder. Y1), vOuter. X1, vOuter. Y1);
  If vOuter. Y2 > vBorder. Y2 Then  {shadowDown}
    OriginalScreen. PartDisplay (vOuter. X1, Succ (vBorder. Y2), vOuter. X2, vOuter. Y2, vOuter. X1, Succ (vBorder. Y2) );
End; {MoveWinOBJ.RemoveShadow}

Procedure MoveWinOBJ. WMove (UsingMouse: Boolean; OldX, OldY: Byte);
{$Q-}
Var
  Mvisible,
  WasOn,
  Left, Center, Right : Boolean;
  X, Y : Byte;
  DeltaX, DeltaY : ShortInt;
  ScrPtr,
  OldPtr,
  SmartWinImagePtr : pointer;
  Wid: Word;
  CTop, CBot, CX, CY: Byte;
  W, D: Byte;
  OldLocation : tCoords;
  OriginalScreen: ScreenOBJ;

Procedure CaptureSmartWin;
{$Q-}
  {saves image of window}
Var I : Integer;
Begin
    With vBorder Do
    Begin
      GetMem (SmartWinImagePtr, W * D * 2);
      Screen. PartSave (X1, Y1, X2, Y2, SmartWinImagePtr^);
    End;
  End; {CaptureSmartWin}

Procedure RestoreSmartWin;
{$Q-}
{}
Begin
    With vBorder Do
      Screen. PartRestore (X1, Y1, X2, Y2, SmartWinImagePtr^);
  End; {RestoreSmartWin}

  Procedure DisposeSmartWin;
  {}
  Begin
    FreeMem (SmartWinImagePtr, W * D * 2);
  End; {DisposeSmartWin}

Procedure FastRestore (X1, Y1, X2, Y2: Byte);
{$Q-}
{}
Var
    I, w : Byte;
    ScreenAdr: Integer;
  Begin
    If (X1 > X2) Or (Y1 > Y2) Then
      Exit;
    w := Succ (X2 - X1);
    For I :=  Y1 To Y2 Do
    Begin
      ScreenAdr := Pred (I) * Wid + Pred (X1) * 2;
      Screen. MoveToScreen (Mem [Seg (OldPtr^): Ofs (OldPtr^) + ScreenAdr],
      Mem [Seg (ScrPtr^): Ofs (ScrPtr^) + ScreenAdr],
      w);
    End;
  End; {FastRestore}

Begin
{$Q-}
  With vBorder Do
  Begin
    W := Succ (X2 - X1);
    D := Succ (Y2 - Y1);
  End;
  If MaxAvail < W * D * 2 * Screen. Width * Screen. Depth * 2 Then
  Begin
    Beep;
    Exit;
  End;
  With Screen Do
  Begin
    CursSave;
    CX := Screen. WhereX;
    CY := Screen. WhereY;
    CTop := CursTop;
    CBot := CursBot;
    CursOff;
  End;
  OriginalScreen. Init;
  MVisible := Mouse. Visible;
  If MVisible Then
    Mouse. Hide;
  BuildBackground (OriginalScreen);
  ScrPtr :=  Ptr (Monitor^. vBaseOfScreen, 0);
  OldPtr := OriginalScreen. ScreenPtr;
  Wid := Monitor^. Width * 2;
  CaptureSmartWin;
  RemoveShadow (OriginalScreen);
  Repeat
    If UsingMouse Then
    Begin
      Mouse. Show;
      Mouse. Status (Left, Center, Right, X, Y);
    End
    Else
    Begin
      With Key Do
      Begin
        OldX := 20;
        OldY := 20;
        Y := 20;
        X := 20;
        GetInput;
        Case Key. LastKey Of
          328: Dec (Y); {up}
          336: Inc (Y); {down}
          333: Inc (X); {right}
{$Q-}
          331: Dec (X); {left}
        End; {case}
        Left := True;
      End;
    End;
    If Left And ( (X <> OldX) Or (Y <> OldY) ) Then  {move window}
    Begin
      OldLocation := vOuter;
      If (X <> OldX) Then
      Begin
        DeltaX := X - OldX;
        If  (DeltaX + vBorder. X1 >= vBoundary. X1)
            And (DeltaX + vBorder. X2 <= vBoundary. X2)
        Then
        Begin
          vBorder. X1 := vBorder. X1 + DeltaX;
          vBorder. X2 := vBorder. X2 + DeltaX;
        End
        Else DeltaX := 0;
      End
      Else
        DeltaX := 0;
{$Q-}
      If (Y <> OldY) Then
      Begin
        DeltaY := Y - OldY;
        If  (DeltaY + vBorder. Y1 >= vBoundary. Y1)
            And (DeltaY + vBorder. Y2 <= vBoundary. Y2)
        Then
        Begin
          vBorder. Y1 := vBorder. Y1 + DeltaY;
          vBorder. Y2 := vBorder. Y2 + DeltaY;
        End
        Else
          DeltaY := 0;
      End
      Else
        DeltaY := 0;
      ComputeSavedCoords;
      Mouse. Hide;
      RestoreSmartWin;
      If DeltaX > 0 Then {viewport moved right}
{$Q-}
        FastRestore (OldLocation. X1, vOuter. Y1, Pred (vBorder. X1), vOuter. Y2)
      Else If DeltaX < 0 Then {viewport moved left}
        FastRestore (Succ (vBorder. X2), vBorder. Y1, OldLocation. X2, vOuter. Y2);
      If DeltaY > 0 Then {Viewport moved down}
        FastRestore (OldLocation. X1, OldLocation. Y1, vBorder. X2, Pred (vBorder. Y1) )
      Else If deltaY < 0 Then {Viewport moved up}
        FastRestore (OldLocation. X1, Succ (vBorder. Y2), vBorder. X2, OldLocation. Y2);
      If DeltaX < 0 Then    {moved left}
      Begin
        If (DeltaY > 0) Then
          FastRestore (Succ (vBorder. X1), OldLocation. Y1, Oldlocation. X2, Pred (vBorder. Y1) )
        Else
          FastRestore (Succ (vBorder. X2), Succ (vOuter. Y2), Oldlocation. X2, OldLocation. Y2);
      End;
      OldX := X;
      OldY := Y;
      {Mouse.Move(X,Y);}
    End; {if}
  Until (UsingMouse And (Left = False) ) Or ( ( (Key. LastKey = 13) Or (Key. LastKey = 27) ) And (UsingMouse = False) );
  Mouse. Hide;
  WasOn := Screen. WindowOff;
{$Q-}
  ShadowTOT^. DrawShadow (vBorder);
  Screen. WindowOn;
  If MVisible Then
    Mouse. Show;
  {now save new background behind window}
  RefreshUnderneath (OriginalScreen);
  SetWindow;
  Screen. GotoXY (CX, CY);
  Screen. CursSize (CTop, CBot);
  OriginalScreen. Done;
  DisposeSmartWin;
{$Q+}
End; {MoveWinOBJ.Move}

Procedure MoveWinOBJ. SetAllowMove (On: Boolean);
{}
Begin
  vAllowMove := On;
End; {MoveWinOBJ.SetAllowMove}

Procedure MoveWinOBJ. WinKey (Var K: Word; Var X, Y: Byte);
{}
Begin
  If (K = vMoveKey) And (vAllowMove) Then
    WMove (False, X, Y)
  Else If  (K = 513) And (Y = vBorder. Y1) And
           (X >= vBorder. X1) And (X <= vBorder. X2)
  Then
  Begin
    If (X = vBorder. X1 + 3) And vClose Then
    Begin
      Remove;
      K := 600;  {Closed}
    End
    Else If vAllowMove Then
    Begin
      WMove (True, X, Y);
      K := 601;  {Moved}
    End;
  End;
End; {MoveWinOBJ.WinKey}

Destructor MoveWinOBJ. Done;
{}
Begin
  WinOBJ. Done;
End; {MoveWinOBJ.Done}
{||||||||||||||||||||||||||||||||||||||||||||||||}
{                                                }
{    S c r o l l W i n O B J   M E T H O D S     }
{                                                }
{||||||||||||||||||||||||||||||||||||||||||||||||}
Constructor ScrollWinOBJ. Init;
{}
Begin
  MoveWinOBJ. Init;
  vScrollV := False;
  vScrollH := False;
End; {ScrollWinOBJ.Init}

Procedure ScrollWinOBJ. SetScrollable (Vert, Horiz: Boolean);
{}
Begin
  vScrollV := Vert;
  vScrollH := Horiz;
End; {ScrollWinOBJ.SetScrollable}

Procedure ScrollWinOBJ. DrawHorizBar (Current, Max: LongInt);
{}
Var
  WasOn: Boolean;
  CursX, CursY : Byte;
Begin
  If (vStyle In [1..5] ) And (vScrollH) Then
  Begin
    CursX := Screen. WhereX;
    CursY := Screen. WhereY;
    WasOn := Screen. WindowOff;
    With vBorder Do
      Screen. WriteHScrollBar (Succ (X1), Pred (X2), Y2, vBorderAttr, Current, Max);
    SetWindow;
    Screen. GotoXY (CursX, CursY);
  End; 
End; {ScrollWinOBJ.DrawHorizBar}

Procedure ScrollWinOBJ. DrawVertBar (Current, Max: LongInt);
{}
Var
  WasOn: Boolean;
  CursX, CursY : Byte;
Begin
  If (vStyle In [1..5] ) And (vScrollV) Then
  Begin
    CursX := Screen. WhereX;
    CursY := Screen. WhereY;
    WasOn := Screen. WindowOff;
    With vBorder Do
      Screen. WriteVScrollBar (X2, Succ (Y1), Pred (Y2), vBorderAttr, Current, Max);
    SetWindow;
    Screen. GotoXY (CursX, CursY);
  End;
End; {ScrollWinOBJ.DrawVertBar}

Procedure ScrollWinOBJ. WinKey (Var K: Word; Var X, Y: Byte);
{ RetCodes
610 = Scroll Up One
611 = Scroll Down One
612 = Scroll Left one
613 = Scroll Right one
614 = Vertical Scroll Bar
615 = Horizontal Scroll Bar
}
Begin
  If K = vMoveKey Then
    WMove (False, X, Y)
  Else If  (K = 513) Then
  Begin
    If (Y = vBorder. Y1) And
       (X >= vBorder. X1) And (X <= vBorder. X2) 
    Then
    Begin
      If (X = vBorder. X1 + 3) And vClose Then
      Begin
        Remove;
        K := 600;  {Closed}
      End
      Else
      Begin
        WMove (True, X, Y);
        K := 601;  {Moved}
      End;
    End
    Else If vScrollV And (X = vBorder. X2) Then
    Begin
      If  Y = Succ (vBorder. Y1) Then
        K := 610
      Else If Y =  Pred (vBorder. Y2)  Then
        K := 611
      Else If  (Y > Succ (vBorder. Y1) )
               And (Y < Pred (vBorder. Y2) ) 
      Then {scroll bar}
      Begin
        {adjust X to represent no of characters down scroll bar}
        {adjust Y to return total length of scroll bar}
        K := 614;
        X := Y - Succ (vBorder. Y1);
        Y := vBorder. Y2 - vBorder. Y1 - 3;
      End;
    End
      Else  If vScrollH And (Y = vBorder. Y2) Then
      Begin
        If X = Succ (vBorder. X1) Then
          K := 612
        Else If X = Pred (vBorder. X2) Then
          K := 613
        Else If  (X > Succ (vBorder. X1) )
                 And (X < Pred (vBorder. X2) ) 
        Then
        Begin
          K := 615;
          X := X - Succ (vBorder. X1);
          Y := vBorder. X2 - vBorder. X1 - 3;
        End;
      End;
  End;
End; {ScrollWinOBJ.WinKey}

Procedure ScrollWinOBJ. Draw;
{}
Begin
  If Not (vStyle In [1..5] ) Then
    vStyle := 1;
  MoveWinOBJ. Draw;
End; {ScrollWinOBJ.Draw}

Destructor ScrollWinOBJ. Done;
{}
Begin
  MoveWinOBJ. Done;
End; {ScrollWinOBJ.Done}
{||||||||||||||||||||||||||||||||||||||||||||||||||}
{                                                  }
{    S t r e t c h W i n O B J   M E T H O D S     }
{                                                  }
{||||||||||||||||||||||||||||||||||||||||||||||||||}
Constructor StretchWinOBJ. Init;
{}
Begin
  ScrollWinOBJ. Init;
  vZoomed := False;
  vPreZoom := vBorder;
  vMinWidth := 10;
  vMinDepth := 5;
  vStretchKey := LookTOT^. vWinStretchKey;
  vZoomKey := LookTOT^. vWinZoomKey;
  vAllowStretch := True;
  vSmartStretch := False;
End; {StretchWinOBJ.Init}

Procedure StretchWinOBJ. SetAllowStretch (On: Boolean);
{}
Begin
  vAllowStretch := On;
End; {StretchWinOBJ.SetAllowStretch}

Procedure StretchWinOBJ. SetMinSize (Width, depth: Byte);
{}
Begin
  vMinWidth := width;
  vMinDepth := depth;
End; {StretchWinOBJ.SetMinSize}

Procedure StretchWinOBJ. ToggleZoom;
{zooms or unzooms a window}
Begin
  vZoomed := Not vZoomed;
  Remove;             {remove the window}
  If vUnderneathPtr <> Nil Then
    FreeMem (vUnderneathPtr, Succ (vOuter. X2 - vOuter. X1) * Succ (vOuter. Y2 - vOuter. Y1) * 2);
  If Not vZoomed Then
    vBorder := vPreZoom  {set zone coords back to the old coords}
  Else
  Begin
    vPreZoom := vBorder;  {save the un-zoomed coordinates}
    vBorder := vBoundary; {set window coords to the maximum}
  End;      
  ComputeSavedCoords;
  Draw;        
End; {StretchWinOBJ.ToggleZoom}

Procedure StretchWinOBJ. StretchRefresh;
{abstract} Begin End;

Procedure StretchWinOBJ. Stretch (UsingMouse: Boolean; OldX, OldY: Byte);
{}
Const
  BorderChar = #0;
  Col = White;
Var
  Mvisible,
  WasOn: Boolean;
  Left, Center, Right : Boolean;
  CTop, CBot, CX, CY: Byte;
  NewX, NewY,
  X, Y : Byte;
  OriginalScreen: ScreenOBJ;
  BackScreen: ScreenOBJ;

Procedure ChangePerimeter;
     {}
     Var
       I : Integer;
     Begin
       If NewX <> vBorder. X2 Then
         With vBorder Do
         Begin
           OriginalScreen. PartDisplay (X2, Y1, X2, Y2, X2, Y1);
           If NewX < X2 Then
           Begin
             OriginalScreen. PartDisplay (Succ (NewX), Y1, X2, Y2, Succ (NewX), Y1);
             OriginalScreen. PartDisplay (Succ (NewX), Y2, X2, Y2, Succ (NewX), Y2);
           End;
         End;
       If NewY <> vBorder. Y2 Then
         With vBorder Do
         Begin
           OriginalScreen. PartDisplay (X1, Y2, X2, Y2, X1, Y2);
           If NewY < Y2 Then
           Begin
             OriginalScreen. PartDisplay (X1, Succ (NewY), X2, Y2, X1, Succ (NewY) );
             OriginalScreen. PartDisplay (X2, Succ (NewY), X2, Y2, X2, Succ (NewY) );
           End;
         End;
       {draw new perimiter}
       With vBorder Do
       Begin
         X2 := NewX;
         Y2 := NewY;
         Screen. Box (X1, Y1, X2, Y2, White, Ord (BorderChar) );
       End;
     End;
Begin
  If MaxAvail < 4 * Screen. Width * Screen. Depth Then
  Begin
    Beep;
    Exit;
  End;
  WasOn := Screen. WindowOff;
  OriginalScreen. Init;
  MVisible := Mouse. Visible;
  If MVisible Then
    Mouse. Hide;
  OriginalScreen. Save;
  BackScreen. Init;
  BuildBackground (BackScreen);
  If vSmartStretch Then
    With OriginalScreen Do
      Move (Backscreen. ScreenPtr^, ScreenPtr^, Depth * Width * 2);
  If vUnderneathPtr <> Nil Then
  Begin
    FreeMem (vUnderneathPtr, vSavedSize);
    vUnderneathPtr := Nil;
  End;
  With vBorder Do
  Begin
    Screen. Box (X1, Y1, X2, Y2, col, Ord (BorderChar) );
    OldX := X2;
    OldY := Y2;
  End;
  RemoveShadow (OriginalScreen);
  With Screen Do
  Begin
    CursSave;
    CX := Screen. WhereX;
    CY := Screen. WhereY;
    CTop := CursTop;
    CBot := CursBot;
    CursOff;
  End;
  Repeat
    If UsingMouse Then
    Begin
      Mouse. Show;
      Mouse. Status (Left, Center, Right, X, Y);
    End
    Else
    Begin
      With Key Do
      Begin
        OldX := vBorder. X2;
        OldY := vBorder. Y2;
        Y := OldY;
        X := OldX;
        GetInput;
        Case Key. LastKey Of
          328: Dec (Y); {up}
          336: Inc (Y); {down}
          333: Inc (X); {right}
          331: Dec (X); {left}
        End; {case}
        (*
        X := OldX;
        Y := OldY;
        GetInput;
        Case Key.LastKey of
        328: if Y > 1 then
        dec(Y); {up}
        336: if Y < 100 then
        inc(Y); {down}
        333: if X < 100 then
        inc(X); {right}
        331: if X > 1 then
        dec(X); {left}
        end; {case}
        *)
      End;
      Left := True;
    End;
    If Left And ( (X <> OldX) Or (Y <> OldY) ) Then  {stretch window}
    Begin
      If (Succ (X - vBorder. X1 ) < vMinWidth) Then  {too small}
        NewX := Pred (vBorder. X1 + vMinWidth)
      Else
        If (X > vBoundary. X2) Then                 {out of bounds}
          NewX := vBoundary. X2
        Else
          NewX := X;
      If (Succ (Y - vBorder. Y1 ) < vMinDepth) Then  {too small}
        NewY := Pred (vBorder. Y1 + vMinDepth)
      Else
        If (Y > vBoundary. Y2) Then                 {out of bounds}
          NewY := vBoundary. Y2
        Else
          NewY := Y;
      ChangePerimeter;
      If vSmartStretch Then
        StretchRefresh;
      OldX := NewX;
      OldY := NewY;
    End; {if}
  Until (UsingMouse And (Left = False) ) Or ( ( (Key. LastKey = 13) Or (Key. LastKey = 27) ) And (UsingMouse = False) );
  ComputeSavedCoords;
  { draw the new image }
  BackScreen. Display;
  OriginalScreen. Done;
  BackScreen. Done;
  vZoomed := (vBorder. X1 = vBoundary. X1)
  And (vBorder. Y1 = vBoundary. Y1)
  And (vBorder. X2 = vBoundary. X2)
  And (vBorder. Y2 = vBoundary. Y2);
  SetWindow;
  Draw;
  Screen. GotoXY (CX, CY);
  Screen. CursSize (CTop, CBot);
  If MVisible Then
    Mouse. Show;
End; {StretchWinOBJ.Stretch}

Procedure StretchWinOBJ. Winkey (Var K: Word; Var X, Y: Byte);
{}
Begin
  If (K = vStretchKey) And vAllowStretch Then
  Begin
    Stretch (False, X, Y);
    K := 602;
  End
  Else If (K = 513) And (X = vBorder. X2) And (Y = vBorder. Y2) And vAllowStretch Then
  Begin
    Stretch (True, X, Y);
    K := 602;
  End
  Else If ( ( (K = 513) And (X = vBorder. X2 - 3) And (Y = vBorder. Y1) )
            Or (K = vZoomKey) ) And vAllowStretch 
  Then
  Begin
    ToggleZoom;
    K := 602;
  End
  Else
    ScrollWinOBJ. WinKey (K, X, Y);
End; {StretchWinOBJ.Winkey}

Procedure StretchWinOBJ. Refresh;
{}
Var WasOn: Boolean;
Begin
  WasOn := Screen. WindowOff;
  ShadowTOT^. DrawShadow (vBorder);
  If vClose Then
  Begin
    With vBorder Do
    Begin
      Screen. BoxEngine (X1, Y1, X2, Y2, 4, 4, vBorderAttr, vTitleAttr, vBodyAttr, vStyle, True, vTitle);
      Screen. WriteAT (X1 + 2, Y1, vBorderAttr, '[ ]');
      Screen. WriteAT (X1 + 3, Y1, vIconsAttr, '');
    End;
  End
  Else
    With vBorder Do
      Screen. BoxEngine (X1, Y1, X2, Y2, 0, 4, vBorderAttr, vTitleAttr, vBodyAttr, vStyle, True, vTitle);
  If vAllowStretch Then
  Begin
    Screen. WriteAT (vBorder. X2 - 4, vBorder. Y1, vBorderAttr, '[ ]');
    If Not vZoomed Then
      Screen. WriteAT (vBorder. X2 - 3, vBorder. Y1, vIconsAttr, '')
    Else
      Screen. WriteAT (vBorder. X2 - 3, vBorder. Y1, vIconsAttr, '');
  End;
  SetWindow;
End; {StretchWinOBJ.Refresh}

Procedure StretchWinOBJ. Draw;
{}
Begin
  If Not (vStyle In [1..5] ) Then
    vStyle := 1;
  Save;
  vMVisible := Mouse. Visible;
  Refresh;
  If Not vMVisible Then
    Mouse. Show;
End; {StretchWinOBJ.Draw}

Destructor StretchWinOBJ. Done;
{}
Begin
  ScrollWinOBJ. Done;
End; {StretchWinOBJ.Done}
{|||||||||||||||||||||||||||||||||||||||||||||||}
{                                               }
{     U N I T   I N I T I A L I Z A T I O N     }
{                                               }
{|||||||||||||||||||||||||||||||||||||||||||||||}
Procedure WinInit;
{initilizes objects and global variables}
Begin
End;

{end of unit - add intialization routines below}
{$IFNDEF OVERLAY}
Begin
  WinInit;
  {$ENDIF}
End.
