{               Copyright 1991 TechnoJock Software, Inc.               }
{                          All Rights Reserved                         }
{                         Restricted by License                        }

{                             Build # 1.00                             }

Unit totLOOK;
{$I TOTFLAGS.INC}

{
 Development Notes:

}

Interface

Uses CRT, totSYS;

Type
  
  pLookOBJ = ^LookOBJ;
  LookOBJ = Object
              vWinBorder: Byte;
              vWinBody: Byte;
              vWinTitle: Byte;
              vWinIcons: Byte;
              vWinMoveKey: Word;
              vWinStretchKey: Word;
              vWinZoomKey: Word;
              vMenuBorder: Byte;
              vMenuTitle: Byte;
              vMenuIcon: Byte; 
              vMenuHiHot: Byte;                                               
              vMenuHiNorm: Byte;
              vMenuLoHot: Byte; 
              vMenuLoNorm: Byte;
              vMenuInActive: Byte;
              vListEndKey: Word;
              vListEscKey: Word;
              vListToggleKey: Word;
              vListTagKey: Word;
              vListUntagKey: Word;
              vListLeftChar: Char;
              vListRightChar: Char;
              vListToggleOnChar: Char;
              vListToggleOffChar: Char;
              {methods...}
              Constructor Init;
              Procedure SetWindow (Border, Body, Icons, Title: Byte);
              Procedure SetWinKeys (Move, Stretch, Zoom: Word);
              Procedure SetListKeys (Endkey, Esc, Toggle, Tag, UnTag: Word);
              Procedure SetListChars (LeftChar, RightChar, ToggleOnChar, ToggleOffChar: Char);
              Procedure SetMenu (Bor, Tit, Icon, HiHot, HiNorm, LoHot, LoNorm, Off: Byte);
              Procedure SetDefaults;
              Function  WinBorder: Byte;
              Function  WinBody: Byte;
              Function  WinTitle: Byte;
              Function  WinIcons: Byte;
              Function  WinMoveKey: Word;
              Function  WinStretchKey: Word;
              Function  WinZoomKey: Word;
              Function  ListEndKey: Word;
              Function  ListEscKey: Word;
              Function  ListToggleKey: Word;
              Function  ListTagKey: Word;
              Function  ListUnTagKey: Word;
              Function  ListLeftChar: Char;
              Function  ListRightChar: Char;
              Function  ListToggleOnChar: Char;
              Function  ListToggleOffChar: Char;
              Function  MenuBor: Byte;
              Function  MenuTit: Byte;
              Function  MenuIcon: Byte;
              Function  MenuHiHot: Byte;
              Function  MenuHiNorm: Byte;
              Function  MenuLoHot: Byte;
              Function  MenuLoNorm: Byte;
              Function  MenuOff: Byte;
              Destructor Done;
            End; {LookOBJ}
  
Var
  LookTOT:  ^LookOBJ;
  
Procedure DING;
Procedure LOOKinit;

Implementation

Procedure DING;
Begin
  Sound (2000); Delay (100); NoSound;
End; {Ding}
{|||||||||||||||||||||||||||||||||||||||}
{                                       }
{     L o o k O B J   M E T H O D S     }
{                                       }
{|||||||||||||||||||||||||||||||||||||||}
Constructor LookOBJ. Init;
{}
Begin
  SetDefaults;
End; {LookOBJ.Init}

Procedure LookOBJ. SetWindow (Border, Body, Icons, Title: Byte);
{}
Begin
  vWinBorder := Border;
  vWinBody := Body;
  vWinIcons := Icons; 
  vWinTitle := Title; 
End; {LookOBJ.SetWarning}

Procedure LookOBJ. SetWinKeys (Move, Stretch, Zoom: Word);
{}
Begin
  vWinMoveKey   := Move;
  vWinStretchKey := Stretch;
  vWinZoomKey   := Zoom;
End; {LookOBJ.SetWinKeys}

Procedure LookOBJ. SetListKeys (Endkey, Esc, Toggle, Tag, UnTag: Word);
{}
Begin
  vListEndKey   := Endkey;
  vListEscKey   := Esc;
  vListToggleKey := Toggle;
  vListTagKey   := Tag;
  vListUnTagKey := UnTag;
End; {LookOBJ.SetListKeys}

Procedure LookOBJ. SetListChars (LeftChar, RightChar, ToggleOnChar, ToggleOffChar: Char);
{}
Begin
  vListLeftChar   := LeftChar;
  vListRightChar  := RightChar;
  vListToggleOnChar := ToggleOnChar;
  vListToggleOffChar := ToggleOffChar;
End; {LookOBJ.SetListChars}

Procedure LookOBJ. SetMenu (Bor, Tit, Icon, HiHot, HiNorm, LoHot, LoNorm, Off: Byte);
{}
Begin
  vMenuBorder := Bor;
  vMenuTitle := Tit; 
  vMenuIcon := Icon; 
  vMenuHiHot := HiHot; 
  vMenuHiNorm := HiNorm;
  vMenuLoHot := LoHot; 
  vMenuLoNorm :=  LoNorm;
  vMenuInActive := Off;
End; {of proc LookOBJ.SetMenu}

Procedure LookOBJ. SetDefaults;
{}
Begin
  If Monitor^. ColorOn Then {color System}
  Begin
    vWinBorder := 31;       {lightred on red}
    vWinBody := 23;         {white on red}
    vWinIcons := 23;        {lightcyan on red}
    vWinTitle := 23;        {yellow on red}
    vMenuBorder := 23;      {lightgray on blue}
    vMenuTitle := 31;       {yellow on blue}
    vMenuIcon := 27;       {lightcyan on blue}
    vMenuHiHot := 63;       {yellow on red}
    vMenuHiNorm := 48;      {white on red}
    vMenuLoHot := 31;       {yellow on blue}
    vMenuLoNorm := 23;      {white on blue}
    vMenuInActive := 24;    {lightgray on blue}
    SetListChars (#0, #0, Chr (251), ' ');
  End
  Else                    {monochrome}
  Begin
    vWinBorder := 112;      {black on lightgray}
    vWinBody := 112;
    vWinIcons := 112;
    vWinTitle := 112;
    vMenuBorder := 112;
    vMenuTitle := 112;
    vMenuIcon := 112;
    vMenuHiHot := 7;        {lightgray on black}
    vMenuHiNorm := 15;      {white on black}
    vMenuLoHot := 15;       {white on black}
    vMenuLoNorm := 112;     {black on lightgray}
    vMenuInActive := 8;     {darkgray on black}
    SetListChars (Chr (16), Chr (17), Chr (251), ' ');
  End;
  vWinMoveKey   := 354;      {Ctrl-F5}
  vWinStretchKey := 364;      {Alt-F5}
  vWinZoomKey   := 319;      {F5}
  vListEndKey   := 324;      {F10}
  vListEscKey   := 27;       {Esc}
  vListToggleKey := 32;       {space bar}
  vListTagKey   := 276;      {Alt-T}
  vListUnTagKey := 278;      {Alt-U}
End; {LookOBJ.SetDefaults}

Function LookOBJ. WinBorder: Byte;
{}
Begin
  WinBorder := vWinBorder;
End; {of func LookOBJ.WinBorder}

Function LookOBJ. WinBody: Byte;
{}
Begin
  WinBody := vWinBody;
End; {of func LookOBJ.WinBody}

Function LookOBJ. WinIcons: Byte;
{}
Begin
  WinIcons := vWinIcons;
End; {of func LookOBJ.WinIcons}

Function LookOBJ. WinTitle: Byte;
{}
Begin
  WinTitle := vWinTitle;
End; {LookOBJ.WinTitle}

Function LookOBJ. WinMoveKey: Word;
{}
Begin
  WinMoveKey := vWinMoveKey;
End; {LookOBJ.WinMoveKey}

Function LookOBJ. WinStretchKey: Word;
{}
Begin
  WinStretchKey := vWinStretchKey;
End; {LookOBJ.WinStretchKey}

Function LookOBJ. WinZoomKey: Word;
{}
Begin
  WinZoomKey := vWinZoomKey;
End; {LookOBJ.WinZoomKey}

Function LookOBJ. ListEndKey: Word;
{}
Begin
  ListEndKey := vListEndKey;
End; {LookOBJ.ListEndKey}

Function LookOBJ. ListEscKey: Word;
{}
Begin
  ListEscKey := vListEscKey;
End; {LookOBJ.ListEscKey}

Function LookOBJ. ListToggleKey: Word;
{}
Begin
  ListToggleKey := vListToggleKey;
End; {LookOBJ.ListToggleKey}

Function LookOBJ. ListTagKey: Word;
{}
Begin
  ListTagKey := vListTagKey;
End; {LookOBJ.ListTagKey}

Function LookOBJ. ListUnTagKey: Word;
{}
Begin
  ListUnTagKey := vListUnTagKey;
End; {LookOBJ.ListUnTagKey}

Function LookOBJ. ListLeftChar: Char;
{}
Begin
  ListLeftChar := vListLeftChar;
End; {LookOBJ.ListLeftChar}

Function LookOBJ. ListRightChar: Char;
{}
Begin
  ListRightChar := vListRightChar;
End; {LookOBJ.ListRightChar}

Function LookOBJ. ListToggleOnChar: Char;
{}
Begin
  ListToggleOnChar := vListToggleOnChar;
End; {LookOBJ.ListToggleOnChar}

Function LookOBJ. ListToggleOffChar: Char;
{}
Begin
  ListToggleOffChar := vListToggleOffChar;
End; {LookOBJ.ListToggleOffChar}

Function LookOBJ. MenuBor: Byte;
{}
Begin
  MenuBor := vMenuBorder;
End; {of func LookOBJ.MenuBor}

Function LookOBJ. MenuTit: Byte;
{}
Begin
  MenuTit := vMenuTitle;
End; {of func LookOBJ.MenuTit}

Function LookOBJ. MenuIcon: Byte;
{}
Begin
  MenuIcon := vMenuIcon;
End; {of func LookOBJ.MenuIcon}

Function LookOBJ. MenuHiHot: Byte;
{}
Begin
  MenuHiHot := vMenuHiHot;
End; {of func LookOBJ.MenuHiHot}

Function LookOBJ. MenuHiNorm: Byte;
{}
Begin
  MenuHiNorm := vMenuHiNorm;
End; {of func LookOBJ.MenuHiNorm}

Function LookOBJ. MenuLoHot: Byte;
{}
Begin
  MenuLoHot := vMenuLoHot;
End; {of func LookOBJ.MenuLoHot}

Function LookOBJ. MenuLoNorm: Byte;
{}
Begin
  MenuLoNorm := vMenuLoNorm;
End; {of func LookOBJ.MenuLoNorm}

Function LookOBJ. MenuOff: Byte;
{}
Begin
  MenuOff := vMenuInActive;
End; {of func LookOBJ.MenuOff}

Destructor LookOBJ. Done;
Begin End;
{|||||||||||||||||||||||||||||||||||||||||||||||}
{                                               }
{     U N I T   I N I T I A L I Z A T I O N     }
{                                               }
{|||||||||||||||||||||||||||||||||||||||||||||||}
Procedure LookInit;
{initilizes objects and global variables}
Begin
  New (LookTOT, Init);
End; {procedure LookInit}

{end of unit - add intialization routines below}
{$IFNDEF OVERLAY}
Begin
  LookInit;
  {$ENDIF}
End.

