'$FORM PrimaryWindow
'$INCLUDE: 'VBQUERY.BI'
'$INCLUDE: 'VBDSQL.BI'

SUB ChangePrimaryWindowCaption ()
	PrimaryWindow.Caption = PrimaryWindowTitle + " - " + Servername$ + "/" + DatabaseName$
END SUB

FUNCTION CheckServerConnection () AS INTEGER
	IF SqlConn <> 0 THEN
		CheckServerConnection = 1
	ELSE
		CheckServerConnection = 0
	END IF
END FUNCTION

SUB DoubleQuotes (InString AS STRING)

REM
REM This will replace all double quotes with ""
REM and all single quotes with ''
REM

DOUBLEQUOTE$ = CHR$(34) + CHR$(34)
SINGLEQUOTE$ = CHR$(39) + CHR$(39)
STATIC mychar AS STRING * 1

REM
REM Get the length of the string coming in
REM Set the length of TmpString to length of string coming in + 100 new chars
REM

y% = LEN(InString)
TmpString$ = SPACE$(y% + 100)
i% = 1

FOR x% = 1 TO y%

	mychar$ = MID$(InString, x%, 1)
	IF mychar$ = CHR$(34) THEN
	MID$(TmpString$, i%, 2) = DOUBLEQUOTE$
	i% = i% + 1
	ELSE
	IF mychar$ = CHR$(39) THEN
		MID$(TmpString$, i%, 2) = SINGLEQUOTE$
		i% = i% + 1
	ELSE
		mychar$ = MID$(InString, x%, 1)
		MID$(TmpString$, i%) = mychar$
	END IF
	END IF
	i% = i% + 1
NEXT x%

InString$ = RTRIM$(TmpString$)

END SUB

FUNCTION ExecuteSQLCommand (cmd AS STRING) AS INTEGER

REM
REM This routine executes a command(s) and returns whether the
REM execute succeeded or failed.
REM

SQLStatus% = SUCCEED
ExecuteSQLCommand = SUCCEED
IF SqlCmd(SqlConn, cmd$) = FAIL% THEN
	SQLStatus% = FAIL
	ExecuteSQLCommand = FAIL
END IF
IF SqlExec(SqlConn) = FAIL% THEN
	SQLStatus% = FAIL
	ExecuteSQLCommand = FAIL
END IF
END FUNCTION

SUB FixTextLineFeeds (InString AS STRING)

REM
REM This will replace all LF characters in the InString with CRLF
REM

CRLF$ = CHR$(13) + CHR$(10)
LF$ = CHR$(10)

REM
REM Get the length of the string coming in
REM Set the length of TmpString to length of string coming in + 100 new chars
REM

y% = LEN(InString)
TmpString$ = SPACE$(y% + 100)
i% = 1

FOR x% = 1 TO y%

	mychar$ = MID$(InString, x%, 1)
	IF mychar$ = LF$ THEN
	MID$(TmpString$, i%, 1) = CRLF$
	i% = i% + 1
	ELSE
	mychar$ = MID$(InString, x%, 1)
	MID$(TmpString$, i%) = mychar$
	END IF
	i% = i% + 1
NEXT x%

InString$ = RTRIM$(TmpString$)
END SUB

FUNCTION GetDatabases (Database_Control AS CONTROL) AS INTEGER

REM
REM This routine gets the name of all the databases on the SQL Server.
REM Fill each element in the combobox or list box which is passed into this procedure
REM execute the command.  Get each database name and fill the combobox.
REM

	IF ExecuteSQLCommand("Select name from master..sysdatabases") = FAIL% THEN
	GetDatabases = FAIL
	EXIT FUNCTION
	ELSE
	IF SqlResults(SqlConn) = FAIL% THEN EXIT FUNCTION
	WHILE SqlNextRow(SqlConn) <> NOMOREROWS%
		Database_Control.ADDITEM SqlData(SqlConn, 1)
	WEND
	END IF

REM If this is a combobox we are filling, then display the first database in the list to start with

	IF TYPEOF Database_Control IS ComboBox THEN
	Database_Control.Text = Database_Control.List(0)
	END IF

	GetDatabases = SUCCEED
END FUNCTION

FUNCTION LoginToServer () AS INTEGER

LoginToServer = SUCCEED

REM
REM Check to see if the connection is live, if so, then close it
REM Set the max time to login to 30 seconds
REM Open the new connection
REM Change the caption of the application to reflect the server name and the database
REM Set the max time we will wait for a SQL Server response
REM

IF SqlConn <> 0 THEN SqlClose (SqlConn)
Status% = SqlSetLoginTime%(LoginTimeout%)
SqlConn = SqlOpenConnection(Servername$, LoginID$, password$, ProgramName$, ProgramName$)
IF SqlConn <> 0 THEN
	DatabaseName$ = SqlName(SqlConn)
	ChangePrimaryWindowCaption
	Result% = SqlSetTime%(QueryTimeout%)
ELSE
	DatabaseName$ = ""
	Servername$ = ""
	LoginToServer = FAIL
END IF

END FUNCTION

SUB Logoff ()
	IF SqlConn <> 0 THEN
	SqlClose (SqlConn)
	Servername$ = "[No server]"
	DatabaseName$ = "[no database]"
	ChangePrimaryWindowCaption
	END IF
END SUB

FUNCTION MakeRuleList (Rawtext AS STRING) AS STRING

REM
REM This functions takes a rule of type "IN" from sp_helptext and makes it a
REM comma delimited list for easy use in list boxes
REM

start% = INSTR(1, Rawtext$, "'")
MakeRuleList = MID$(Rawtext$, start%, LEN(Rawtext$) - 2)
END FUNCTION

SUB ParseRule (Rulename() AS STRING)

REM
REM This routine takes the comma delimeted rules,which came from the
REM MakeRuleList procedure, removes the quotes and stores the values
REM in an array.  This is good for use in combo and list boxes.
REM

in$ = Rulename$(0)

start% = 1
FOR i% = 0 TO 100
	endpos% = INSTR(start% + 1, in$, "'")
	Rulename(i%) = MID$(in$, start% + 1, (endpos% - start%) - 1)
	start% = INSTR(endpos% + 1, in$, "'")
	IF start% = 0 THEN EXIT FOR
NEXT i%

END SUB

FUNCTION Process_SQL_query (cmd AS STRING, OutputData() AS STRING) AS LONG

REM
REM This routine will process query rows and output the total number
REM of rows which reflects the number of items in the output array.
REM
REM Define array for column lengths, column positions, and column types
REM Define structures for getting a compute column's information and getting
REM a regular column's information
REM

REM Declare a local error handler for string overflows
ON LOCAL ERROR GOTO CancelQuery

STATIC ColValue$
STATIC collengths() AS LONG
REDIM PRESERVE collengths(255) AS LONG
STATIC colpositions() AS INTEGER
REDIM PRESERVE colpositions(255) AS INTEGER
STATIC Coltypes() AS INTEGER
REDIM PRESERVE Coltypes(50) AS INTEGER

Process_SQL_query = 0

REM
REM Define the new line character and the tab key
REM Get the command from the QUERY_FIELD.
REM Fill the command buffer. If fail, then exit the subroutine.
REM Execute the command
REM

NL$ = CHR$(13) + CHR$(10)
COLSEP$ = " "

IF cmd$ <> "" THEN
	IF ExecuteSQLCommand(cmd$) = FAIL% THEN EXIT FUNCTION
END IF

outputrowcnt% = 0

REM
REM Get each set of results
REM Get the number of compute columns, order by columns, and select columns
REM Get the exact position of each column (for lining up compute columns)
REM

DO UNTIL ResultProcess% = NOMORERESULTS%
	ResultProcess% = SqlResults(SqlConn)
	IF ResultProcess% = NOMORERESULTS% OR ResultProcess% = FAIL THEN EXIT DO

	numcol% = SqlNumCols%(SqlConn)
	IF numcol% > 0 THEN
	numorder% = SqlNumOrders%(SqlConn)
	colline$ = ""
	coluline$ = ""

REM
REM Get the column name and length for each column
REM Format and output the column headings (max 256 chars wide).
REM

	FOR x% = 1 TO numcol%
	colname$ = SqlColName(SqlConn, x%)
	Coltypes(x%) = SqlColType(SqlConn, x%)
	collengths(x%) = SqlColLen(SqlConn, x%)
	
	' templen holds length of column data.  truncate text and image
	tmplen% = collengths(x%)
	IF tmplen% > 255 THEN tmplen% = 255
	
	actuallen& = LEN(colname$)
	
	IF x% = 1 THEN
	   colpositions(x%) = 1
	ELSE
		colpositions(x%) = LEN(colline$) + LEN(COLSEP$)
	END IF
	 
	IF actuallen& < tmplen% THEN
		colline$ = colline$ + colname$ + SPACE$((tmplen% - actuallen&) + 1) + COLSEP$
		coluline$ = coluline$ + STRING$(LEN(colname$), "_") + SPACE$((tmplen% - actuallen&) + 1) + COLSEP$
	ELSE
		colline$ = colline$ + colname$ + COLSEP$
		coluline$ = coluline$ + STRING$(LEN(colname$), "_") + COLSEP$
	END IF
	
	NEXT x%

	
	OutputData(outputrowcnt%) = colline$
	outputrowcnt% = outputrowcnt% + 1
	OutputData(outputrowcnt%) = coluline$
	outputrowcnt% = outputrowcnt% + 1
	OutputData(outputrowcnt%) = " "
	outputrowcnt% = outputrowcnt% + 1

	END IF   'end of numcol% > 0 test


REM
REM Get each row of data, and process according to type of row
REM Output each row into the list box
REM

	RowProcess% = 99
	DO UNTIL RowProcess% = NOMOREROWS%
	DataStr$ = ""
	Result% = SqlNextRow(SqlConn)
	IF Result% = NOMOREROWS% OR Result% = FAIL THEN EXIT DO

REM
REM Process a COMPUTE Row  (Available in VB Win only).
REM In DOS, this function pops up a message box saying COMPUTE rows are not supported.
REM

	IF Result% <> REGROW THEN
	Process_altrows Result%, OutputData(), outputrowcnt%, colpositions()
	ELSE

REM
REM Process a regular row.
REM Get the column value and length.
REM If it is a Text column, then change the LF to CRLF if they exist
REM Align columns even with the column headings.
REM
	FOR x% = 1 TO numcol%
		ColValue$ = SqlData(SqlConn, x%)
		actuallen& = LEN(ColValue$)
		IF actuallen& > 255 THEN
		ColValue$ = LEFT$(ColValue$, 255)
		actuallen& = 255
		END IF
			  
		IF Coltypes(x%) = SQLTEXT% THEN
		FixTextLineFeeds ColValue$
		END IF

		IF x% <> numcol% THEN
		DataStr$ = DataStr$ + ColValue$ + SPACE$(colpositions(x% + 1) - colpositions(x%) - actuallen&)
		ELSE
		DataStr$ = DataStr$ + ColValue$
		END IF

		ColValue$ = ""
	NEXT x%

	OutputData(outputrowcnt%) = DataStr$
	END IF
	outputrowcnt% = outputrowcnt% + 1

	LOOP        'End of row loop

REM
REM Output the number of rows affected by the query (if applicable)
REM Output the sort order (if applicable)
REM

	rowcnt& = SqlCount(SqlConn)
	IF SqlIsCount(SqlConn) THEN
	DataStr$ = "(" + STR$(rowcnt&) + " rows affected)"
	OutputData(outputrowcnt%) = " "
	OutputData(outputrowcnt% + 1) = DataStr$
	outputrowcnt% = outputrowcnt% + 2
	END IF

	IF numorder% > 0 THEN
	OutputData(outputrowcnt%) = " "
	DataStr$ = "Sort Order: "
	FOR y% = 1 TO numorder%
		ordercol$ = SqlColName(SqlConn, SqlOrderCol(SqlConn, y%))
		DataStr$ = DataStr$ + " " + ordercol$
	NEXT y%
	OutputData(outputrowcnt% + 1) = DataStr$
	outputrowcnt% = outputrowcnt% + 2
	END IF

LOOP        'End of result loop

REM
REM Check for return parameters and return status from stored procedures at the end
REM of every result set.  Available in VBWin only.
REM

Process_rpc_returns OutputData(), outputrowcnt%
Process_SQL_query = outputrowcnt%

EXIT FUNCTION

CancelQuery:
	Result% = SqlCancel%(SqlConn)
	Msg$ = "Error number " + STR$(ERR) + ":  " + ERROR$ + NL$
	Msg$ = Msg$ + "Query Cancelled" + NL$
	MSGBOX Msg$, MB_ICONEXCLAMATION, "Visual Basic Error"
	EXIT FUNCTION

END FUNCTION

FUNCTION UserSqlErrorHandler% (SqlConn AS LONG, Severity AS INTEGER, ErrorNum AS INTEGER, OsErr AS INTEGER, ErrorStr AS STRING, OsErrStr AS STRING)
'UserSqlErrorHander% - This function is REQUIRED for all VBDSQL applications.  It
'is called by the VB-DOS interface code for DB-LIBRARY whenever a
'DB-LIBRARY error occurs.  In VB-Win, it can be called from the error event handler.

'This function can do anything EXCEPT call another
'DB-LIBRARY function (with the exception of SqlDead%, which you can
'call to determine if the connection is still intact).
'
'You can return 1 of 3 values:
' INTEXIT     - exit the program
' INTCANCEL   - cancel the operation
' INTCONTINUE - continue the operation (can only continue on timeout read
'                    errors, which usually occur if a table that is locked
'                    is updated or read)
'

REM
REM Only display message if it's not a notification that there's a server error
REM

	IF ErrorNum% <> SQLESMSG% THEN
	MSGBOX ("DBLibrary Error: " + STR$(ErrorNum%) + " " + ErrorStr$)
	END IF



	'If an operating-system error occurred, print the error string.
	 IF OsErr% <> -1 THEN
		MSGBOX ("Operating-System Error: " + OsErrStr$)
	 END IF

	'Exit if the error is fatal.
	IF Severity% = EXFATAL THEN
		UserSqlErrorHandler% = INTEXIT
	ELSE
		UserSqlErrorHandler% = INTCANCEL
	END IF


END FUNCTION

SUB UserSqlMsgHandler (SqlConn AS LONG, Message AS LONG, State AS INTEGER, Severity AS INTEGER, MsgStr AS STRING)
'UserSqlMsgHandler - This procedure is REQUIRED for VBDSQL applicaitons.
'In VB-DOS, it is called by BASIC DB-LIBRARY whenever a connected server needs to
'issue a message to the client.  You can call it from the message handler event
'in VB-Win

NL$ = CHR$(13) + CHR$(10)

REM
REM Only display the message if it's not a general msg or a change language message
REM

	IF Message& <> 5701 AND Message& <> 5703 THEN
	Msg$ = "SQL Server Error: " + STR$(Message&) + " " + MsgStr$ + NL$
	Msg$ = Msg$ + "State=" + STR$(State%) + ", Severity=" + STR$(Severity)

	MSGBOX Msg$
	END IF
	

END SUB

FUNCTION WarningMessage (MsgStr AS STRING) AS INTEGER

REM
REM This routine displays a warning message with a YES and NO button
REM and returns the result.
REM

CONST MB_YESNO = 4
CONST MB_ICONEXLAMATION = 48
CONST IDYES = 6
CONST IDNO = 7
CONST DEFBUTTON2 = 256

DgDef% = MB_YESNO + MB_ICONEXCLAMATION + MB_DEFBUTTON2
Response% = MSGBOX(MsgStr$, DgDef%, "System Warning")
IF Response% = IDNO THEN
	WarningMessage = 0
ELSE
	WarningMessage = 1
END IF
END FUNCTION

