Version 1.00
BEGIN Form PrimaryWindow
	AutoRedraw   = 0
	BackColor    = QBColor(3)
	BorderStyle  = 2
	Caption      = "VBSQL Sample Query Tool - [No Server]"
	ControlBox   = -1
	Enabled      = -1
	ForeColor    = QBColor(0)
	Height       = Char(23)
	Left         = Char(2)
	MaxButton    = -1
	MinButton    = -1
	MousePointer = 0
	Tag          = ""
	Top          = Char(1)
	Visible      = -1
	Width        = Char(74)
	WindowState  = 0
	BEGIN Label Label1
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(3)
		BorderStyle  = 0
		Caption      = "&Query:"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(1)
		MousePointer = 0
		TabIndex     = 0
		Tag          = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(6)
	END
	BEGIN CommandButton SEND_QUERY_BUTTON
		BackColor    = QBColor(3)
		Cancel       = 0
		Caption      = "&Send Query"
		Default      = 0
		DragMode     = 0
		Enabled      = 0
		Height       = Char(3)
		Left         = Char(59)
		MousePointer = 0
		TabIndex     = 5
		TabStop      = -1
		Tag          = ""
		Top          = Char(4)
		Visible      = -1
		Width        = Char(12)
	END
	BEGIN CommandButton NEW_QUERY_BUTTON
		BackColor    = QBColor(3)
		Cancel       = 0
		Caption      = "&New Query"
		Default      = 0
		DragMode     = 0
		Enabled      = 0
		Height       = Char(3)
		Left         = Char(59)
		MousePointer = 0
		TabIndex     = 4
		TabStop      = -1
		Tag          = ""
		Top          = Char(0)
		Visible      = -1
		Width        = Char(12)
	END
	BEGIN Label Label2
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(3)
		BorderStyle  = 0
		Caption      = "&Results:"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(1)
		MousePointer = 0
		TabIndex     = 2
		Tag          = ""
		Top          = Char(7)
		Visible      = -1
		Width        = Char(6)
	END
	BEGIN TextBox QUERY_FIELD
		BackColor    = QBColor(15)
		BorderStyle  = 1
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(5)
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = -1
		ScrollBars   = 3
		TabIndex     = 1
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(2)
		Visible      = -1
		Width        = Char(54)
	END
	BEGIN TextBox RESULT_FIELD
		BackColor    = QBColor(15)
		BorderStyle  = 1
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(12)
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = -1
		ScrollBars   = 3
		TabIndex     = 3
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(8)
		Visible      = -1
		Width        = Char(71)
	END
	BEGIN Menu CONNECT_MENU
		Caption      = "&Connection"
		Checked      = 0
		Enabled      = -1
		Separator    = 0
		Tag          = ""
		Visible      = -1
		BEGIN Menu LOGIN_MENU
			Caption      = "&Login"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu DATABASE_MENU
			Caption      = "Change &Database"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu EXIT_MENU
			Caption      = "E&xit"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
	END
	BEGIN Menu ABOUT_MENU
		Caption      = "&About"
		Checked      = 0
		Enabled      = -1
		Separator    = 0
		Tag          = ""
		Visible      = -1
	END
END
'$INCLUDE: 'VBQUERY.BI'
'$INCLUDE: 'VBDSQL.BI'
'$FORM CHNGDB
'$FORM login
'$FORM About_Form

DECLARE SUB ClearFields ()

SUB ABOUT_MENU_Click ()
	About_Form.SHOW 1
END SUB

SUB ClearFields ()
	QUERY_FIELD.Text = ""
	RESULT_FIELD.Text = ""
END SUB

SUB DATABASE_MENU_Click ()
	IF SqlConn = 0 THEN
		MSGBOX "Must login first"
		EXIT SUB
	END IF
	CHNGDB.SHOW 1
END SUB

SUB EXIT_MENU_Click ()

	ExitApplication
END SUB

SUB Form_Load ()

REM
REM Initialize the connection to SQL Server
REM
	InitializeApplication
	MSGBOX DBLIB_VERSION$
	PrimaryWindowTitle = "VBSQL Sample Query Tool"
END SUB

SUB LOGIN_MENU_Click ()
	
	login.SHOW 1
	NEW_QUERY_BUTTON.Enabled = -1
	SEND_QUERY_BUTTON.Enabled = -1

END SUB

SUB NEW_QUERY_BUTTON_Click ()
	ClearFields
	QUERY_FIELD.SETFOCUS
END SUB

SUB SEND_QUERY_BUTTON_Click ()
	
ON LOCAL ERROR GOTO OutofRoom

STATIC OutputData() AS STRING
REDIM PRESERVE OutputData(500) AS STRING

REM
REM Get the query.  Make sure there is one
REM

CRLF$ = CHR$(13) + CHR$(10)

cmd$ = QUERY_FIELD.Text

IF cmd$ = "" THEN
	MSGBOX "There is no query in the Query field"
	EXIT SUB
END IF

REM
REM Clear the result array, and result controls first
REM

i% = 0
FOR i% = 0 TO 499
	OutputData(i%) = ""
NEXT

REM
REM Fill the result array with the data
REM Fill the results field
REM

RESULT_FIELD.Text = ""
numrows& = Process_SQL_query(cmd$, OutputData())


'fill temporary string first, to avoid flashing with every row

FOR i% = 0 TO numrows& - 1
	DataLine$ = DataLine$ + OutputData(i%) + CRLF$

NEXT i%

RESULT_FIELD.Text = DataLine$
QUERY_FIELD.SETFOCUS

EXIT SUB

OutofRoom:
'can run out of space filling strings.  If so, try just 20 rows
DataLine$ = ""
IF numrows& > 20 THEN
	numrows& = 20

	FOR i% = 0 TO numrows& - 1
		DataLine$ = DataLine$ + OutputData(i%) + CRLF$
	NEXT i%

	RESULT_FIELD.Text = DataLine$
END IF
MSGBOX "Out of room, output truncated"
QUERY_FIELD.SETFOCUS
EXIT SUB

END SUB

