' SQL.BI -- This file contains all the declarations for functions and
' procedures in the Quick Basic library for SQL Server (BSQL).  In addition
' all constants and values used by the libraries are also contained in this
' file.  All source files that utilize any part of this interface must include
' this file.
'
' Copyright (c) 1990 by Microsoft Corp.  All rights reserved.
'

' Function/Procedure prototypes for the Basic Library interface.
DECLARE FUNCTION SqlOrderCol% (sqlconn&, column%)
DECLARE FUNCTION SqlColLen& (sqlconn&, column%)
DECLARE FUNCTION SqlColName$ (sqlconn&, column%)
DECLARE FUNCTION SqlColType% (sqlconn&, column%)
DECLARE FUNCTION SqlData$ (sqlconn&, column%)
DECLARE FUNCTION SqlDatLen& (sqlconn&, column%)
DECLARE FUNCTION SqlNumCols% (sqlconn&)
DECLARE FUNCTION SqlCmd% (sqlconn&, cmd$)
DECLARE FUNCTION SqlStrCpy% (sqlconn&, start%, length%, buffer$)
DECLARE FUNCTION SqlLogin& ()
DECLARE FUNCTION SqlResults% (sqlconn&)
DECLARE FUNCTION SqlNextRow% (sqlconn&)
DECLARE SUB SqlClose (sqlconn&)
DECLARE FUNCTION SqlOpen& (loginrec&, server$)
DECLARE FUNCTION SqlStrLen% (sqlconn&)
DECLARE FUNCTION SqlExec% (sqlconn&)
DECLARE FUNCTION SqlOk% (sqlconn&)
DECLARE FUNCTION SqlSend% (sqlconn&)
DECLARE FUNCTION SqlCanQuery% (sqlconn&)
DECLARE FUNCTION SqlGetRow% (sqlconn&, row&)
DECLARE FUNCTION SqlSetTime% (timeout%)
DECLARE FUNCTION SqlSetLoginTime% (timeout%)
DECLARE FUNCTION SqlDataReady% (sqlconn&)
DECLARE FUNCTION SqlCancel% (sqlconn&)
DECLARE FUNCTION SqlClrOpt% (sqlconn&, opt%, param$)
DECLARE FUNCTION SqlIsOpt% (sqlconn&, opt%, param$)
DECLARE FUNCTION SqlSetOpt% (sqlconn&, opt%, param$)
DECLARE SUB SqlFreeLogin (loginrec&)
DECLARE SUB SqlClrBuf (sqlconn&, rows&)
DECLARE SUB SqlExit ()
DECLARE SUB SqlFreeBuf (sqlconn&)
DECLARE FUNCTION SqlSetLHost% (loginrec&, host$)
DECLARE FUNCTION SqlSetLUser% (loginrec&, user$)
DECLARE FUNCTION SqlSetLPwd% (loginrec&, pwd$)
DECLARE FUNCTION SqlSetLApp% (loginrec&, app$)
DECLARE FUNCTION SqlInit$ ()
DECLARE FUNCTION SqlDead% (sqlconn&)
DECLARE FUNCTION SqlGetTime% (sqlconn&)
DECLARE FUNCTION SqlCount& (sqlconn&)
DECLARE FUNCTION SqlCurCmd% (sqlconn&)
DECLARE FUNCTION SqlCurRow& (sqlconn&)
DECLARE FUNCTION SqlFirstRow& (sqlconn&)
DECLARE FUNCTION SqlLastRow& (sqlconn&)
DECLARE FUNCTION SqlNumOrders% (sqlconn&)
DECLARE FUNCTION SqlRows% (sqlconn&)
DECLARE FUNCTION SqlMoreCmds% (sqlconn&)
DECLARE FUNCTION SqlRowType% (sqlconn&)
DECLARE FUNCTION SqlCmdRow% (sqlconn&)
DECLARE FUNCTION SqlPrRow% (sqlconn&)
DECLARE SUB SqlPrHead (sqlconn&)
DECLARE FUNCTION SqlColBrowse%(sqlconn&, column%)
DECLARE FUNCTION SqlColSource$(sqlconn&, column%)
DECLARE FUNCTION SqlQual$(sqlconn&, tabnum%, tabname$)
DECLARE FUNCTION SqlTabBrowse%(sqlconn&, tabnum%)
DECLARE FUNCTION SqlTabSource$(sqlconn&, column%, tabnum%)
DECLARE FUNCTION SqlTabCount%(sqlconn&)
DECLARE FUNCTION SqlTabName$(sqlconn&, tabnum%)
DECLARE FUNCTION SqlTsNewLen%(sqlconn&)
DECLARE FUNCTION SqlTsNewVal&(sqlconn&)
DECLARE FUNCTION SqlTsPut%(sqlconn&, newts&, newtslen%, tabnum%, tabname$)
DECLARE FUNCTION SqlMoreText%(sqlconn&, size&, text$)
DECLARE FUNCTION SqlTxPtr& (sqlconn&, column%)
DECLARE FUNCTION SqlTxTimestamp& (sqlconn&, column%)
DECLARE FUNCTION SqlTxTsNewVal& (sqlconn&)
DECLARE FUNCTION SqlTxTsPut% (sqlconn&, newtxts&, column%)
DECLARE FUNCTION SqlWriteText% (sqlconn&, objname$, textptr&, textptrlen%, timestamp&, logs%, size&, text$)
DECLARE FUNCTION SqlUse%(sqlconn&, dbname$)
DECLARE FUNCTION SqlName$(sqlconn&)
DECLARE FUNCTION SqlChange$(sqlconn&)
DECLARE FUNCTION SqlColUType&(sqlconn&,column%)
DECLARE FUNCTION SqlIsAvail%(sqlconn&)
DECLARE FUNCTION SqlIsCount%(sqlconn&)
DECLARE FUNCTION SqlGetMaxProcs%()
DECLARE FUNCTION SqlSetMaxProcs%(maxprocs%)
DECLARE SUB SqlSetAvail(sqlconn&)
DECLARE FUNCTION SqlOpenConnection&(server$,user$,password$,workstation$,application$)
DECLARE FUNCTION SqlSetLNatLang%(loginrec&,language$)
DECLARE FUNCTION UserSqlErrorHandler% (SqlConn&, State%, DbErr%, OsErr%,DbErrStr$, OsErrStr$)
DECLARE SUB UserSqlMsgHandler (SqlConn&, MsgNo&, Severity%, Level%, Msg$)

' return values permitted in error handlers
CONST INTEXIT%        = 0
CONST INTCONTINUE%    = 1
CONST INTCANCEL%      = 2

' option values permitted in option setting/querying/clearing
' used by SqlSetOpt%(), SqlIsOpt%(), and SqlClrOpt%().
CONST SQLBUFFER%       = 0
CONST SQLROWCOUNT%     = 2
CONST SQLSTAT%         = 3
CONST SQLTEXTLIMIT%    = 4
CONST SQLTEXTSIZE%     = 5
CONST SQLARITHABORT%   = 6
CONST SQLARITHIGNORE%  = 7
CONST SQLNOAUTOFREE%   = 8
CONST SQLNOCOUNT%      = 9
CONST SQLNOEXEC%       = 10
CONST SQLPARSEONLY%    = 11
CONST SQLSHOWPLAN%     = 12
CONST SQLSTORPROCID%   = 13

' Data type token values.  Used for datatype determination for a column.
CONST SQLTEXT%        = &H23
CONST SQLARRAY%       = &H24
CONST SQLVARBINARY%   = &H25
CONST SQLINTN%        = &H26
CONST SQLVARCHAR%     = &H27
CONST SQLBINARY%      = &H2D
CONST SQLIMAGE%       = &H22
CONST SQLCHAR%        = &H2F
CONST SQLINT1%        = &H30
CONST SQLBIT%         = &H32
CONST SQLINT2%        = &H34
CONST SQLINT4%        = &H38
CONST SQLMONEY%       = &H3C
CONST SQLDATETIME%    = &H3D
CONST SQLFLT8%        = &H3E
CONST SQLFLTN%        = &H6D
CONST SQLMONEYN%      = &H6E
CONST SQLDATETIMN%    = &H6F
CONST SQLMONEY4%      = &H7A
CONST SQLDATETIM4%    = &H3A
CONST SQLFLT4%        = &H3B


' error numbers BSQL error codes that are passed to local error
' handler
CONST SQLEMEM%   = 10000
CONST SQLENULL%  = 10001
CONST SQLENLOG%  = 10002
CONST SQLEPWD%   = 10003
CONST SQLECONN%  = 10004
CONST SQLEDDNE%  = 10005
CONST SQLNULLO%  = 10006
CONST SQLESMSG%  = 10007
CONST SQLEBTOK%  = 10008
CONST SQLENSPE%  = 10009
CONST SQLEREAD%  = 10010
CONST SQLECNOR%  = 10011
CONST SQLETSIT%  = 10012
CONST SQLEPARM%  = 10013
CONST SQLEAUTN%  = 10014
CONST SQLECOFL%  = 10015
CONST SQLERDCN%  = 10016
CONST SQLEICN%   = 10017
CONST SQLECLOS%  = 10018
CONST SQLENTXT%  = 10019
CONST SQLEDNTI%  = 10020
CONST SQLETMTD%  = 10021
CONST SQLEASEC%  = 10022
CONST SQLENTLL%  = 10023
CONST SQLETIME%  = 10024
CONST SQLEWRIT%  = 10025
CONST SQLEMODE%  = 10026
CONST SQLEOOB%   = 10027
CONST SQLEITIM%  = 10028
CONST SQLEDBPS%  = 10029
CONST SQLEIOPT%  = 10030
CONST SQLEASNL%  = 10031
CONST SQLEASUL%  = 10032
CONST SQLENPRM%  = 10033
CONST SQLEDBOP%  = 10034
CONST SQLENSIP%  = 10035
CONST SQLECNULL% = 10036
CONST SQLESEOF%  = 10037
CONST SQLERPND%  = 10038
CONST SQLECSYN%  = 10039
CONST SQLENONET% = 10040
CONST SQLEBTYP%  = 10041
CONST SQLEABNC%  = 10042
CONST SQLEABMT%  = 10043
CONST SQLEABNP%  = 10044
CONST SQLEBNCR%  = 10045
CONST SQLEAAMT%  = 10046
CONST SQLENXID%  = 10047

' The severity levels are defined here for error handlers
CONST EXINFO%        = 1       	' informational, non-error
CONST EXUSER%        = 2       	' user error
CONST EXNONFATAL%    = 3    	' non-fatal error
CONST EXCONVERSION%  = 4  	' Error in BSQL data conversion.
CONST EXSERVER%      = 5      	' The Server has returned an error flag.
CONST EXTIME%        = 6       	' We have exceeded our timeout period while
				'  waiting for a response from the Server -
				'   the sqlconn& is still alive.
CONST EXPROGRAM%     = 7     	' coding error in user program
CONST EXRESOURCE%    = 8    	' running out of resources - the sqlconn&
				' may be dead.
CONST EXCOMM%        = 9       	' failure in communication with Server -
				' the sqlconn& is dead.
CONST EXFATAL%       = 10     	' fatal error - the sqlconn& is dead.
CONST EXCONSISTENCY% = 11	' internal software error  - notify MS
				' Technical Supprt.


' return coded used by all functions the return standard return codes
CONST SUCCEED%      = 1
CONST FAIL%         = 0

' return values used by SqlNextRow%(), SqlResults%() and a number of
' functions that return state of query.
CONST MOREROWS%       = -1
CONST NOMOREROWS%    = -2
CONST REGROW%         = -1
CONST BUFFULL%        = -3
CONST NOMORERESULTS% =  2


' constant for text pointer length
CONST SQLTXPLEN%      = 16

' constant for length of text timestamp
CONST SQLTXTSLEN%      =  8


