'VBDOSHDL.BAS -- This file is an example of user error/message handlers
'for VB DOS DB-LIBRARY.  It contains the default error handlers contained
'in the SQLVBDOS Quick libraries, and shows how you can set up your own
'error and message handlers.

'Copyright (c) 1992 by Microsoft Corp.  All rights reserved.


'$INCLUDE: 'vbdsql.bi'

'UserSqlErrorHander% - This function is REQUIRED for all VBDSQL applications.  It
'is called by the VB-DOS interface code for DB-LIBRARY whenever a
'DB-LIBRARY error occurs.  In VB-Win, it can be called from the error event handler.

'This function can do anything EXCEPT call another
'DB-LIBRARY function (with the exception of SqlDead%, which you can
'call to determine if the connection is still intact).
'
'You can return 1 of 3 values:
' INTEXIT     - exit the program
' INTCANCEL   - cancel the operation
' INTCONTINUE - continue the operation (can only continue on timeout read
'                    errors, which usually occur if a table that is locked
'                    is updated or read)
'

FUNCTION UserSqlErrorHandler% (SqlConn AS LONG, Severity AS INTEGER, ErrorNum AS INTEGER, OsErr AS INTEGER, ErrorStr AS STRING, OsErrStr AS STRING)

Rem
Rem Only display message if it's not a notification that there's a server error
Rem

	IF ErrorNum% <> SQLESMSG% THEN
	MSGBOX ("DBLibrary Error: " + STR$(ErrorNum%) + " " + ErrorStr$)
	END IF



	'If an operating-system error occurred, print the error string.
	 IF OsErr% <> -1 THEN
		MSGBOX ("Operating-System Error: " + OsErrStr$)
	 END IF

	'Exit if the error is fatal.
	IF Severity% = EXFATAL THEN
		UserSqlErrorHandler% = INTEXIT
	ELSE
		UserSqlErrorHandler% = INTCANCEL
	END IF


END FUNCTION

'UserSqlMsgHandler - This procedure is REQUIRED for VBDSQL applications.
'In VB-DOS, it is called by BASIC DB-LIBRARY whenever a connected server needs to
'issue a message to the client.  You can call it from the message handler event
'in VB-Win

SUB UserSqlMsgHandler (SqlConn AS LONG, Message AS LONG, State AS INTEGER, Severity AS INTEGER, MsgStr AS STRING)

NL$ = CHR$(13) + CHR$(10)

REM
REM Only display the message if it's not a general msg or a change language message
REM

	IF Message& <> 5701 AND Message& <> 5703 THEN
	Msg$ = "SQL Server Error: " + STR$(Message&) + " " + MsgStr$ + NL$
	Msg$ = Msg$ + "State=" + STR$(State%) + ", Severity=" + STR$(Severity)

	MSGBOX Msg$
	END IF
	

END SUB
