Version 1.00
BEGIN Form PrimaryWindow
	AutoRedraw   = 0
	BackColor    = QBColor(7)
	BorderStyle  = 1
	Caption      = "Text"
	ControlBox   = 0
	Enabled      = -1
	ForeColor    = QBColor(0)
	Height       = Char(24)
	Left         = Char(4)
	MaxButton    = 0
	MinButton    = -1
	MousePointer = 0
	Tag          = ""
	Top          = Char(0)
	Visible      = -1
	Width        = Char(69)
	WindowState  = 0
	BEGIN Frame VBSQL1
		BackColor    = QBColor(7)
		Caption      = "SQL Err/Msg"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(47)
		MousePointer = 0
		TabIndex     = 13
		Tag          = ""
		Top          = Char(10)
		Visible      = 0
		Width        = Char(17)
	END
	BEGIN Label Label2
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "Text file title:"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(25)
		MousePointer = 0
		TabIndex     = 3
		Tag          = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN TextBox Title_Edit
		BackColor    = QBColor(7)
		BorderStyle  = 1
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(42)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 2
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(23)
	END
	BEGIN Label Label5
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "Text in database:"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(1)
		MousePointer = 0
		TabIndex     = 12
		Tag          = ""
		Top          = Char(13)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN ListBox Titles_List
		BackColor    = QBColor(7)
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(4)
		Left         = Char(1)
		MousePointer = 0
		Sorted       = 0
		TabIndex     = 9
		TabStop      = -1
		Tag          = ""
		Top          = Char(9)
		Visible      = -1
		Width        = Char(20)
	END
	BEGIN Label Label4
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "Titles in database:"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(1)
		MousePointer = 0
		TabIndex     = 10
		Tag          = ""
		Top          = Char(8)
		Visible      = -1
		Width        = Char(21)
	END
	BEGIN ListBox Database_List
		BackColor    = QBColor(7)
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(6)
		Left         = Char(1)
		MousePointer = 0
		Sorted       = 0
		TabIndex     = 11
		TabStop      = -1
		Tag          = ""
		Top          = Char(2)
		Visible      = -1
		Width        = Char(20)
	END
	BEGIN Label Label1
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "Databases:"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(1)
		MousePointer = 0
		TabIndex     = 1
		Tag          = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(8)
	END
	BEGIN TextBox Text_Edit
		BackColor    = QBColor(15)
		BorderStyle  = 1
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(7)
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = -1
		ScrollBars   = 3
		TabIndex     = 0
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(14)
		Visible      = -1
		Width        = Char(65)
	END
	BEGIN DirListBox Dir_Tree_Combo
		BackColor    = QBColor(7)
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(5)
		Left         = Char(26)
		MousePointer = 0
		TabIndex     = 5
		TabStop      = -1
		Tag          = ""
		Top          = Char(8)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN DriveListBox Drive_Combo
		BackColor    = QBColor(7)
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(25)
		MousePointer = 0
		TabIndex     = 4
		TabStop      = -1
		Tag          = ""
		Top          = Char(6)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN Label Text_File_Label
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "(none)"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(34)
		MousePointer = 0
		TabIndex     = 8
		Tag          = ""
		Top          = Char(4)
		Visible      = -1
		Width        = Char(31)
	END
	BEGIN Label Label3
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "File:"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(25)
		MousePointer = 0
		TabIndex     = 7
		Tag          = ""
		Top          = Char(4)
		Visible      = -1
		Width        = Char(6)
	END
	BEGIN FileListBox Text_File_List
		Archive      = -1
		BackColor    = QBColor(7)
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(6)
		Hidden       = 0
		Left         = Char(47)
		MousePointer = 0
		Normal       = -1
		Pattern      = "*.txt"
		ReadOnly     = -1
		System       = 0
		TabIndex     = 6
		TabStop      = -1
		Tag          = ""
		Top          = Char(6)
		Visible      = -1
		Width        = Char(17)
	END
	BEGIN Menu Menu_File
		Caption      = "&File"
		Checked      = 0
		Enabled      = -1
		Separator    = 0
		Tag          = ""
		Visible      = -1
		BEGIN Menu Logon_Selection
			Caption      = "&Logon"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu Log_Off_Selection
			Caption      = "Log &Off"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu Exit_Selection
			Caption      = "&Exit"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
	END
	BEGIN Menu Options_Menu
		Caption      = "&Options"
		Checked      = 0
		Enabled      = -1
		Separator    = 0
		Tag          = ""
		Visible      = -1
		BEGIN Menu View_Selection
			Caption      = "&View Text"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu Insert_Selection
			Caption      = "&Insert Text"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
		BEGIN Menu Delete_Selection
			Caption      = "&Delete Text"
			Checked      = 0
			Enabled      = -1
			Separator    = 0
			Tag          = ""
			Visible      = -1
		END
	END
	BEGIN Menu About_Menu
		Caption      = "&About"
		Checked      = 0
		Enabled      = -1
		Separator    = 0
		Tag          = ""
		Visible      = -1
	END
END
'$FORM About_Form
'$INCLUDE: 'VBQUERY.BI'
'$INCLUDE: 'VBDSQL.BI'
'$FORM login
DECLARE FUNCTION CheckForTextTable () AS INTEGER
DECLARE SUB ClearTextTitles ()
DECLARE SUB InsertText (Title AS STRING, Text_File AS STRING)
DECLARE SUB LoadText (Title AS STRING)
DECLARE FUNCTION PrepareString (String_In AS STRING) AS STRING
DECLARE SUB RetrieveTextTitles ()
DECLARE SUB ChangePrimaryWindowCaption ()
DECLARE SUB Logoff ()
DECLARE SUB ExitApplication ()
DECLARE SUB InitializeApplication ()

SUB About_Menu_Click ()

	About_Form.SHOW 1

END SUB

FUNCTION CheckForTextTable () AS INTEGER



	REM Check to see if sample table exits
	cmd = "Select count(*) from sysobjects where name = 'text_table'"
	Results = SqlCmd(SqlConn, cmd)
	Results = SqlExec(SqlConn)
	DO WHILE (SqlResults(SqlConn) <> NOMORERESULTS)
	DO WHILE (SqlNextRow(SqlConn) <> NOMOREROWS)
		Table_Found$ = SqlData(SqlConn, 1)
	LOOP
	LOOP
	
	IF VAL(Table_Found$) = 0 THEN
	Results = MSGBOX("Text table not found in " + Database$ + " database." + CHR$(13) + CHR$(10) + "Do you wish to create the table?", 52)
	IF Results = 7 THEN
		CheckForTextTable = FAIL
		EXIT FUNCTION
	ELSE
		REM If sample table does not exist, create it
		cmd = "create table text_table (title varchar(30) not null, text_col text null)"
		Results = SqlCmd(SqlConn, cmd)
		Results = SqlExec(SqlConn)
		DO WHILE (SqlResults(SqlConn) <> NOMORERESULTS)
		DO WHILE (SqlNextRow(SqlConn) <> NOMOREROWS)
		LOOP
		LOOP
		CheckForTextTable = SUCCEED
	END IF
	ELSE
	CheckForTextTable = SUCCEED
	END IF

END FUNCTION

SUB ClearTextTitles ()

	REM Clear all text titles out of list box
	DO WHILE Titles_List.ListCount
		Titles_List.REMOVEITEM 0
	LOOP

END SUB

SUB Database_List_Click ()

REM
REM Get the database user wants to open
REM If it doesn't have the text table in it, see if user wants to create one
REM If it does exist, get all the text titles
REM
   
	DatabaseSelection$ = Database_list.text
	Results = SqlUse(SqlConn, DatabaseSelection$)
	Results = CheckForTextTable()
	IF Results = SUCCEED THEN
	PrimaryWindow.MousePointer = 11
	RetrieveTextTitles
	View_Selection.Enabled = True
	Insert_Selection.Enabled = True
	Delete_Selection.Enabled = True
	PrimaryWindow.MousePointer = 0
	ELSE
	ClearTextTitles
	View_Selection.Enabled = False
	Insert_Selection.Enabled = False
	Delete_Selection.Enabled = False
	END IF

REM
REM Display the current database in the title window
REM clear the text field
REM

	DatabaseName$ = SqlName(SqlConn)
	ChangePrimaryWindowCaption
	Text_Edit.text = ""

END SUB

SUB Delete_Selection_Click ()

	Text_Title$ = Titles_List.text

	IF Text_Title$ = "" THEN
	BEEP
	MSGBOX "You must first select a title."
	ELSE
	Response% = MSGBOX("Delete " + Text_Title$ + "?", 49)
	IF Response% = 1 THEN
		PrimaryWindow.MousePointer = 11
		Results = ExecuteSQLCommand("Delete from text_table where title = '" + Text_Title$ + "'")
		Results = SqlResults(SqlConn)
		DO WHILE (SqlNextRow(SqlConn) <> NOMOREROWS)
		LOOP
		PrimaryWindow.Text_Edit.text = ""
		RetrieveTextTitles
		PrimaryWindow.MousePointer = 0
	ELSE
		MSGBOX "Delete aborted."
	END IF
	END IF

END SUB

SUB Dir_Tree_Combo_Change ()

	Text_File_Label.Caption = "(none)"
	Text_File_List.Path = Dir_Tree_Combo.Path

END SUB

SUB Drive_Combo_Change ()

	Text_File_Label.Caption = "(none)"
	Dir_Tree_Combo.Path = Drive_Combo.Drive

END SUB

SUB Exit_Selection_Click ()

	ExitApplication
	END

END SUB

SUB Form_Load ()

	PrimaryWindowTitle = "Text Example"
	ChangePrimaryWindowCaption

	InitializeApplication
	MSGBOX DBLIB_VERSION$

	Logon_Selection.Enabled = True
	Log_Off_Selection.Enabled = False
	Exit_Selection.Enabled = True
	View_Selection.Enabled = False
	Insert_Selection.Enabled = False
	Delete_Selection.Enabled = False

END SUB

SUB InsertText (Title AS STRING, Text_File AS STRING)
	
REM
REM This routine will insert the text data into the table
REM Insert new row with title and token text value
REM

	Results = ExecuteSQLCommand("Insert into text_table values ('" + Title + "','none')")
	DO WHILE SqlResults(SqlConn) <> NOMORERESULTS
	DO WHILE SqlNextRow(SqlConn) <> NOMOREROWS%
	LOOP
	LOOP

REM Get identifier for text column in current row

	Results = ExecuteSQLCommand("select text_col from text_table where title = '" + Title + "'")
	DO WHILE SqlResults(SqlConn) <> NOMORERESULTS
	DO WHILE SqlNextRow(SqlConn) <> NOMOREROWS%
		SqlPointer& = SqlTxPtr(SqlConn, 1)
		SqlTimestamp& = SqlTxTimestamp(SqlConn, 1)
	LOOP
	LOOP

REM Open text file to load into SQL Server table

	DataPartLimit& = 8192
	Done% = False
	
	OPEN Text_File FOR INPUT AS #1

	FileLen& = LOF(1)
	IF FileLen& > 65536 THEN
	MSGBOX "This application cannot display text files greater than 64K."
	ELSE
	FileData$ = ""
	DO WHILE NOT EOF(1)
		INPUT #1, DataPart$
		IF RIGHT$(DataPart$, 2) <> CHR$(13) + CHR$(10) THEN
		IF RIGHT$(DataPart$, 1) = CHR$(13) THEN
			FileData$ = FileData$ + LEFT$(DataPart$, LEN(DataPart$) - 1) + CHR$(13) + CHR$(10)
		ELSEIF RIGHT$(DataPart$, 1) = CHR$(10) THEN
			FileData$ = FileData$ + LEFT$(DataPart$, LEN(DataPart$) - 1) + CHR$(13) + CHR$(10)
		ELSE
			FileData$ = FileData$ + DataPart$ + CHR$(13) + CHR$(10)
		END IF
		ELSE
		FileData$ = FileData$ + DataPart$
		END IF
	LOOP

REM Begin inserting text into text column in DatePartLimit& size chunks

	Table$ = "text_table.text_col"
	DataPos& = 1
	DataLen& = LEN(FileData$)

	IF SqlWriteText(SqlConn, Table$, SqlPointer&, SQLTXPLEN%, SqlTimestamp&, 1, DataLen&, "") <> FAIL% THEN
		IF SqlOk(SqlConn) <> FAIL% THEN
		Results = SqlResults(SqlConn)
		DO WHILE NOT Done%
			IF DataPos& + DataPartLimit& - 1 < DataLen& THEN
			DataPart$ = MID$(FileData$, DataPos&, DataPartLimit&)
			DataPos& = DataPos& + LEN(DataPart$)
			ELSE
			DataPart$ = MID$(FileData$, DataPos&, DataLen& - DataPos& + 1)
			Done% = True
			END IF
		Results = SqlMoreText%(SqlConn, LEN(DataPart$), DataPart$)
		LOOP
		IF SqlOk(SqlConn) <> FAIL% THEN
			IF SqlResults(SqlConn) <> FAIL% THEN
			MSGBOX "Text inserted."
			END IF
		END IF
		END IF
	END IF
	END IF
CLOSE 1

END SUB

SUB Insert_Selection_Click ()

	Text_File$ = Text_File_Label.Caption
	Title$ = Title_Edit.text
	Title$ = PrepareString(Title$)

	IF Text_File$ = "(none)" THEN
	BEEP
	MSGBOX "Please select a text file to insert."
	ELSEIF Title$ = "" THEN
	BEEP
	MSGBOX "Please enter a title for the text file you wish to insert."
	ELSE
	PrimaryWindow.MousePointer = 11
	InsertText Title$, Text_File$
	Title_Edit.text = ""
	Text_File_List.ListIndex = -1
	Text_File_Label.Caption = ""
	RetrieveTextTitles
	PrimaryWindow.MousePointer = 0
	END IF

END SUB

SUB LoadText (Title AS STRING)
	
REM
REM This routine will read the text field from the table
REM Clear Text_Edit box on primary window
REM

	Text_Edit.text = ""

REM Get length of text in text column

	Results = ExecuteSQLCommand("select datalength(text_col) from text_table where title = '" + Title + "'")
	DO WHILE SqlResults(SqlConn) <> NOMORERESULTS
	DO WHILE SqlNextRow(SqlConn) <> NOMOREROWS
		TextLen& = VAL(SqlData(SqlConn, 1))
	LOOP
	LOOP

	Offset& = 0
	
REM Set size limit on chunks of text data

	LoadSizeLimit& = 8192
	IF LoadSizeLimit& > TextLen& THEN
	LoadSizeLimit& = TextLen&
	END IF
	
	LoadSize& = LoadSizeLimit&

REM Set size of text returned to LoadSizeLimit&

	Results = ExecuteSQLCommand("set textsize " + STR$(LoadSizeLimit&))
	DO WHILE SqlResults(SqlConn) <> NOMORERESULTS
	DO WHILE SqlNextRow(SqlConn) <> NOMOREROWS
	LOOP
	LOOP

REM Begin reading text column in LoadSizeLimit& size chunks

	cmd = "Declare @val varbinary(30)"
	Results = SqlCmd(SqlConn, cmd)
	cmd = "Select @val = textptr(text_col) from text_table where title = '" + Title + "'"
	Results = SqlCmd(SqlConn, cmd)
	Done% = False
	DO WHILE NOT Done%
		cmd = "READTEXT text_table.text_col @val " + STR$(Offset&) + " " + STR$(LoadSize&)
		Results = SqlCmd(SqlConn, cmd)
		IF Offset& + LoadSize& = TextLen& THEN
		Done% = True
		ELSE
		Offset& = Offset& + LoadSizeLimit&
		IF Offset& + LoadSizeLimit& > TextLen& THEN
			LoadSize& = TextLen& - Offset&
		END IF
		END IF
	LOOP

REM Retrieve text data in result rows and place in text_edit box
	
	FileData$ = ""
	IF SqlExec(SqlConn) <> FAIL% THEN
	DO WHILE SqlResults(SqlConn) <> NOMORERESULTS
		DO WHILE SqlNextRow(SqlConn) <> NOMOREROWS
		FileData$ = FileData$ + SqlData(SqlConn, 1)
		LOOP
	LOOP
	END IF

REM Load text data into edit box on primary window
	Text_Edit.text = FileData$

END SUB

SUB Logon_Selection_Click ()

	login.SHOW 1
	PrimaryWindow.MousePointer = 11
	IF CheckServerConnection() = 1 THEN
	Results = GetDatabases(Database_list)
	ChangePrimaryWindowCaption
	Logon_Selection.Enabled = False
	Log_Off_Selection.Enabled = True
	END IF
	PrimaryWindow.MousePointer = 0

END SUB

SUB Log_Off_Selection_Click ()

	Logoff

	Logon_Selection.Enabled = True
	Log_Off_Selection.Enabled = False
	Exit_Selection.Enabled = True
	View_Selection.Enabled = False
	Insert_Selection.Enabled = False
	Delete_Selection.Enabled = False

END SUB

FUNCTION PrepareString (String_In AS STRING) AS STRING

REM
REM This routine will double up the single quotation mark to
REM avoid syntax errors
REM

	String_Out$ = ""

	FOR I% = 1 TO LEN(String_In)
	IF MID$(String_In, I%, 1) = CHR$(39) THEN
		String_Out$ = String_Out$ + CHR$(39) + CHR$(39)
	ELSE
		String_Out$ = String_Out$ + MID$(String_In, I%, 1)
	END IF
	NEXT

	PrepareString = String_Out$

END FUNCTION

SUB RetrieveTextTitles ()

REM
REM This routine will get all the text titles from the table
REM Put them in the list box as they are retrieved.
REM

	ClearTextTitles
	Results = ExecuteSQLCommand("Select title from text_table")
	DO WHILE (SqlResults(SqlConn) <> NOMORERESULTS)
	DO WHILE (SqlNextRow(SqlConn) <> NOMOREROWS)
		Titles_List.ADDITEM SqlData(SqlConn, 1)
	LOOP
	LOOP

END SUB

SUB Text_Edit_KeyPress (KeyAscii AS INTEGER)

	IF KeyAscii <> 0 THEN
	KeyAscii = 0
	END IF

END SUB

SUB Text_File_List_Click ()

	IF RIGHT$(Dir_Tree_Combo.Path, 1) = "\" THEN
	Text_File_Label.Caption = Dir_Tree_Combo.Path + Text_File_List.Filename
	ELSE
	Text_File_Label.Caption = Dir_Tree_Combo.Path + "\" + Text_File_List.Filename
	END IF

END SUB

SUB Titles_List_Click ()

	Text_Edit.text = ""

END SUB

SUB Titles_List_DblClick ()

	Text_Title$ = Titles_List.text
	PrimaryWindow.MousePointer = 11
	LoadText Text_Title$
	PrimaryWindow.MousePointer = 0

END SUB

SUB Title_Edit_KeyPress (KeyAscii AS INTEGER)

	IF LEN(Title_Edit.text) = 30 THEN
	IF KeyAscii <> 8 THEN
		KeyAscii = 0
	END IF
	END IF
	
END SUB

SUB View_Selection_Click ()

	Text_Title$ = Titles_List.text
	IF Text_Title$ = "" THEN
	BEEP
	MSGBOX "You must first select a title."
	ELSE
	PrimaryWindow.MousePointer = 11
	LoadText Text_Title$
	PrimaryWindow.MousePointer = 0
	END IF

END SUB

