//************************************************************************
//
// Module: 	util.h
//
// Purpose:	include declarations of structures, constants and utility
//		functions prototypes for sqlmail
//
//************************************************************************

typedef char DBCHAR;
typedef unsigned long        LHANDLE, FAR *LPLHANDLE;

// Miscellaneous defines
//
#define MAILTEXT	39 	// type 39 from xp_testparm for mail ttext
#define PARAMLEN	255	// parameter length for xp's
#define MAXLEN		255	// Maximum string length
#define MAXCOLNAME	30	// Maximum identifier length

// Stored procs return 0 for success;  failure code is user-defined
#define  XP_NOERROR		0
#define  XP_ERROR		1

#define MAXPARAMS   255

// Extended procedure error codes   (start at anything over 20000)
//
#define  SRV_MAXERROR           20000
#define  XP_PROCLIST_ERROR      SRV_MAXERROR + 1
#define  XP_LOGINMAIL_ERROR	SRV_MAXERROR + 2
#define  XP_LOGOFFMAIL_ERROR	SRV_MAXERROR + 3
#define  XP_SENDMAIL_ERROR	SRV_MAXERROR + 4
#define  XP_PREPMSG_ERROR	SRV_MAXERROR + 5
#define  XP_ADDMSGLINE_ERROR	SRV_MAXERROR + 6
#define  XP_ADDATTACH_ERROR	SRV_MAXERROR + 7
#define  XP_SENDMSG_ERROR	SRV_MAXERROR + 8

#define	XP_SELFLOGIN_ERROR	SRV_MAXERROR + 10
#define	XP_QUERY_ERROR		SRV_MAXERROR + 11
#define	XP_DISCONNECT_ERROR	SRV_MAXERROR + 12

#define COMPUTE_ROW_ERROR	SRV_MAXERROR + 20
#define REMOTE_MSG_ERROR	SRV_MAXERROR + 21

//************************************************************************
//                              STRUCTURES
//************************************************************************

// It is used to pass the mail message from xp function calls to mailUtil 
// functions.  Eventually the message will be saved in the message
// handler
//
typedef struct _mail_msg {
   DBCHAR szTo[PARAMLEN];		// String with mail ids to
   DBCHAR szCC[PARAMLEN];		// String with mail ids to CC
   DBCHAR szSubject[PARAMLEN];		// Subject of mail
   DBCHAR szAttachFile[PARAMLEN];	// file name of attachment
   DBCHAR body[PARAMLEN];		// body of the Mail Message
} MAIL_MSG;


// The message handler, a pointer to the mail message structure.  This
// handler contains the information through which communication is
// maintained between different xp's (hMAPISes, hLib, MAPIMess, bLoggedOn,
// bHeader) and message informtation that those xp's furnishes (MapiMsg)
//
typedef struct h_msg {
    LHANDLE     hMAPISes;	// handler to mapi session
    HMODULE	hLib;		// handler to mapi functions

    BOOL        bLoggedOn;	// whether the user has logged on
    BOOL	bHeader;	// whether the header has been prepared

    MapiMessage	MAPIMsg;	// mapi message

    FLAGS	flFlag;		// flag for MAPI session
	
} H_MSG;



//*************************************************************************
//                             FUNCTION PROTOTYPES
//*************************************************************************

INT MailSend (HWND, H_MSG FAR*, MAIL_MSG*);
INT MailLogon (HWND, char*, H_MSG FAR*);
INT MailLogoff (H_MSG FAR*);
INT MsgPrep (HWND, H_MSG FAR*, MAIL_MSG*);
INT MsgSend (HWND, H_MSG FAR*);
INT MsgAddLine (HWND, H_MSG FAR*, char*);
INT MsgAddAttch (HWND, H_MSG FAR*, char*);

