//
//  Define Macro's External API's
//
SRV_CONFIG FAR *
    SRVAPI srv_getconfig( SRV_SERVER FAR * server );

SRV_SERVER FAR *
    SRVAPI srv_getserver( SRV_PROC   FAR * srvproc );

BOOL
    SRVAPI srv_got_attention( SRV_PROC FAR * srvproc );

void FAR *
    SRVAPI srv_eventdata( SRV_PROC FAR * srvproc);

//
//  Define Macro's
//
#define SRV_GETCONFIG(a)	srv_getconfig	  ( a )
#define SRV_GETSERVER(a)	srv_getserver	  ( a )
#define SRV_GOT_ATTENTION(a)	srv_got_attention ( a )
#define	SRV_EVENTDATA(a)	srv_eventdata	  ( a )
#define	SRV_IODEAD(a)		srv_iodead	  ( a )
#define	SRV_TDSVERSION(a)	srv_tdsversion	  ( a )

//
//  Define Other External API's
//
void FAR *
    SRVAPI srv_alloc( DBINT size );

int
    SRVAPI srv_bmove( void  FAR * from,
		      void  FAR * to,
		      DBINT	  count );

int
    SRVAPI srv_bzero( void  FAR * location,
		      DBINT	  count );

int
    SRVAPI srv_config( SRV_CONFIG FAR * config,
		       DBINT		option,
		       DBCHAR	  FAR * value,
		       int		valuelen );

SRV_CONFIG FAR *
    SRVAPI srv_config_alloc( void );

int
    SRVAPI srv_convert( SRV_PROC FAR * srvproc,
			int	       srctype,
			void	 FAR * src,
			DBINT	       srclen,
			int	       desttype,
			void	 FAR * dest,
			DBINT	       destlen );

int
    SRVAPI srv_describe( SRV_PROC FAR * srvproc,
			 int		colnumber,
			 DBCHAR FAR *	columnname,
			 int		namelen,
			 DBINT		desttype,
			 DBINT		destlen,
			 DBINT		srctype,
			 DBINT		srclen,
			 void	FAR *	srcdata );

void
    SRVAPI srv_disable_attentions( SRV_PROC FAR * srvproc );

void
    SRVAPI srv_enable_attentions( SRV_PROC FAR * srvproc );

int
    (FAR * SRVAPI srv_errhandle( int (FAR * CDECL handler )
				 ( SRV_SERVER FAR * server,
				   SRV_PROC FAR *   srvproc,
				   int		    srverror,
				   BYTE 	    severity,
				   BYTE 	    state,
				   int		    oserrnum,
				   DBCHAR FAR *     errtext,
				   int		    errtextlen,
				   DBCHAR FAR *     oserrtext,
				   int		    oserrtextlen) ))
				 ( SRV_SERVER FAR * server,
				   SRV_PROC FAR *   srvproc,
				   int		    srverror,
				   BYTE 	    severity,
				   BYTE 	    state,
				   int		    oserrnum,
				   DBCHAR FAR *     errtext,
				   int		    errtextlen,
				   DBCHAR FAR *     oserrtext,
				   int		    oserrtextlen );

int
    SRVAPI srv_event( SRV_PROC FAR * srvproc,
		      int	     event,
		      BYTE     FAR * data );

int
    SRVAPI srv_free( void FAR * ptr );

void FAR *
    SRVAPI srv_getuserdata( SRV_PROC FAR * srvproc );

int
    (FAR * SRVAPI srv_handle( SRV_SERVER FAR * server,
			      DBINT	       event,
			      int (FAR * CDECL handler)(void FAR *) ))
			      (void FAR *);

SRV_SERVER FAR *
    SRVAPI srv_init( SRV_CONFIG FAR * config,
		     DBCHAR	FAR * connectname,
		     int	      namelen );

BOOL
    SRVAPI srv_iodead( SRV_PROC FAR * srvproc );

long
    SRVAPI srv_langcpy( SRV_PROC FAR *	srvproc,
			long		start,
			long		nbytes,
			DBCHAR	 FAR *	buffer );

long
    SRVAPI srv_langlen( SRV_PROC FAR * srvproc );

void FAR *
    SRVAPI srv_langptr( SRV_PROC FAR *srvproc );

int
    SRVAPI srv_log( SRV_SERVER FAR * server,
		    BOOL	     datestamp,
		    DBCHAR     FAR * msg,
		    int 	     msglen );

void FAR *
    SRVAPI srv_paramdata( SRV_PROC FAR * srvproc,
			  int		 n );

int
    SRVAPI srv_paramlen( SRV_PROC FAR * srvproc,
			 int		n );

int
    SRVAPI srv_parammaxlen( SRV_PROC FAR * srvproc,
			    int 	   n );

DBCHAR FAR *
    SRVAPI srv_paramname( SRV_PROC FAR * srvproc,
			  int		 n,
			  int	   FAR * len );

int
    SRVAPI srv_paramnumber( SRV_PROC FAR * srvproc,
			    DBCHAR   FAR * name,
			    int 	   len );

int
    SRVAPI srv_paramset( SRV_PROC FAR * srvproc,
			 int		n,
			 void	  FAR * data,
			 int		len );

int
    SRVAPI srv_paramstatus( SRV_PROC FAR * srvproc,
			    int 	   n );

int
    SRVAPI srv_paramtype( SRV_PROC FAR * srvproc,
			  int		 n );


DBCHAR FAR *
    SRVAPI srv_pfield( SRV_PROC FAR * srvproc,
		       int	      field,
		       int	FAR * len );

int
    SRVAPI srv_returnval( SRV_PROC FAR * srvproc,
			  DBCHAR   FAR * valuename,
			  int		 len,
			  BYTE		 status,
			  DBINT 	 type,
			  DBINT 	 maxlen,
			  DBINT 	 datalen,
			  void	   FAR * value );

DBCHAR FAR *
    SRVAPI srv_rpcdb( SRV_PROC FAR * srvproc,
		      int      FAR * len );

DBCHAR FAR *
    SRVAPI srv_rpcname( SRV_PROC FAR * srvproc,
			int	 FAR * len );

int
    SRVAPI srv_rpcnumber( SRV_PROC FAR * srvproc );

DBUSMALLINT
    SRVAPI srv_rpcoptions( SRV_PROC FAR * srvproc );

DBCHAR FAR *
    SRVAPI srv_rpcowner( SRV_PROC FAR * srvproc,
			 int	  FAR * len );

int
    SRVAPI srv_rpcparams( SRV_PROC FAR * srvproc );

int
    SRVAPI srv_run( SRV_SERVER FAR * server );

int
    SRVAPI srv_senddone( SRV_PROC FAR * srvproc,
			 DBUSMALLINT	status,
			 DBUSMALLINT	info,
			 DBINT		count);

int
    SRVAPI srv_sendmsg( SRV_PROC FAR * srvproc,
			int	       msgtype,
			DBINT	       msgnum,
			DBTINYINT      msgclass,
			DBTINYINT      state,
			DBCHAR	 FAR * rpcname,
			int	       rpcnamelen,
			DBUSMALLINT    linenum,
			DBCHAR	 FAR * message,
			int	       msglen );

int
    SRVAPI srv_sendrow( SRV_PROC FAR * srvproc );

int
    SRVAPI srv_sendstatus( SRV_PROC FAR * srvproc,
			   DBINT	  status );

int
    SRVAPI srv_setcoldata( SRV_PROC FAR * srvproc,
			   int		  column,
			   void     FAR * data);

int
    SRVAPI srv_setcollen( SRV_PROC FAR * srvproc,
			  int		 column,
			  int	 len );
//			  DBUSMALLINT	 len );

int
    SRVAPI srv_setuserdata( SRV_PROC FAR * srvproc,
			    void FAR *	   ptr );

int
    SRVAPI srv_setutype( SRV_PROC FAR * srvproc,
			 int		column,
			 DBINT		usertype );

DBCHAR FAR *
    SRVAPI srv_sfield( SRV_SERVER FAR * server,
		       int		field,
		       int	  FAR * len );
DBCHAR FAR *
    SRVAPI srv_symbol( int	 type,
		       int	 symbol,
		       int FAR * len );

int
    SRVAPI srv_tdsversion( SRV_PROC FAR * srvproc );

BOOL
    SRVAPI srv_willconvert( int srctype,
			    int desttype );
int 
    SRVAPI srv_writebuf( SRV_PROC FAR * srvproc,
             void FAR * ptr,
             WORD count );

int
    SRVAPI srv_get_text( SRV_PROC * srvproc,
			 long * outlen);

void
    SRVAPI srv_ackattention( SRV_PROC * srvproc);

int
    SRVAPI srv_terminatethread( SRV_PROC * srvproc);

int
    SRVAPI srv_sendstatistics( SRV_PROC * srvproc);

int
    SRVAPI srv_clearstatistics( SRV_PROC * srvproc);

int
    SRVAPI srv_setevent( SRV_SERVER * server, int event);

int 
	SRVAPI srv_message_handler(SRV_PROC * srvproc, int errornum, BYTE severity,
		BYTE state, int oserrnum, char *errtext, int errtextlen, 
		char *oserrtext, int oserrtextlen);

int
    SRVAPI srv_ansi_sendmsg( SRV_PROC FAR * srvproc,
			int	       msgtype,
			DBINT	       msgnum,
			DBTINYINT      msgclass,
			DBTINYINT      state,
			DBCHAR	 FAR * rpcname,
			int	       rpcnamelen,
			DBUSMALLINT    linenum,
			DBCHAR	 FAR * message,
			int	       msglen );

void FAR *
    SRVAPI srv_ansi_paramdata( SRV_PROC FAR * srvproc,
			  int		 n );

int
    SRVAPI srv_ansi_describe( SRV_PROC FAR * srvproc,
			 int		colnumber,
			 DBCHAR FAR *	columnname,
			 int		namelen,
			 DBINT		desttype,
			 DBINT		destlen,
			 DBINT		srctype,
			 DBINT		srclen,
			 void	FAR *	srcdata );

int
    SRVAPI srv_ansi_sendrow( SRV_PROC FAR * srvproc );
