// This program is an example of an Open Data Services application. It accepts
// requests from clients to execute stored procedures either as language
// events or as remote stored procedure calls.

#include    <stdlib.h>
#include    <stdio.h>
#include    <string.h>
#include    <srv.h>

// Globals
//
DBCHAR *RegistryName = "PROCSRV";   // Default registry name

// function prototypes
//
void main(int argc, char **argv);

void getargs(int argc, char **argv);

int SRVAPI init_server(SRV_SERVER *server);

void SRVAPI set_remote_server_name(char *name);

int chk_err(SRV_SERVER *server, SRV_PROC *srvproc, int srverror,
            BYTE severity, BYTE state, int oserrnum, DBCHAR *errtext,
            int errtextlen, DBCHAR *oserrtext, int oserrtextlen);

void main(argc, argv)
int argc;
char *argv[];
{
    SRV_CONFIG *config; // The configuration structure
    SRV_SERVER *server; // The service process
    char logfile[12];       // logfile
					
    // Read any command line arguments.
    //
    getargs(argc, argv);

    // Send the name retrieved to the procedure server's DLL module
    //
    set_remote_server_name(RegistryName);

    // Allocate a configuration structure that is used to initialize
    // the Open Data Services application
    //
    config = srv_config_alloc();

    // Allow 20 connections at a time.
    //
    srv_config(config, (DBINT)SRV_CONNECTIONS, "20", SRV_NULLTERM);

    // Set the log file.
    //
    sprintf(logfile, "%s.log", RegistryName);
    srv_config(config, (DBINT)SRV_LOGFILE, logfile, SRV_NULLTERM);

    // Install the error handler.
    //
    srv_errhandle(chk_err);

    // Initialize the procedure server and save the server handle
    // so it can be used in later functions.
    //
    server = srv_init(config, RegistryName, SRV_NULLTERM);
    if (server == NULL) {
        printf("Unable to initialize Procedure Server.\n");
        ExitThread(1);
    }

    // When starting the procedure server, initialize the remote server structure.
    // This is done in the init_server() function.
    // All the other event handlers are also defined in the init_server()
    // function.
    //
    srv_handle(server, (DBINT)SRV_START, init_server);

    // Now everything's ready to go with our procedure server, so we
    // start it and keep it going until we get a stop request.
    //
    srv_log(server, FALSE, " ", SRV_NULLTERM);  // insert blank line
    srv_log(server, TRUE, "Procedure Server Starting", SRV_NULLTERM);

    printf("\nProcedure Server Starting\n");

    srv_run(server);

}

// GETARGS
//    Read the command line arguments.
//
// Parameters:
//     argc - int (from "main" entry)
//     argv - pointer to array of char pointers (from "main" entry)
//
// Returns:
//     VOID
//
void getargs(int argc, char *argv[])
{

    int i;
    char *ptr;

    for (i = 1; i < argc; ++i) {
        if (argv[i][0] != '-' && argv[i][0] != '/') {
            printf("Usage: procsrv [-R<registry key name>]\n");
            ExitProcess(1);
        }
        ptr = argv[i];
        switch (ptr[1]) {
        case 'R':
            if (strlen(ptr + 2) > 0) {
                RegistryName = ptr + 2;
            }
            break;
        default:
            printf("Usage: procsrv [-R<registry key name>]\n");
            ExitProcess(1);
        }
    }
}
