#********************************************************************#
#**            Microsoft Open Data Services - LIBRARY              **#
#**        Copyright(c) Microsoft Corp., 1987, 1988, 1989,         **#
#**                     1990, 1991, 1992, 1993                     **#
#**                                                                **#
#********************************************************************#

.SUFFIXES:
.SUFFIXES:   .src .dll .def .lnk .map .lib .c

# Text for building copyright message in executable
#
COPYRIGHT = Copyright(c) Microsoft Corp., 1987,1988,1989,1990,1991,1992,1993
PRODUCT = PROCSRV

# Tools
CC = cl386
LINK = link32 

# Source base
#

SRCDIR = ..\SRC
OBJDIR = .\OBJ

ODSLIBS = opendsnt.lib
LRF = procsrv.lnk
NTLIBS	= kernel32.lib libcmt.lib

CFLAGS = -c -G3s -W3 -D_X86_=1 -DDBNTWIN32 -Ot
LFLAGS = -MACHINE:i386 -subsystem:console -entry:mainCRTStartup

!if  "$(DEBUG_TYPE)" == "debug"
CFLAGS_DEBUG = -Od -Z7
LFLAGS_DEBUG = -debug:full -debugtype:cv
!endif



# Object file for main routine
#
OBJS = $(OBJDIR)\PROCSRV.obj $(OBJDIR)\PROCCBS.obj

# Build the executable, forces full build under nmake.
# This is the main dependency.
#
all : procsrv $(LRF)

# compile/assemble command lines for each source directory.
#
{$(SRCDIR)}.c{$(OBJDIR)}.obj:
   $(CC) $(CFLAGS) $(CFLAGS_DEBUG) -Fo$(OBJDIR)\$(@B).obj $(SRCDIR)\$(@B).c

$(LRF) : makefile
	@echo Building $(LRF)
	@echo This line makes sure $@ file exists	 > $(LRF)
	@del $(LRF)
	@for %%i in ( $(OBJDIR)\*.obj ) do echo	   %%i >> $(LRF)
#@echo.						>> $(LRF)

# Build the component object files
#
src : $(OBJS) $(LRF)

# Build the executable
#
procsrv: src
   $(LINK) $(LFLAGS) $(LFLAGS_DEBUG) -out:$(@B).exe @$(LRF) \
   $(ODSLIBS) $(NTLIBS)
