(*******************************************************************)
(*  Avatar level 1 Console driver.  Unit for providing a program   *)
(*  with proper Avatar levels 0, 0+, and 1 emulations.             *)
(*  Copyright (c) 1991 - 93 Gregory P. Smith                       *)
(*  All Rights Reserved                                            *)
(*-----------------------------------------------------------------*)
(*  Last Update:   April  7, 1993      v 1.50                      *)
(*=========================================*************************)
(* Compiler defines and version checks for *)
(* PAvatar units                           *)
(*******************************************)
{$IFDEF VER50}
Sorry, This Unit Requires Turbo Pascal 5.5 Or Greater.  {$ENDIF}
{$IFDEF VER40} ... See Previous line ... {$ENDIF}

{ DEFINE P_DEBUG}       { Used only for debugging the unit. }

{$IFNDEF VER55}
  {$X+,G-}              { TP 5.5 has no extended syntax }
{$ENDIF}
{$IFDEF DPMI}
  {$G+}                 { DPMI only runs on 286+, no overlays }
  {$UNDEF OVERLAY}      { DPMI programs don't need overlays   }
{$ENDIF}
{$S-,R-,V-,A+}
{$IFDEF P_DEBUG}        { Used for debugging the PAvatar units }
{$S+,R+,V+,D+,L+,A+}
{$ENDIF}

{ If defined, the TTY procedures call the TTYCharH hook to act on any char
  before they do anything with it.  If the hook returns false, the character
  will not be processed by PAvatar. }

{$DEFINE TTY_HOOK}                                         {+1.19}

{ If defined, the main PAvatar unit can be overlayed. }

{$DEFINE OVERLAY}                                          {+1.19}

{ If defined, support for the VT-52 terminal emulation will be compiled }

{$DEFINE VT52}                                             {+1.50}

{ You can guess what this will be for.  VT-102 support is under development
  but will NOT work correctly in its current state. }

{ DEFINE VT102}

{ Thanks goes to Bo Bendtsen for this addition!  When defined, ANSI music
  will be supported via the ANSI_MUSIC boolean variable. }

{$DEFINE ANSI_MUSIC}                                       {+1.50}

{ Tom Thayer noted this bug;  With this enabled, PAvatar handles the ANSI
  reverse attribute (Esc[7m) sequence in the same manner as Dos by setting
  the attribute to black on white (eq: Esc[30;40m).  Otherwise the attribute
  is actually reversed, as a VT200 terminal would habdle it. }

{$DEFINE DOS_ANSI_REV}                                     {+1.50}

{****-------------- Do not make changes below this line --------------****}

{$IFDEF VT102}
  {$DEFINE VT52  -- VT52 is a partial subset of VT102 }
{$ENDIF}
