(*******************************************************************)
(*  Avatar level 1 Console driver.  Unit for providing a program   *)
(*  with proper Avatar levels 0, 0+, and 1 emulations.             *)
(*  Copyright (c) 1991 - 93 Gregory P. Smith                       *)
(*  All Rights Reserved                                            *)
(*-----------------------------------------------------------------*)
(*  Last Update:   April  4, 1993     v 1.50                       *)
(*====================================******************************)
(* PAvatar Hook I/O interface         *)
(**************************************)

Unit PAvtIO;
{$I PAVTVER.INC -- Checks compiler version and defines }
{$F-,O-  This unit shouldn't be overlayed }

INTERFACE

Uses Dos, Crt;

{-- public type declarations ---------------------------------------}
type
  AvatarInterpProc = Procedure (ch:char);     { interpreter procedure type }
  ReplyProc = Procedure (S:String);                           { Query Hook }
  WriteATHookT = Procedure (x,y,a:byte;ch:char);   { for writing to screen }
  GotoXYHookT = Procedure (x,y:byte);                  { for moving cursor }
  ScrollHookT = Procedure (dir,x1,y1,x2,y2,n,a:byte);          { Scrolling }
              { dir: 1=up,2=down,3=left,4=right. n=# 2 scroll,a=new attrib }
  FillHookT = Procedure (x1,y1,x2,y2,a:byte;ch:char);    { filling an area }
  GetCharHookT = Procedure (x,y:byte;var a:byte;var c:char); { screen data }
  HighHookT = Procedure (x1,y1,x2,y2,a:byte);   { for highlighting an area }
  PauseHookT = Procedure (tenths:word);         { 10ths of second to pause }
  CursorHookT = Procedure (style:byte);             { set the cursor style }
{$IFDEF TTY_HOOK}
  TTYChHookT = Function (ch:char): boolean;       { called from TTY procs. }
{$ENDIF}
  TerminalType = (TermTTY,    { TTY: no terminal emulation }
                  TermANSI,   { ANSI: extended ANSI terminal }
                  TermAVT0,   { AVT/0+: extended level 0+ emulation }
                  TermAVT1,   { AVT/1: full level 1 emulation }
    {$IFDEF VT52} TermVT52    { VT-52: Standard VT-52 emulation } {$ENDIF}
                 );

{-- public constants ----------------------------------------------}
const
{-- runtime -------------}
  CurrentTerm : TerminalType = TermAVT1; { Current Terminal }
  ScrnLines   : byte = 25;       { lines on a terminal screen }
  ScrnColumns : byte = 80;       { columns on a terminal screen }
  Sound_Stat  : byte = 03;       { Sound: bit0=bell,bit1=Sound }
{$IFDEF VT52}
  VT52On      : boolean = False; { Include VT52 support }
{$ENDIF}
  IgnoreNULL  : boolean = False; { TTY ignore the #0 character? (VT52) }
  ANSI_BBS    : boolean = True;  { Use BBS Style ANSI? }
  ANSI_MUSIC  : boolean = True;  { Allow "ANSI" music? }
  Dest_BS     : boolean = True;  { Destructive backspace? (AVT/1 default) }
  Fallback    : boolean = False; { ANSI fallback enabled }

  In_DV       : boolean = False; { Are we in DESQview? }
{$IFDEF VT102}
  CRtoCRLF    : boolean = False; { CR/LF sent when CR is pressed? }
{$ENDIF}
  QueryReply : string[80] =      { AVT/1 ^V^Q^Q response }
               'AVT1, PAvatar 1.50 Copr. 1991-93 Gregory P. Smith'+^M;
{-- compiletime ---------}
  Esc = ^[;
  DLE = ^P;
  FS = #28;
  GS = #29;
  RS = #30;
  US = #31;
  SP = #32;  { space }
  None = 0;          {  \               }
  ZigZag = 1;        {   > Wrap Types   }  { for ORing with WCFLf }
  ClockWise = 2;     {  /               }
  NoWrap = 3;        { /                }
  NormCursor = 4;    { \                }
  BigCursor = 8;     {  > Cursor Styles }
  HiddenCursor = 12; { /                }
{$IFNDEF DPMI}
  Seg0040 = $0040;   { BIOS data segment }
{$ENDIF}

{-- public variables ----------------------------------------------}
var
  AVTInterp   : AvatarInterpProc; { Next interpretation stage       }
  Query_Hook  : ReplyProc;    { processes Query Replys              }
  WriteATh    : WriteATHookT; { \                                   }
  GotoXYh     : GotoXYHookT;  {  \                                  }
  Scrollh     : ScrollHookT;  {   > Hooks for screen manipulation   }
  FillAreah   : FillHookT;    {  /                                  }
  GetATh      : GetCharHookT; { /                                   }
  HighAreah   : HighHookT;    {/                                    }
  Pauseh      : PauseHookT;   { for system pause calls              }
  Cursorh     : CursorHookT;  { for setting the cursor style        }
  FlushInputh : Procedure;    { flush keyboard and local buffers    }
{$IFDEF TTY_HOOK}
  TTYCharH    : TTYChHookT;   { called before AvtTTY                }
{$ENDIF}
  Def_Cursor  : word;         { contains default cursor shape       }

{-- public procedures ---------------------------------------------}

PROCEDURE DESQview_Init;               { initialize the In_DV flag }
FUNCTION  DESQview_Version: word; { return DESQview version number }
PROCEDURE IdlePause;              { give up Multitasker time slice }
FUNCTION  ReadKey: char;      { DESQview aware ReadKey replacement }
PROCEDURE DV_Sound(freq,dur:word);   { Create sound under DESQview }
PROCEDURE DelayTicks(t:word);            { Delay for t timer ticks }

IMPLEMENTATION

{-- Null Hook Definitions -----------------------------------------}

{$F+ compatible with TP 5.5 }
Procedure NullReply(s:string); begin end;
Procedure NullWriteAT(x,y,a:byte;c:char); begin end;
Procedure NullGotoXY(x,y:byte); begin end;
Procedure NullScroll(d,x,y,x1,y1,n,a:byte); begin end;
Procedure NullFill(x,y,x1,y1,a:byte;c:char); begin end;
Procedure NullGetChar(x,y:byte;var a:byte;var c:char); begin end;
Procedure NullHigh(x,y,x1,y1,a:byte); begin end;
Procedure NullPause(t:word); begin end;
Procedure NullCursor(s:byte); begin end;

Procedure StdFlush;
begin
  MemW[Seg0040:$001A] := MemW[Seg0040:$001C]   { Zero KB buffer }
end;

{$IFDEF TTY_HOOK}
Function NullTTY(ch:char): boolean;
begin
  NullTTY := True;
end;
{$ENDIF}
{$F-}

Procedure Nullify_Hooks;
begin
  Query_Hook  := NullReply;
  WriteATh    := NullWriteAT;
  GotoXYh     := NullGotoXY;
  Scrollh     := NullScroll;
  FillAreah   := NullFill;
  GetATh      := NullGetChar;
  HighAreah   := NullHigh;
  Pauseh      := NullPause;
  Cursorh     := NullCursor;
  FlushInputh := StdFlush;
{$IFDEF TTY_HOOK}
  TTYCharH    := NullTTY;
{$ENDIF}
{$IFDEF VER55}
  Inline($B4/$03/$cd/$10/$89/$0e/def_cursor);   { get default cursor shape }
{$ELSE}
  asm
   mov ah,03
   int 10h
   mov def_cursor,cx
  end;
{$ENDIF}
end;

{$I PAVTDESQ.INC -- DESQview awareness module }

{ Similar to the Crt unit's Delay procedure but will delay for approximately
  t timer ticks (approx 55ms). }
Procedure DelayTicks(t:word);
const		       { clock rate is 1,193,180/65536 times a second }
  dticks = 1573040;    { number of ticks every 24 hours }
var
  systimerp : ^longint;
  elapsed,
  start : longint;
begin
  systimerp := Ptr(Seg0040, $006C);
  start := systimerp^;
  elapsed := 0;
  repeat
    if systimerp^ < start then
     elapsed := dticks - (start - systimerp^)  { 24hr wrap around }
    else elapsed := systimerp^ - start;
    IdlePause;  { give up timeslice during a delay }
  until elapsed >= t;
end;

{-- Initialization Code ------------------------------------------}

BEGIN
  Nullify_Hooks;
END.
