(*******************************************************************)
(*  Avatar level 1 Console driver.  Unit for providing a program   *)
(*  with proper Avatar levels 0, 0+, and 1 emulations.             *)
(*  Copyright (c) 1991 - 93 Gregory P. Smith                       *)
(*  All Rights Reserved                                            *)
(*-----------------------------------------------------------------*)
(*  Last Update:  March 10, 1993                                   *)
(*========================================================**********)
(* Include file for PAvatar to add DESQview API functions *)
(**********************************************************)

function DESQview_Version: word; {$IFNDEF VER55} assembler; {$ENDIF}
{$IFDEF VER55}
var
  regs : Registers;
begin
  with regs do begin
    CX := $4445;
    DX := $5351;
    AX := $2b01;
    MsDos(regs);
    if AL = $ff then DESQview_version := 0 { not in DV }
    else begin
      DESQview_version := BX;
      In_DV := True;
    end;
  end;
end;  { 5.5 DESQview_Version }
{$ELSE}  { TP 6.0 or later supports BASM }
asm
  MOV    CX,'DE'          { CX+DX to 'DESQ' (invalid date) }
  MOV    DX,'SQ'
  MOV    AX,2B01h         { Dos' set date funct. }
  INT    21H              { call dos }
  CMP    AL,0FFh          { Was it invalid? }
  JE     @No_dv           { yep, no dv }
  MOV    AX,BX            { AH=major AL=minor }
  MOV    In_DV,01h        { In_DV is true }
  JMP    @DvGv_x          { other routines }
@No_dv:
  XOR    AX,AX              { Return 0 for no DV }
@DvGv_x:
end;  { 6.0+ DESQview_version }
{$ENDIF}

procedure DV_Sound(freq,dur:word); {$IFNDEF VER55} assembler; {$ENDIF}
{$IFDEF VER55}
begin
  InLine($b8/$19/$10/$8b/$9e/freq/$8b/$8e/dur/$cd/$15);
end;
{$ELSE}
asm
  MOV   AX,1019H
  MOV   BX,freq   { frequency above 20 Hz }
  MOV   CX,dur    { duration in clock ticks }
  INT   15H
end;
{$ENDIF}

Procedure DESQview_Init;
{$IFDEF VER55}
var
  tmp : word;
{$ENDIF}
begin
  {$IFDEF VER55} tmp := {$ENDIF}DESQview_Version; { init In_DV flag }
end;

Procedure IdlePause;  { give up multitasker time slice }
begin
 if In_DV then Inline($B8/$00/$10/$cd/$15) { MOV AX, 1000h; INT 15h }
   else Inline($CD/$28); { INT 28h; DOS Idle call, gives up time. }
end;

{ A replacement ReadKey procedure which issues a DESQview
  Pause call if no input is ready.  Works identical to the
  ReadKey function in the Crt unit.  }

function ReadKey : char;
begin
  while not KeyPressed do IdlePause; { give up until key ready! }
  ReadKey := Crt.ReadKey; { now get the char }
end;

