.model small
.stack 100h
.186
.data
font            dw      0
font_file       db      'pathscr.fnt'
                db      7 dup (0)
handle          dw      0
bitplane        db      0
bitplanes       dw      4 dup (0)
x               dw      0
y               dw      0

bounce_data     dw 22950,22950,22950,22950,22950,22950,22860,22860
dw 22770,22680,22680,22590,22500,22410,22320,22230
dw 22140,22050,21870,21780,21600,21510,21330,21240
dw 21060,20880,20700,20520,20340,20160,19980,19800
dw 19620,19440,19170,18990,18810,18540,18360,18090
dw 17910,17640,17370,17190,16920,16650,16380,16110
dw 15840,15660,15390,15120,14850,14580,14310,14040
dw 13680,13410,13140,12870,12600,12330,12060,11790
dw 11430,11160,10890,10620,10350,10080, 9810, 9540
dw  9270, 8910, 8640, 8370, 8100, 7830, 7560, 7290
dw  7110, 6840, 6570, 6300, 6030, 5760, 5580, 5310
dw  5040, 4860, 4590, 4410, 4140, 3960, 3780, 3510
dw  3330, 3150, 2970, 2790, 2610, 2430, 2250, 2070
dw  1890, 1710, 1620, 1440, 1350, 1170, 1080,  900
dw   810,  720,  630,  540,  450,  360,  270,  270
dw   180,   90,   90,    0,    0,    0,    0,    0
dw     0,    0,    0,    0,    0,    0,   90,   90
dw   180,  270,  270,  360,  450,  540,  630,  720
dw   810,  900, 1080, 1170, 1350, 1440, 1620, 1710
dw  1890, 2070, 2250, 2430, 2610, 2790, 2970, 3150
dw  3330, 3510, 3780, 3960, 4140, 4410, 4590, 4860
dw  5040, 5310, 5580, 5760, 6030, 6300, 6570, 6840
dw  7110, 7290, 7560, 7830, 8100, 8370, 8640, 8910
dw  9270, 9540, 9810,10080,10350,10620,10890,11160
dw 11520,11790,12060,12330,12600,12870,13140,13410
dw 13680,14040,14310,14580,14850,15120,15390,15660
dw 15840,16110,16380,16650,16920,17190,17370,17640
dw 17910,18090,18360,18540,18810,18990,19170,19440
dw 19620,19800,19980,20160,20340,20520,20700,20880
dw 21060,21240,21330,21510,21600,21780,21870,22050
dw 22140,22230,22320,22410,22500,22590,22680,22680
dw 22770,22860,22860,22950,22950,22950,22950,22950

bounce_index    db      8 dup (0)

bounce_bar      db      0                       ; Current bar

bounce_colours  db      16,17,18,19,20,21,22,23
                db      24,25,26,27,28,29,30,31
                db      31,30,29,28,27,26,25,24
                db      23,22,21,20,19,18,17,16
                db      16,17,18,19,20,21,22,23
                db      24,25,26,27,28,29,30,31
                db      31,30,29,28,27,26,25,24
                db      23,22,21,20,19,18,17,16
                db      16,17,18,19,20,21,22,23
                db      24,25,26,27,28,29,30,31
                db      31,30,29,28,27,26,25,24
                db      23,22,21,20,19,18,17,16
                db      16,17,18,19,20,21,22,23
                db      24,25,26,27,28,29,30,31
                db      31,30,29,28,27,26,25,24
                db      23,22,21,20,19,18,17,16
                db      16,17,18,19,20,21,22,23
                db      24,25,26,27,28,29,30,31
                db      31,30,29,28,27,26,25,24
                db      23,22,21,20,19,18,17,16
                db      16,17,18,19,20,21,22,23
                db      24,25,26,27,28,29,30,31
                db      31,30,29,28,27,26,25,24
                db      23,22,21,20,19,18,17,16
                db      16,17,18,19,20,21,22,23
                db      24,25,26,27,28,29,30,31
                db      31,30,29,28,27,26,25,24
                db      23,22,21,20,19,18,17,16
                db      16,17,18,19,20,21,22,23
                db      24,25,26,27,28,29,30,31
                db      31,30,29,28,27,26,25,24
                db      23,22,21,20,19,18,17,16

scroll_data     dw     0,24750,  256,24930,  512,25110,  768,25200
dw     1,25380,  257,25560,  513,25650,  769,25830
dw     2,26010,  258,26100,  514,26280,  770,26460
dw     3,26550,  259,26730,  515,26820,  771,27000
dw     4,27180,  260,27270,  516,27450,  772,27540
dw     5,27720,  261,27810,  517,27990,  773,28080
dw     6,28170,  262,28350,  518,28440,  774,28620
dw     7,28710,  263,28890,  519,28980,  775,29070
dw     8,29250,  264,29340,  520,29430,  776,29610
dw     9,29700,  265,29790,  521,29970,  777,30060
dw    10,30150,  266,30240,  522,30330,  778,30510
dw    11,30600,  267,30690,  523,30780,  779,30870
dw    12,31050,  268,31140,  524,31230,  780,31320
dw    13,31410,  269,31500,  525,31590,  781,31680
dw    14,31770,  270,31860,  526,31950,  782,32040
dw    15,32130,  271,32220,  527,32310,  783,32400
dw    16,32490,  272,32580,  528,32670,  784,32760
dw    17,32850,  273,32940,  529,33030,  785,33120
dw    18,33210,  274,33210,  530,33300,  786,33390
dw    19,33480,  275,33570,  531,33570,  787,33660
dw    20,33750,  276,33840,  532,33930,  788,33930
dw    21,34020,  277,34110,  533,34110,  789,34200
dw    22,34290,  278,34290,  534,34380,  790,34470
dw    23,34470,  279,34560,  535,34560,  791,34650
dw    24,34650,  280,34740,  536,34830,  792,34830
dw    25,34920,  281,34920,  537,35010,  793,35010
dw    26,35100,  282,35100,  538,35100,  794,35190
dw    27,35190,  283,35280,  539,35280,  795,35280
dw    28,35370,  284,35370,  540,35370,  796,35460
dw    29,35460,  285,35460,  541,35550,  797,35550
dw    30,35550,  286,35640,  542,35640,  798,35640
dw    31,35640,  287,35640,  543,35730,  799,35730
dw    32,35730,  288,35730,  544,35730,  800,35730
dw    33,35730,  289,35820,  545,35820,  801,35820
dw    34,35820,  290,35820,  546,35820,  802,35820
dw    35,35820,  291,35820,  547,35820,  803,35820
dw    36,35820,  292,35820,  548,35820,  804,35820
dw    37,35730,  293,35730,  549,35730,  805,35730
dw    38,35730,  294,35730,  550,35640,  806,35640
dw    39,35640,  295,35640,  551,35640,  807,35640
dw    40,35550,  296,35550,  552,35550,  808,35550
dw    41,35550,  297,35550,  553,35460,  809,35460
dw    42,35460,  298,35460,  554,35460,  810,35460
dw    43,35370,  299,35370,  555,35370,  811,35370
dw    44,35370,  300,35370,  556,35280,  812,35280
dw    45,35280,  301,35280,  557,35280,  813,35190
dw    46,35190,  302,35190,  558,35190,  814,35190
dw    47,35190,  303,35100,  559,35100,  815,35100
dw    48,35100,  304,35100,  560,35010,  816,35010
dw    49,35010,  305,35010,  561,35010,  817,34920
dw    50,34920,  306,34920,  562,34920,  818,34920
dw    51,34830,  307,34830,  563,34830,  819,34830
dw    52,34830,  308,34740,  564,34740,  820,34740
dw    53,34740,  309,34740,  565,34650,  821,34650
dw    54,34650,  310,34650,  566,34560,  822,34560
dw    55,34560,  311,34560,  567,34560,  823,34470
dw    56,34470,  312,34470,  568,34470,  824,34380
dw    57,34380,  313,34380,  569,34380,  825,34290
dw    58,34290,  314,34290,  570,34290,  826,34200
dw    59,34200,  315,34200,  571,34200,  827,34110
dw    60,34110,  316,34110,  572,34110,  828,34020
dw    61,34020,  317,34020,  573,34020,  829,33930
dw    62,33930,  318,33930,  574,33930,  830,33840
dw    63,33840,  319,33840,  575,33750,  831,33750
dw    64,33750,  320,33750,  576,33660,  832,33660
dw    65,33660,  321,33570,  577,33570,  833,33570
dw    66,33480,  322,33480,  578,33480,  834,33390
dw    67,33390,  323,33390,  579,33300,  835,33300
dw    68,33300,  324,33210,  580,33210,  836,33120
dw    69,33120,  325,33120,  581,33030,  837,33030
dw    70,32940,  326,32940,  582,32850,  838,32850
dw    71,32760,  327,32760,  583,32670,  839,32670
dw    72,32580,  328,32580,  584,32490,  840,32490
dw    73,32400,  329,32310,  585,32310,  841,32220
dw    74,32130,  330,32040,  586,31950,  842,31860
dw    75,31680,  331,31320,  587,30780,  331,30510
dw    75,30240,  842,29970,  586,29700,  330,29430
dw    74,29160,  841,28890,  585,28620,  329,28440
dw    73,28170,  840,27900,  584,27720,  328,27450
dw    72,27180,  839,27000,  583,26730,  327,26550
dw    71,26370,  838,26100,  582,25920,  326,25740
dw    70,25560,  837,25290,  581,25110,  325,24930
dw    69,24750,  836,24570,  580,24480,  324,24300
dw    68,24120,  835,23940,  579,23850,  323,23670
dw    67,23490,  834,23400,  578,23220,  322,23130
dw    66,23040,  833,22860,  577,22770,  321,22680
dw    65,22590,  832,22500,  576,22410,  320,22320
dw    64,22230,  831,22230,  575,22140,  319,22050
dw    63,22050,  830,21960,  574,21960,  318,21870
dw    62,21870,  829,21870,  573,21780,  317,21780
dw    61,21780,  828,21780,  572,21690,  316,21690
dw    60,21690,  827,21690,  571,21690,  315,21600
dw    59,21600,  826,21600,  570,21600,  314,21600
dw    58,21600,  825,21510,  569,21510,  313,21510
dw    57,21510,  824,21510,  568,21510,  312,21420
dw    56,21420,  823,21420,  567,21420,  311,21420
dw    55,21420,  822,21330,  566,21330,  310,21330
dw    54,21330,  821,21330,  565,21330,  309,21240
dw    53,21240,  820,21240,  564,21240,  308,21240
dw    52,21150,  819,21150,  563,21150,  307,21150
dw    51,21150,  818,21150,  562,21060,  306,21060
dw    50,21060,  817,21060,  561,21060,  305,20970
dw    49,20970,  816,20970,  560,20970,  304,20970
dw    48,20880,  815,20880,  559,20880,  303,20880
dw    47,20880,  814,20790,  558,20790,  302,20790
dw    46,20790,  813,20790,  557,20700,  301,20700
dw    45,20700,  812,20700,  556,20700,  300,20610
dw    44,20610,  811,20610,  555,20610,  299,20520
dw    43,20520,  810,20520,  554,20520,  298,20520
dw    42,20430,  809,20430,  553,20430,  297,20430
dw    41,20340,  808,20340,  552,20340,  296,20340
dw    40,20250,  807,20250,  551,20250,  295,20250
dw    39,20160,  806,20160,  550,20160,  294,20160
dw    38,20070,  805,20070,  549,20070,  293,20070
dw    37,19980,  804,19980,  548,19980,  292,19980
dw    36,19890,  803,19890,  547,19890,  291,19890
dw    35,19800,  802,19800,  546,19800,  290,19710
dw    34,19710,  801,19710,  545,19710,  289,19620
dw    33,19620,  800,19620,  544,19530,  288,19530
dw    32,19530,  799,19440,  543,19440,  287,19440
dw    31,19350,  798,19350,  542,19350,  286,19260
dw    30,19260,  797,19260,  541,19170,  285,19170
dw    29,19080,  796,19080,  540,19080,  284,18990
dw    28,18990,  795,18900,  539,18900,  283,18810
dw    27,18810,  794,18720,  538,18720,  282,18630
dw    26,18630,  793,18540,  537,18540,  281,18450
dw    25,18450,  792,18360,  536,18270,  280,18270
dw    24,18180,  791,18090,  535,18000,  279,17910
dw    23,17820,  790,17640,  534,17280,  790,16740
dw    23,16560,  279,16380,  535,16200,  791,16110
dw    24,15930,  280,15840,  536,15750,  792,15660
dw    25,15570,  281,15480,  537,15390,  793,15300
dw    26,15300,  282,15210,  538,15120,  794,15030
dw    27,15030,  283,14940,  539,14850,  795,14850
dw    28,14760,  284,14670,  540,14670,  796,14580
dw    29,14490,  285,14490,  541,14400,  797,14400
dw    30,14310,  286,14310,  542,14220,  798,14220
dw    31,14130,  287,14130,  543,14040,  799,14040
dw    32,13950,  288,13950,  544,13860,  800,13860
dw    33,13770,  289,13770,  545,13680,  801,13680
dw    34,13590,  290,13590,  546,13500,  802,13500
dw    35,13500,  291,13410,  547,13410,  803,13320
dw    36,13320,  292,13320,  548,13230,  804,13230
dw    37,13140,  293,13140,  549,13140,  805,13050
dw    38,13050,  294,12960,  550,12960,  806,12960
dw    39,12870,  295,12870,  551,12870,  807,12780
dw    40,12780,  296,12690,  552,12690,  808,12690
dw    41,12600,  297,12600,  553,12600,  809,12510
dw    42,12510,  298,12510,  554,12420,  810,12420
dw    43,12420,  299,12330,  555,12330,  811,12330
dw    44,12240,  300,12240,  556,12240,  812,12150
dw    45,12150,  301,12150,  557,12060,  813,12060
dw    46,12060,  302,12060,  558,11970,  814,11970
dw    47,11970,  303,11880,  559,11880,  815,11880
dw    48,11790,  304,11790,  560,11790,  816,11790
dw    49,11700,  305,11700,  561,11700,  817,11610
dw    50,11610,  306,11610,  562,11610,  818,11520
dw    51,11520,  307,11520,  563,11430,  819,11430
dw    52,11430,  308,11430,  564,11340,  820,11340
dw    53,11340,  309,11250,  565,11250,  821,11250
dw    54,11250,  310,11160,  566,11160,  822,11160
dw    55,11160,  311,11070,  567,11070,  823,11070
dw    56,11070,  312,10980,  568,10980,  824,10980
dw    57,10980,  313,10890,  569,10890,  825,10890
dw    58,10890,  314,10800,  570,10800,  826,10800
dw    59,10800,  315,10710,  571,10710,  827,10710
dw    60,10710,  316,10620,  572,10620,  828,10620
dw    61,10620,  317,10530,  573,10530,  829,10530
dw    62,10530,  318,10440,  574,10440,  830,10440
dw    63,10440,  319,10350,  575,10350,  831,10350
dw    64,10350,  320,10260,  576,10260,  832,10260
dw    65,10260,  321,10260,  577,10170,  833,10170
dw    66,10170,  322,10170,  578,10080,  834,10080
dw    67,10080,  323,10080,  579,10080,  835, 9990
dw    68, 9990,  324, 9990,  580, 9990,  836, 9900
dw    69, 9900,  325, 9900,  581, 9900,  837, 9900
dw    70, 9810,  326, 9810,  582, 9810,  838, 9810
dw    71, 9720,  327, 9720,  583, 9720,  839, 9720
dw    72, 9720,  328, 9630,  584, 9630,  840, 9630
dw    73, 9630,  329, 9630,  585, 9540,  841, 9540
dw    74, 9540,  330, 9540,  586, 9450,  842, 9450
dw    75, 9450,  331, 9450,  587, 9450,  843, 9360
dw    76, 9360,  332, 9360,  588, 9360,  844, 9360
dw    77, 9270,  333, 9270,  589, 9270,  845, 9270
dw    78, 9270,  334, 9180,  590, 9180,  846, 9180
dw    79, 9180,  335, 9180,  591, 9090,  847, 9090
dw    80, 9090,  336, 9090,  592, 9090,  848, 9000
dw    81, 9000,  337, 9000,  593, 9000,  849, 9000
dw    82, 8910,  338, 8910,  594, 8910,  850, 8910
dw    83, 8910,  339, 8820,  595, 8820,  851, 8820
dw    84, 8820,  340, 8820,  596, 8820,  852, 8730
dw    85, 8730,  341, 8730,  597, 8730,  853, 8730
dw    86, 8640,  342, 8640,  598, 8640,  854, 8640
dw    87, 8640,  343, 8550,  599, 8550,  855, 8550
dw    88, 8550,  344, 8550,  600, 8550,  856, 8460
dw    89, 8460,  345, 8460,  601, 8460,  857, 8460
dw     0,    0

scroll_text     db      100 dup (32)
                db      '0123456789 WHAT YOU ARE SEEING NOW IS NOT YOUR ORDINARY '
                db      'SCROLL. YOU ARE WITNESSING A MOST PECULIAR SCROLL '
                db      'THAT WILL SWIRVE FROM LEFT TO RIGHT AND BACK LEFT '
                db      'AGAIN. NOT ONLY HORIZONTAL CHANGE, BUT YOU WILL ALSO '
                db      'EXPERIENCE VERTICAL CHANGE AS WELL. THE SCROLL WILL '
                db      'TRAVEL A PATH WINDING DOWN THE SCREEN AND THEN '
                db      'CURVE BACK UP. AMAZING!!! '
                db      0

scroll_index    dw      0,0
scroll_bit      db      0,0

.code
; Load font into memory
load_font       proc    near
                push    ds
                mov     ax,@data
                mov     ds,ax
                mov     bx,64*16/16
                mov     ah,48h                          ; Allocate memory
                int     21h                             ;  for font
                mov     font,ax
                mov     dx,offset font_file
                mov     ax,3d00h
                int     21h
                mov     handle,ax

                push    ds
                mov     bx,handle
                mov     ax,font
                mov     ds,ax
                xor     dx,dx
                mov     cx,64*16
                mov     ah,3fh
                int     21h
                pop     ds

                mov     bx,handle
                mov     ah,3eh
                int     21h

                pop     ds
                retn
load_font       endp

; Free allocated font memory
free_font       proc    near
                push    ds
                mov     ah,49h
                mov     es,font
                int     21h
                pop     ds
                retn
free_font       endp

; VGA graphics mode 360x480x256 colours
vptbl           dw      06b00h,05901h,05a02h,08e03h
                dw      05e04h,08a05h,00d06h,03e07h
                dw      04009h,0ea10h,0ac11h,0df12h
                dw      02d13h,00014h,0e715h,00616h
                dw      0e317h

mode13x         proc    near
                push    ds
                mov     ax,13h
                int     10h

                mov     dx,3c4h
                mov     ax,00604h
                out     dx,ax
                mov     ax,00f02h
                out     dx,ax
                mov     ax,0a000h
                mov     es,ax
                xor     di,di
                xor     ax,ax
                mov     cx,90*480/2
                rep     stosw

                mov     ax,00300h
                out     dx,ax
                mov     dx,3c2h
                mov     al,0e7h
                out     dx,al
                mov     dx,3d4h
                mov     al,11h
                out     dx,ax
                inc     dx
                in      al,dx
                and     al,127
                out     dx,al
                dec     dx

                push    cs
                pop     ds
                mov     cx,17
                lea     si,vptbl

save_vptable:
                lodsw
                out     dx,ax
                loop    save_vptable
                pop     ds
                retn
mode13x         endp

; Wait for retrace
retrace         proc    near
                mov     dx,3dah

wait_retrace:
                in al,dx
                test al,08
                jz wait_retrace
                retn
retrace         endp

; Allocate memory for bitmap
alloc_bitplanes proc    near
                push    ds
                mov     ax,@data
                mov     ds,ax
                mov     bh,0
                mov     bitplane,bh

alloc_bit_next:
                mov     ah,48h                          ; Alloctae bitplane 0
                mov     bx,90*480/16
                int     21h
                mov     bl,bitplane
                xor     bh,bh
                shl     bx,1
                mov     [bx+offset bitplanes],ax
                inc     bitplane
                cmp     bitplane,4
                jnz     alloc_bit_next

                pop     ds
                retn
alloc_bitplanes endp

; Free allocated bitplanes memory
free_bitplanes  proc    near
                push    ds
                mov     cx,4

free_next_bit:
                mov     bx,cx
                shl     bx,1
                mov     es,[bx+offset bitplanes]
                mov     ah,49h
                int     21h
                loop    free_next_bit
                pop     ds
                retn
free_bitplanes  endp

; Clear bitplanes
clear_bitplanes proc    near
                push    ds
                mov     ax,@data
                mov     ds,ax
                xor     ax,ax

                mov     es,bitplanes
                xor     di,di
                mov     cx,90*480/2
                rep     stosw

                mov     es,bitplanes+2
                xor     di,di
                mov     cx,90*480/2
                rep     stosw

                mov     es,bitplanes+4
                xor     di,di
                mov     cx,90*480/2
                rep     stosw

                mov     es,bitplanes+6
                xor     di,di
                mov     cx,90*480/2
                rep     stosw

                pop     ds
                retn
clear_bitplanes endp

; Copy Bitmap0-3 into video memory at A000:0000
copy_bitplanes  proc    near
                push    ds
                push    bp
                mov     bx,@data
                mov     ds,bx
                mov     ax,0a000h
                mov     es,ax
                mov     dx,03c4h
                mov     bp,0
                mov     y,480

copy_next_line:
                mov     ax,0102h
                out     dx,ax
                mov     ds,bitplanes
                mov     di,bp
                mov     si,bp
                mov     cx,90/2
                rep     movsw

                mov     ds,bx
                mov     ax,0202h
                out     dx,ax
                mov     ds,bitplanes+2
                mov     di,bp
                mov     si,bp
                mov     cx,90/2
                rep     movsw

                mov     ds,bx
                mov     ax,0402h
                out     dx,ax
                mov     ds,bitplanes+4
                mov     di,bp
                mov     si,bp
                mov     cx,90/2
                rep     movsw

                mov     ds,bx
                mov     ax,0802h
                out     dx,ax
                mov     ds,bitplanes+6
                mov     di,bp
                mov     si,bp
                mov     cx,90/2
                rep     movsw

                add     bp,90
                mov     ds,bx
                dec     y
                jnz     copy_next_line

                pop     bp
                pop     ds
                retn
copy_bitplanes  endp

; Bounce bars
; Initialize bounce bars
init_bounce     proc    near
                push    ds
                mov     ax,@data
                mov     ds,ax
                mov     al,0
                mov     bx,0

init_bounce_next:
                mov     [bx+offset bounce_index],al
                add     al,12
                inc     bl
                cmp     bl,8
                jnz     init_bounce_next

                pop     ds
                retn
init_bounce     endp

; Update bounce bars
update_bounce   proc    near
                push    ds
                mov     ax,@data
                mov     ds,ax
                mov     bounce_bar,0

bounce_bar_next:
                mov     bitplane,0

bounce_bar_next_plane:
                xor     bh,bh
                mov     bl,bounce_bar                   ; Setup ES:DI in
                mov     bl,[bx+offset bounce_index]
                shl     bx,1
                mov     di,[bx+offset bounce_data]
                xor     bh,bh
                mov     bl,bitplane
                shl     bl,1
                mov     es,[bx+offset bitplanes]

                mov     bl,bounce_bar
                mov     cl,5
                shl     bl,cl
                mov     dl,16

bounce_bar_next_colour:
                mov     al,[bx+offset bounce_colours+8]
                mov     ah,al
                mov     cx,90/2
                rep     stosw
                inc     bx
                dec     dl
                jnz     bounce_bar_next_colour

                inc     bitplane
                cmp     bitplane,4
                jnz     bounce_bar_next_plane

                xor     bh,bh
                mov     bl,bounce_bar
                add     ds:[bx+offset bounce_index],1

                inc     bounce_bar
                cmp     bounce_bar,8
                jnz     bounce_bar_next
                pop     ds
                retn
update_bounce   endp

init_scroll     proc    near
                push    ds
                mov     ax,@data
                mov     ds,ax
                mov     scroll_index,0
                mov     scroll_bit,0
                pop     ds
                retn
init_scroll     endp

get_next_char   proc    near
                push    bx
                mov     bx,scroll_index+2
                mov     bl,[bx+offset scroll_text]
                cmp     bl,0
                jnz     not_scroll_wrap
                mov     scroll_index+2,0
                mov     bl,scroll_text

not_scroll_wrap:
                xor     bh,bh
                sub     bl,32
                shl     bx,4
                mov     si,bx
                pop     bx
                retn
get_next_char   endp

update_scroll   proc    near
                push    ds
                push    bp
                mov     bp,@data
                mov     ds,bp
                mov     ax,scroll_index
                mov     scroll_index+2,ax
                mov     al,scroll_bit
                mov     scroll_bit+1,al
                mov     x,0
                call    get_next_char

update_next_position:
                mov     bx,x
                shl     bx,2
                mov     di,[bx+offset scroll_data+2]
                cmp     di,0
                jz      update_scroll_end
                mov     ax,[bx+offset scroll_data]
                mov     bl,ah
                xor     ah,ah
                add     di,ax
                xor     bh,bh
                shl     bl,1
                mov     es,[bx+offset bitplanes]

                mov     cl,scroll_bit+1
                xor     cl,7
                mov     bl,1
                shl     bl,cl
                mov     dx,si
                mov     cx,16
                mov     ds,font

update_next_line:
                lodsb
                and     al,bl
                jz      update_no_pixel
                mov     al,cl
                add     al,32
                mov     es:[di],al

update_no_pixel:
                add     di,90
                loop    update_next_line
                mov     ds,bp
                mov     si,dx
                inc     scroll_bit+1
                cmp     scroll_bit+1,8
                jnz     update_no_wrap_temp
                mov     scroll_bit+1,0
                inc     scroll_index+2
                call    get_next_char

update_no_wrap_temp:
                inc     x
                jmp     update_next_position

update_scroll_end:
                add     scroll_bit,4
                cmp     scroll_bit,8
                jl      scroll_not_wrap
                mov     al,scroll_bit
                and     al,7
                mov     scroll_bit,al
                inc     scroll_index
                mov     bx,scroll_index
                mov     al,[bx+offset scroll_text]
                cmp     al,0
                jnz     scroll_not_wrap
                mov     scroll_index,0

scroll_not_wrap:
                pop     bp
                pop     ds
                retn
update_scroll   endp


; Main routine
start:
                mov     ax,@data
                mov     ds,ax

                mov     ah,4ah                          ; Modify memory
                mov     bx,8000h
                mov     cl,4
                shr     bx,cl
                int     21h

                call    alloc_bitplanes
                call    load_font
                call    mode13x
                call    init_bounce
                call    init_scroll

again:
                call    clear_bitplanes
                call    update_bounce
                call    update_scroll
                call    retrace
                call    copy_bitplanes
                mov     ah,1
                int     16h
                jz     again

                call    free_font
                call    free_bitplanes
                mov     ax,3
                int     10h
                mov     ax,4c00h
                int     21h
                end    start

