program externalprotocol;

type protorec = record
              letter:char;
                desc:string[30];
            progname:string[12];
                comm:string[60];
              end;

var pro:file of protorec; prots:protorec; which:char;
    filenm: string[15];
    protlist:array [1..120] of protorec; count:integer; work:string[80];

procedure makefile(fname:string);
var ff:file of protorec; frec:protorec;
begin
     assign(ff,fname);
     rewrite(ff);
     frec.letter:='Z';
     frec.desc:='External Zmodem (DSZ)';
     frec.progname:='DSZ.COM';
     frec.comm:=' port %1 speed %2 sz %3';
     write(ff,frec);
     close(ff);
end;

function exist(fname:string):boolean;
var ff:file;
begin
     assign(ff,fname); {$I-};
     reset(ff); {$I+};
     exist:=(ioresult=0);
end;



procedure dobar(width:integer);
var ct:integer;
begin
     write('(');
     for ct:=1 to width do write('');
     writeln(')');
end;

procedure readyfile;
begin
     count:=0; reset(pro);
     while not eof(pro) do begin
               count:=count+1;
               read(pro,prots);
               protlist[count].letter:=prots.letter;
               protlist[count].desc:=prots.desc;
               protlist[count].comm:=prots.comm;
               protlist[count].progname:=prots.progname;
               end;
end;

Procedure DoLonglist;
var ct:integer;
begin;
      writeln(' #   Ltr          Description                     Command Line          ');
      writeln('   ');

For ct:=1 to count do begin
          write(ct:2,'    ',protlist[ct].letter,'   ');
          writeln(protlist[ct].desc:30,' ',protlist[ct].progname+protlist[ct].comm);
          end;
      writeln;
end;

Procedure GetParm(addit:string; lump:integer);
begin
     writeln;
     writeln('Enter the ',addit,' protocol.');
     dobar(lump);
       write(':'); readln(work);
end;


procedure Newprotocol;
begin
     writeln; count:=count+1;
     writeln('Will be added as #',count,' to list.'); writeln;
     getparm('letter to respresent this',1); writeln;
     protlist[count].letter:=upcase(work[1]);
     getparm('description of the',30);
     protlist[count].desc:=copy(work,1,30);
     getparm('program name (i.e. LYNX.EXE, DSZ.COM) of this',12);
     protlist[count].progname:=copy(work,1,12); writeln; writeln;
     writeln('Below show the PARAMETER-ONLY portion of the command line');
     writeln('Use : %1=Port   %2=Speed   %3=File/Pathname');
     writeln('(example: port=%1 baud=%2 R %3)  Be sure to remember WHICH protocol');
     writeln('list you are editing and have the command line reflect that.');
     writeln('(Example: If you are adding an UPLOAD, you may have to type "R" or');
     writeln('"RZ" on the command line.  A seperate entry must be made for');
     writeln('other operations.');
     getparm('command line format for the',60);
     protlist[count].comm:=' '+copy(work,1,60);
     writeln; writeln(protlist[count].desc,' added. "S" ave to make permanent.');
writeln('Be sure that ',protlist[count].progname,' exists in your directory.');
     writeln;
end;

procedure deleteprotocol;
var delnum:integer; resp:char; lp:integer;
begin
     writeln (#27+'[2J');
     writeln ('Deletion of a Protocol');
     writeln;
     writeln;
     write('Delete Which Protocol [Enter the #]: '); readln(delnum);
     if (delnum > count) or (delnum <= 0) then
                writeln('Invalid #! Must be between 1-',count,'!');
     if (delnum > count) or (delnum <= 0) then exit;
     writeln; write('Remove "',protlist[delnum].desc,'" from File [y/n]? ');
     readln(resp); resp:=upcase(resp);
     if resp='N' then exit;
     for lp:=delnum to count do begin;
         protlist[lp].letter:=protlist[lp+1].letter;
         protlist[lp].desc  :=protlist[lp+1].desc;
         protlist[lp].comm  :=protlist[lp+1].comm;
       protlist[lp].progname:=protlist[lp+1].progname;
       end;
     writeln; writeln('Protocol has now been deleted! To save for GOOD, Use "S"');
     writeln; count:=count-1;
end;

procedure savelist;
var ct:integer;
begin
     rewrite(pro);
     for ct:=1 to count do write(pro,protlist[ct]);
end;


begin;
      if not exist('PROTR.DAT') then makefile('PROTR.DAT');
      if not exist('PROTS.DAT') then makefile('PROTS.DAT');

      writeln (#27+'[2J');
      writeln ('͸');
      writeln ('   Cyanide External Protocol Editor v.02   ');
      writeln (';');
      writeln;
      writeln ('Open Data File for:');
      writeln ;
      writeln ('(R) - Regular Uploads   (S) - Regular Downloads');
      writeln;
      write   ('Selection -> ');
      readln(which);
      which:=upcase(which);
      filenm:='PROT'+which+'.DAT';
      assign(pro,filenm);

      readyfile;
      writeln; writeln;
      writeln('Protcol File: ',filenm,' with ',count,' entries.');
      which:='X'; writeln;

      while (which<>'Q') do begin
            writeln ('Edit Protocol(s): ');
            writeln ('(L) - List     (S) - Save   ');
            writeln ('(A) - Add      (D) - Delete ');
            writeln ('(Q) - Quit');
            writeln; writeln;
            write ('Selection -> ');
            readln(which); which:=upcase(which);
            case which of
                       'L'   : dolonglist;
                       'S'   : savelist;
                       'A'   : newprotocol;
                       'D'   : deleteprotocol;
                       end;
      end;
      writeln; writeln('Quiting External Protocol Editor!'); close(pro);
      writeln;
end.
