program config;

{$R-,S+,I-,D+,F-,V-,B-,N-,L+ }
{$M 16384,5000,5000 }

uses crt,
     scrnunit,scrninpt,
    general,prompts,
     gentypes,configrt;

const normalcolor=3;
      boldcolor=9;
      barcolor=$1f;
      inputcolor=11;
      choicecolor=15;
      datacolor=15;

var prompt:promptset;

procedure writeconfig;
var q:file of configsettype;
begin
  assign (q,'CYANIDE.CFG');
  rewrite (q);
  write (q,configset);
  close (q)
end;

procedure formatconfig;
var cnt:integer;
begin
  versioncode:=thisversioncode;
  longname[0]:=#0;
  shortname[0]:=#0;
  sysopname[0]:=#0;
  getdir (0,forumdir);
  if forumdir[length(forumdir)]<>'\' then forumdir:=forumdir+'\';
  textdir:=forumdir+'MSGS\';
  uploaddir:=forumdir+'GFILES\';
  boarddir:=forumdir+'BOARD\';
  asciidownload:='Leeched from The - A/A';
  textfiledir:=forumdir+'MENUS\';
  doordir:=forumdir;
  modemsetupstr:='ATX1M1S0=1|';
  modemhangupstr:='+++~~~ATH0|';
  modemdialprefix:='ATDT';
  modemdialsuffix:='|';
  defbaudrate:=2400;
  usecom:=1;
  hashayes:=false;
  anonymouslevel:=40;
  numwelcomes:=1;
  mintimeout:=3;
  sysoplevel:=32000;
  defudlevel:=0;
  defudpoints:=0;
  normbotcolor:=11;
  normtopcolor:=13;
  outlockcolor:=14;
  splitcolor:=9;
  statlinecolor:=10;
  uploadfactor:=3;
  private:=false;
  autologin:=false;
  useconmode:=true;
  escinmsgs:=true;
{
  allowcol:=true;
  allowdatfn:=true;
  allowpause:=false;
  allowkeypr:=false;
  allowhandle:=true;
  allowclrscr:=true;
}
  bkspinmsgs:=true;
  requireforms:=true;
  dotchar:='x';
  usebi:=true;
  supportedrates:=[b1200]+[b2400];
  downloadrates:=supportedrates;
  availtime:='4:00 pm';
  unavailtime:='10:00 pm';
  xmodemopentime:='3:00 am';
  xmodemclosetime:='3:00 am';
  for cnt:=1 to 100 do usertime[cnt]:=cnt*2;
  level2nd:=0;
  udlevel2nd:=0;
  udpoints2nd:=0;
  postlevel:=40;
  anonymousstr:='< Anonymous >';
  usematrix:=true;
  matrixtype:=1;
  newusermatrix:=true;
  systempassword:='Cyanide';
  newuserpass:=#0;
  emergencychatpw:='I wanna chat!';
  remotedoors:=false;
  allowdoors:=false;
  eventtime[0]:=#0;
  eventbatch[0]:=#0;
  directvideomode:=true;
  checksnowmode:=true;
  hangnewusers:=false;
  msgnextlvl:=10;
  appear:='The Sysop is here.';
  disappear:='The Sysop is gone.';
  telenumber:='Yor/Num/Ber!';
  timerestlvl:=1;
  timereststart[0]:=#0;
  timerestend[0]:=#0;
  sklog:=forumdir+'SUPERK.LOG';
  dszlogname:=forumdir+'DSZ.LOG';
  jshutup:=true;
  newusernote:='NewUser';
  system2password[0]:=#0;
  system3password[0]:=#0;
  availstr:='The Sysop is available for chat.';
  notavailstr:='The Sysop is not available for chat.';
  useqr:=true;
  qrlimit:=-25;
  qrmultifactor:=5;
  qrexempt:=60;
  usecliche:=true;
  cliche:='Cyanide BBS Software - Spreadin'' Fast!';
  ulpercent:=50;
  checkautologin:=false;
  usetimebank:=true;
  maxdeposit:=60;
  readanonlvl:=32000;
  listuserlvl:=40;
  ems:=false;
  datascrambling:=false;
  pcrexempt:=32000;
  xferpcr:=60;
  gfpcr:=60;
  gfratio:=60;
  udratio:=60;
  udexempt:=32000;
  doorpcr:=15;
  matrixfback:=true;
  matrixreqchat:=true;
  editor:='C:\Q.EXE';
  userumor:=true;
  useuemsgs:=true;
  filepw:=true;
  netnum:=11;
  netpas:='CyanideNET';
  tenderpas:='Password';
  xmodemr:='dsz.com port %1 speed %2 rx -c %3';
  xmodems:='dsz.com port %1 speed %2 sx -k %3';
  ymodemr:='dsz.com port %1 speed %2 rx -c %3';
  ymodems:='dsz.com port %1 speed %2 sx -k %3';
  zmodemr:='dsz.com port %1 speed %2 rz %3';
  zmodems:='dsz.com port %1 speed %2 sz -s %3';
  jmodemr:='jmodem.com R%1 %3';
  jmodems:='jmodem.com S%1 %3';
  lynxr:='lynx.exe R /%1 /%2 %3';
  lynxs:='lynx.exe S /%1 /%2 %3';
  xovrr:='dsz.com port %1 speed %2 ro %3';
  xovrs:='dsz.com port %1 speed %2 so %3';
  yovrr:='dsz.com port %1 speed %2 rb -o %3';
  yovrs:='dsz.com port %1 speed %2 sb -o %3';
  ymodemgr:='dsz.com port %1 speed %2 rb -g %3';
  ymodemgs:='dsz.com port %1 speed %2 sb -g %3';
  superkr:='superk.com p%1 s%2 rs f %3';
  superks:='superk.com p%1 s%2 ss f %3';
  k9xr:='superk.com p%1 s%2 rk f %3';
  k9xs:='superk.com p%1 s%2 sk f %3';
  zcrashr:='dsz.com port %1 speed %2 rz -r %3';
  zcrashs:='dsz.com port %1 speed %2 sz -r %3';
  zpcpr:='dsz.com port %1 speed %2 rz -w %3';
  zpcps:='dsz.com port %1 speed %2 sz -w %3';
  wxmodemr:='superk.com p%1 s%2 rw f %3';
  wxmodems:='superk.com p%1 s%2 sw f %3';
  zrles:='dsz.com port %1 speed %2 sz -Z %3';
  punterr:='punter.exe R P%1 B%1 %3';
  punters:='punter.exe S P%1 B%1 %3';
  writeconfig
end;


type ttypetype=(TInteger,Tsstr,Tmstr,Tlstr,TBoolean,TChar,TBaudset,
                TPath,TTime,TAttrib,Tusertime,Badtype);
     ptrset=record
       case integer of
         0:(i:^integer);
         1:(l:^lstr);
         2:(b:^boolean);
         3:(k:^char);
         4:(baudsetptr:^baudset)
     end;
     thing=record
       text:mstr;
       descrip:lstr;
       ttype:ttypetype;
       p:pointer;
       r1,r2:integer
     end;

const ttypestr:array [ttypetype] of sstr=
  ('Int','sstr','mstr','lstr','Boo','Char','Baud','Path','Time',
   'Attrib','Usertime','!!!!????');
      colorstr:array [0..15] of mstr=
  ('Black','Blue ','Green ','Cyan ','Red ','Magenta ','Brown ','White ',
   'Gray ','BLUE!','GREEN!','CYAN!','RED!','MAGENTA!','YELLOW!','WHITE!');

const maxthings=200;
      dcol=30;

var top,bot,page,numpages,numthings:integer;
    things:array [1..maxthings] of thing;

procedure pause;
begin
  delay (100);
end;

procedure cb;
begin
  setcolor (boldcolor)
end;

procedure c4;
begin
  setcolor (4)
end;

procedure cn;
begin
  setcolor (normalcolor)
end;

procedure c7;
begin
  setcolor (7)
end;

procedure cs;
begin
 setcolor (boldcolor);
end;

procedure cd;
begin
 setcolor (normalcolor);
end;

function match(a1,a2:anystr):boolean;
var cnt:integer;
begin
  match:=false;
  while a1[length(a1)]=' ' do a1[0]:=pred(a1[0]);
  while a2[length(a2)]=' ' do a2[0]:=pred(a2[0]);
  if length(a1)<>length(a2) then exit;
  for cnt:=1 to length(a1) do
    if upcase(a1[cnt])<>upcase(a2[cnt]) then exit;
  match:=true
end;

function yesnostr (var b:boolean):sstr;
begin
  if b and (ord(b)<>ord(true)) then b:=true;
  if b then yesnostr:='Yes' else yesnostr:='No'
end;

function strr (n:integer):mstr;
var q:mstr;
begin
  str (n,q);
  strr:=q
end;

function valu (q:mstr):integer;
var i,s:integer;
begin
  val (q,i,s);
  if s=1
    then valu:=0
    else valu:=i
end;

function whichpage (n:integer):integer;
begin
  whichpage:=((n-1) div 20)+1
end;

function whichline (n:integer):integer;
begin
  whichline:=n-20*(whichpage(n)-1)+2
end;

function getbaudstr (var q:baudset):lstr;
var w:lstr;
    cnt:baudratetype;
begin
  w[0]:=chr(0);
  for cnt:=firstbaud to lastbaud do
    if cnt in q then w:=w+strr(baudarray[cnt])+' ';
  if length(w)=0 then w:='None';
  getbaudstr:=w
end;

function varstr (n:integer):string;
var pu:pointer;
    p:ptrset absolute pu;
begin
  pu:=things[n].p;
  case things[n].ttype of
    tinteger:varstr:=strr(p.i^);
    tlstr,tmstr,tsstr,tpath,ttime:varstr:=p.l^;
    tboolean:varstr:=yesnostr(p.b^);
    tchar:varstr:=p.k^;
    tbaudset:varstr:=getbaudstr (p.baudsetptr^);
    tattrib:varstr:=colorstr[p.i^];
    tusertime:varstr:='(Configure User Daily Time)';
    else varstr:='??!?!?!'
  end
end;

procedure writevar (n:integer);
begin
  cb;
  write (varstr(n));
  cn; clreol;
  writeln
end;

procedure gotopage (p:integer);
var cnt,cy:integer;
begin
  if p<1 then p:=1;
  if p>numpages then p:=numpages;
  if p<>page then begin
    if page<>0 then freeprompts (prompt);
    page:=p;
    gotoxy (1,1);
    cn; write ('Cyanide BBS Software Version ');
    cn; write (ver);
    cn; write (' Configuration / ');
    cn; write ('Page ');
    cb; write (page);
    cn; write (' of ');
    cb; write (numpages);
    cn; writeln (':  ');
    cb; writeln ('');
    top:=(page-1)*20+1;
    bot:=top+19;
    if bot>numthings then bot:=numthings;
    beginprompts (prompt);
    for cnt:=top to top+19 do begin
      cy:=cnt-top+3;
      gotoxy (1,cy);
      cn; clreol;
      if cnt<=bot then begin
        addprompt (prompt,command,prompt,5,cnt-top+3,things[cnt].text+':');
        setinputwid (prompt,0);
        drawprompt (prompt);
        gotoxy (1,cy);
        cn; write (cnt:2,'. ');
        gotoxy (dcol,wherey);
        writevar (cnt)
      end
    end
  end
end;

procedure readdata;
var q:text;
    t:mstr;

  procedure dataerror (n:lstr);
  begin
    writeln ('Record ',numthings,': '+n);
    halt
  end;

  procedure illtype;
  begin
    dataerror ('Invalid type: '+t)
  end;

  procedure getrange (t:mstr; var r1,r2:integer);
  var sp,da,n1,n2:integer;
  begin
    sp:=pos(' ',t);
    r1:=-32767;
    r2:=32767;
    if sp=0 then exit;
    t:=copy(t,sp+1,255);
    if length(t)<1 then exit;
    da:=pos('-',t);
    if (da=1) and (length(t)=1) then exit;
    if da=0 then begin
      r1:=valu(t);
      r2:=r1;
      exit
    end;
    n1:=valu(copy(t,1,da-1));
    n2:=valu(copy(t,da+1,255));
    if da=1 then begin
      r2:=n2;
      exit
    end;
    r1:=n1;
    if da=length(t) then exit;
    r2:=n2
  end;

  procedure gettype (t:mstr; var tt:ttypetype);
  var sp:integer;
      fw:mstr;
  begin
    tt:=ttypetype(0);
    sp:=pos(' ',t);
    if sp=0
      then fw:=t
      else fw:=copy(t,1,sp-1);
    while tt<>badtype do
      begin
        if match(fw,ttypestr[tt]) then exit;
        tt:=succ(tt)
      end;
    tt:=badtype;
    illtype
  end;

begin
  assign (q,'Config.Dat');
  reset (q);
  numthings:=0;
  if ioresult<>0 then dataerror ('File CONFIG.DAT not found!');
  while not eof(q) do begin
    numthings:=numthings+1;
    with things[numthings] do begin
      readln (q,text);
      readln (q,descrip);
      readln (q,t);
      gettype (t,ttype);
      if ttype=tinteger then getrange (t,r1,r2)
    end
  end;
  close (q)
end;

procedure assignptrs;
var cnt:integer;

  procedure s (var q);
  begin
    cnt:=cnt+1;
    things[cnt].p:=@q
  end;

begin
  cnt:=0;
  s (longname);
  s (shortname);
  s (sysopname);
  s (autologin);
  s (forumdir);
  s (textdir);
  s (boarddir);
  s (uploaddir);
  s (textfiledir);
  s (doordir);
  s (supportedrates);
  s (downloadrates);
  s (defbaudrate);
  s (usecom);
  s (hashayes);
  s (modemsetupstr);
  s (modemhangupstr);
  s (modemdialprefix);
  s (modemdialsuffix);
  s (sysoplevel);
  s (anonymouslevel);
  s (numwelcomes);
  s (private);
  s (directvideomode);
  s (checksnowmode);
  s (useconmode);
  s (escinmsgs);
{
  s (allowcol);
  s (allowdatfn);
  s (allowpause);
  s (allowkeypr);
  s (allowhandle);
  s (allowclrscr);
}
  s (bkspinmsgs);
  s (normbotcolor);
  s (normtopcolor);
  s (outlockcolor);
  s (splitcolor);
  s (statlinecolor);
  s (usertime);
  s (mintimeout);
  s (dotchar);
  s (asciidownload);
  s (defudlevel);
  s (defudpoints);
  s (level2nd);
  s (udlevel2nd);
  s (udpoints2nd);
  s (postlevel);
  s (uploadfactor);
  s (availtime);
  s (unavailtime);
  s (xmodemopentime);
  s (xmodemclosetime);
  s (useuemsgs);       (* Ansi Pull Downs etc.. "You have been granted blah *)
  s (usematrix);
  s (matrixtype);
  s (newusermatrix);
  s (systempassword);
  s (newuserpass);
  s (system2password);
  s (system3password);
  s (anonymousstr);
  s (requireforms);
  s (remotedoors);
  s (allowdoors);
  s (eventtime);
  s (eventbatch);
  s (hangnewusers);
  s (msgnextlvl);
  s (appear);
  s (disappear);
  s (telenumber);
  s (timerestlvl);
  s (timereststart);
  s (timerestend);
  s (sklog);
  s (dszlogname);
  s (jshutup);
  s (newusernote);
  s (availstr);
  s (notavailstr);
  s (useqr);
  s (qrmultifactor);
  s (qrlimit);
  s (qrexempt);
  s (usecliche);
  s (cliche);
  s (usetimebank);
  s (maxdeposit);
  s (ulpercent);
  s (checkautologin);
  s (readanonlvl);
  s (listuserlvl);
  s (ems);
  s (pcrexempt);
  s (xferpcr);
  s (gfpcr);
  s (gfratio);
  s (udratio);
  s (udexempt);
  s (doorpcr);
  s (tenderpas);
  s (matrixfback);
  s (matrixreqchat);
  s (editor);
  s (userumor);
  s (filepw);
  s (netnum);
  s (netpas);
  s (usebi);
  if cnt<>numthings then begin
    writeln ('Error in number of items of CONFIG.DAT');
    writeln ('Expected: ',numthings);
    writeln ('Actual  : ',cnt);
    halt
  end
end;

procedure byebye;
begin
  clearwindow (normalcolor);
  gotoxy (38,24);
  cb; writeln ('Bye!');
  halt
end;

procedure byebyeii;
begin
  clearwindow (normalcolor);
  gotoxy (1,2);
  writeln ('Saving Data to Config File, Please Hold!');
  writeln;
  write ('Saving: ...............');
  gotoxy (9,4); write ('o'); pause;
  gotoxy (10,4); write ('o'); pause;
  gotoxy (11,4); write ('o'); pause;
  gotoxy (12,4); write ('o'); pause;
  gotoxy (13,4); write ('o'); pause;
  gotoxy (14,4); write ('o'); pause;
  gotoxy (15,4); write ('o'); pause;
  gotoxy (16,4); write ('o'); pause;
  gotoxy (17,4); write ('o'); pause;
  gotoxy (18,4); write ('o'); pause;
  gotoxy (19,4); write ('o'); pause;
  gotoxy (20,4); write ('o'); pause;
  gotoxy (21,4); write ('o'); pause;
  gotoxy (22,4); write ('o'); pause;
  gotoxy (23,4); write ('o'); pause;
  gotoxy (38,24);
  cb; writeln ('Bye!');
  halt
end;

procedure abortyn;
var q:sstr;
begin
  gotoxy (1,23);
  write ('WARNING: All Data Changed this session will NOT be saved!');
  gotoxy (1,24);
  setcolor (datacolor);
  write ('Config Abort [y/N]: ');
  cn;
  clreol;
  buflen:=1;
  readln (q);
  if length(q)>0 then if upcase(q[1])='Y' then byebye
end;

procedure getinput (n:integer; editit:boolean);
var y:integer;
    inp:lstr;
    t:thing;
    pu:pointer;
    p:ptrset absolute pu;

  procedure reshow;
  begin
    gotoxy (dcol,y);
    writevar (n)
  end;

  procedure showintrange;
  begin
    setcolor (datacolor); {c7}
    with t do
      if r1=-32767
        then if r2=32767
          then write ('No range limitation.')
          else write ('Maximum value: ',r2)
        else if r2=32767
          then write ('Minimum value: ',r1)
          else write ('Valid values range from ',r1,' to ',r2);
    cn
  end;

  procedure doint;
  var n,s:integer;
      k:char;
  begin
    val (inp,n,s);
    gotoxy (1,24);
    if s<>0
      then
        begin
          setcolor (datacolor);
          writeln ('Invalid number!  A number must be from -32767 to 32767.');
          cn;
          write ('Press [any key] to Continue');
          clreol;
          k:=bioskey
        end
      else if (n>=t.r1) and (n<=t.r2)
        then p.i^:=n
        else
          begin
            setcolor (datacolor);
            writeln ('Range error!  Must be within the above limits!  ');
            cn;
            write ('Press [Any key] to Continue');
            clreol;
            k:=bioskey
          end
  end;

  procedure dostr;
  begin
    if (inp='N') or (inp='n') then inp:='';
    p.l^:=inp
  end;

  procedure doboolean;
  begin
    case upcase(inp[1]) of
      'Y':p.b^:=true;
      'N':p.b^:=false
    end
  end;

  procedure dochar;
  begin
    p.k^:=inp[1]
  end;

  procedure dopath;
  var lc:char;
      cur:lstr;
      n:integer;
  begin
    lc:=inp[length(inp)];
    if (length(inp)<>1) or (upcase(lc)<>'N')
      then if (lc<>':') and (lc<>'\') then inp:=inp+'\';
    dostr;
    if inp[length(inp)]='\' then inp[0]:=pred(inp[0]);
    getdir (0,cur);
    chdir (inp);
    n:=ioresult;
    chdir (cur);
    if n=0 then exit;
    setcolor (datacolor);
    gotoxy (1,24);
    write ('Path doesn''t exist!  ');
    cn; write ('Create the path Now [y/n]? '); clreol;
    readln (cur);
    if length(cur)=0 then exit;
    if upcase(cur[1])<>'Y' then exit;
    mkdir (inp);
    if ioresult=0 then exit;
    gotoxy (1,24);
    setcolor (datacolor);
    write ('Error creating directory!  ');
    cn; write ('Press any key...');
    clreol;
    lc:=bioskey
  end;

  procedure dotime;
  var c,s,l:integer;
      d1,d2,d3,d4:char;
      ap,m:char;

    function digit (k:char):boolean;
    begin
      digit:=ord(k) in [48..57]
    end;

  begin
    l:=length(inp);
    if l=1 then begin
      if upcase(inp[1])='N' then dostr;
      exit
    end;
    if (l<7) or (l>8) then exit;
    c:=pos(':',inp);
    if c<>l-5 then exit;
    s:=pos(' ',inp);
    if s<>l-2 then exit;
    d2:=inp[c-1];
    if l=7
      then d1:='0'
      else d1:=inp[1];
    d3:=inp[c+1];
    d4:=inp[c+2];
    ap:=upcase(inp[s+1]);
    m:=upcase(inp[s+2]);
    if d1='1' then if d2>'2' then d2:='!';
    if (d1>='0') and (d1<='1') and digit(d2) and (d3>='0') and (d3<='5')
       and digit(d4) and ((ap='A') or (ap='P')) and (m='M') then dostr
  end;

  procedure dobaud;
  var inp:lstr;
      n:integer;
      cnt:baudratetype;
  label bfound,again;
  begin
    gotoxy (1,24);
    repeat
      gotoxy (wherex,24);
      write ('Baud Rate to toggle (Enter/Quit): ');
      clreol;
      buflen:=5;
      readln (inp);
      gotoxy (1,24);
      if length(inp)=0 then exit;
      n:=valu(inp);
      for cnt:=b110 to b19200 do if n=baudarray[cnt] then goto bfound;
      cb; write ('Not supported!  '); cn;
      goto again;
      bfound:
      if cnt in p.baudsetptr^
        then p.baudsetptr^:=p.baudsetptr^-[cnt]
        else p.baudsetptr^:=p.baudsetptr^+[cnt];
      reshow;
      again:
    until 0=1
  end;

  procedure dousertime;
  var input:lstr;
      n:integer;
      buffer:array [1..4096] of byte;
      b:block;

    procedure refresh;
    var cnt:integer;
    begin
      clearwindow (normalcolor);
      gotoxy (1,1);
      cn;
      writeln('Level Time  Level Time  Level Time  Level Time  Level Time');
      writeln('');
      gotoxy (1,3);
      for cnt:=1 to 100 do begin
        write (cnt:4,': ',usertime[cnt]:4);
        if (cnt mod 5)=0 then writeln else write ('  ')
      end
    end;

    procedure setone (n,v:integer);
    var x,y:integer;
    begin
      x:=((n-1) mod 5)*13+7;
      y:=((n-1) div 5)+3;
      gotoxy (x,y);
      write (v:4);
      usertime[n]:=v
    end;

    procedure getone (n:integer);
    var x,y,v:integer;
    begin
      x:=((n-1) mod 5)*13+7;
      y:=((n-1) div 5)+3;
      gotoxy (x,y);
      write ('    ');
      gotoxy (x,y);
      buflen:=4;
      readln (input);
      v:=valu(input);
      if (v<1) or (v>1000) then v:=usertime[n];
      setone (n,v)
    end;

    function getn (txt:lstr):integer;
    var input:lstr;
    begin
      gotoxy (1,23);
      write (txt,': ');
      clreol;
      buflen:=4;
      readln (input);
      getn:=valu(input)
    end;

    function getlvl (txt:lstr):integer;
    var n:integer;
    begin
      n:=getn (txt);
      if (n<1) or (n>100) then n:=0;
      getlvl:=n
    end;

    procedure pattern;
    var st,en,ba,se,cn:integer;
    begin
      st:=getlvl ('Starting level of pattern');
      if st=0 then exit;
      en:=getlvl ('Ending level of pattern');
      if en<st then exit;
      ba:=getn ('Time for level '+strr(st));
      if (ba<1) or (ba>1000) then exit;
      se:=getn ('Additional time per level');
      if (se<0) or (se>1000) then exit;
      cn:=st;
      repeat
        setone (cn,ba);
        if ba+se<1000
          then ba:=ba+se
          else ba:=1000;
        cn:=cn+1
      until cn>en
    end;

  var k:char;
  begin
    setblock (b,1,1,80,25);
    readblock (b,buffer);
    refresh;
    repeat
      repeat
        gotoxy (1,24);
        write ('Enter the # to Change, "P"attern, "Q"uit: ');
        clreol;
        readln (input)
      until length(input)>0;
      k:=upcase(input[1]);
      n:=valu(input);
      if (n>=1) and (n<=100) then getone(n) else
        case k of
          'P':pattern
        end
    until k='Q';
    writeblock (b,buffer)
  end;

  procedure showattribhelp;
  var cnt:integer;

    procedure demo;
    begin
      setcolor (cnt);
      write (cnt:2,')',colorstr[cnt],' ')
    end;

  begin
    gotoxy (1,23);
    for cnt:=0 to 7 do demo;
    gotoxy (1,24);
    for cnt:=8 to 15 do demo;
    cn
  end;

  procedure doattrib;
  var cnt,v:integer;
      k:char;
  begin
    v:=valu(inp);
    if ((v=0) and (inp[1]<>'0')) or (v<0) or (v>15) then begin
      v:=-1;
      for cnt:=0 to 15 do if match (inp,colorstr[cnt]) then v:=cnt;
      if v=-1 then exit
    end;
    p.i^:=v
  end;

begin
  t:=things[n];
  pu:=t.p;
  gotopage (whichpage(n));
  y:=whichline(n);
  if not (t.ttype in [tbaudset,tusertime]) then begin
    gotoxy (1,23);
    clreol;
    writeln;
    clreol;
    writeln;
    write (t.descrip);
    clreol;
    gotoxy (1,24);
    case t.ttype of
      tinteger:
        begin
          buflen:=6;
          showintrange
        end;
      tsstr,ttime:buflen:=15;
      tmstr:buflen:=30;
      tlstr,tpath:buflen:=80;
      tboolean,tchar:buflen:=1;
      tattrib:showattribhelp
    end;
    if buflen+dcol>79 then buflen:=79-dcol;
    gotoxy (dcol,y);
    clreol;
    if editit then setdefaultinput (varstr(n));
    readln (inp)
  end else inp[0]:=^A;
  if length(inp)<>0 then
    case t.ttype of
      tinteger:doint;
      tsstr,tmstr,tlstr:dostr;
      tboolean:doboolean;
      tchar:dochar;
      tbaudset:dobaud;
      tpath:dopath;
      ttime:dotime;
      tattrib:doattrib;
      tusertime:dousertime
    end;
  reshow;
  gotoxy (1,23);
  clreol;
  writeln;
  clreol;
  writeln;
  clreol;
  t.p:=pu;
  things[n]:=t
end;

procedure changenum (ns:integer; editit:boolean);
var n:integer;
begin
  n:=ns+top-1;
  if (n<1) or (n>numthings) then exit;
  getinput (n,editit)
end;

procedure maybemakeconfig;
var f:file of configsettype;
    s,w:integer;
begin
  s:=ofs(filler)-ofs(versioncode);
  w:=sizeof(configsettype);
  {if s>w then begin
    writeln;
    writeln ('****** ERROR: CONFIGSETTYPE is too short!');
    writeln ('              Size of configuration is: ',s);
    writeln ('                   Bytes being written: ',w);
    writeln;
    halt
  end;}
  assign (f,'CYANIDE.CFG');
  reset (f);
  if ioresult=0 then begin
    close (f);
    exit
  end;
  fillchar (configset,sizeof(configset),0);
  formatconfig
end;

var command:sstr;
    i:integer;
begin
{ textmode (BW80); }
  initscrnunit;
  curwindowptr^.normalcolor:=normalcolor;
  curwindowptr^.boldcolor:=boldcolor;
  curwindowptr^.barcolor:=barcolor;
  curwindowptr^.inputcolor:=inputcolor;
  curwindowptr^.choicecolor:=choicecolor;
  curwindowptr^.datacolor:=datacolor;
  clrscr;
  gotoxy (1,1);
  writeln ('Loading Configuration, Please Hold!');
  writeln;
  writeln ('Completed: ');
  gotoxy (12,3); write (''); pause;
  gotoxy (13,3); write (''); pause;
  gotoxy (14,3); write (''); pause;
  gotoxy (15,3); write (''); pause;
  gotoxy (16,3); write (''); pause;
  gotoxy (17,3); write (''); pause;
  gotoxy (18,3); write (''); pause;
  gotoxy (19,3); write (''); pause;
  gotoxy (20,3); write (''); pause;
  gotoxy (21,3); write (''); pause;
  gotoxy (22,3); write (''); pause;
  gotoxy (23,3); write (''); pause;
  gotoxy (24,3); write (''); pause;
  gotoxy (25,3); write (''); pause;
  gotoxy (26,3); write (''); pause;
  gotoxy (27,3); write (''); pause;
  gotoxy (28,3); write (''); pause;
  gotoxy (29,3); write (''); pause;
  gotoxy (30,3); write (''); pause;
  gotoxy (31,3); write (''); pause;
  writeln;
  readdata;
  assignptrs;
  maybemakeconfig;
  readconfig;
  i:=ioresult;
  numpages:=whichpage(numthings);
  page:=0;
  gotopage (1);
  repeat
    setfilter (checksnowmode);
    gotoxy (1,24);
    cd; write ('[');
    cs; write ('F1');
    cd; write (']:Edit Entry [');
    cs; write ('F10');
    cd; write (']:Save/Exit [');
    cs; write ('PgUp');
    cd; write (']:Last Page [');
    cs; write ('PgDn');
    cd; write (']:Next Page [');
    cs; write ('Esc');
    cd; write (']:Abort');
    i:=useprompts(prompt);
    if bioslook in [#32..#126]
      then changenum (i,false)
      else case bioskey of
        #187:begin
              gotoxy (1,1);
              write (i);
              changenum (i,true);
             end;
        #196:begin
              writeconfig;
              byebyeii
             end;
        #27:abortyn;
        #13:changenum (i,false);
        #201:gotopage (page-1);
        #209:gotopage (page+1);
      end
  until 0=1
end.
