Welcome to the DB2/2 Service Pak 7015!

To begin, select action from the pull-down menu.

CAUTION: If an existing version of DB2/2 is executing it should be stopped
before applying the service pak.

CAUTION: If you are planning on using DDCS/2 V2 with this version of DB2/2
on the same machine, you must have DDCS/2 SelPak 7011 or later installed.
Otherwise unpredictable results will occur.

CAUTION: For client/server platforms, this service pak should be applied to
both server and client workstations.

CAUTION: Application programs will need to be rebound for some of the changes
to take effect.

NOTE: APAR JR07253 requires that a database or system administrator use Query
Manager to open existing databases so that they will be rebound.

You can browse the readme file here or print it: the file is on diskette 1
(README.DB2)

The topics have been grouped into six categories.  What you'll find in this
readme file:

INSTALLATION
> Starting the installation
> CID installation

THE DB2 FAMILY NEWSLETTER

SUBMITTING SUGGESTIONS TO IBM

WHAT'S CHANGED - APAR DESCRIPTIONS
> Database engine APAR descriptions
> Database Administration Tool APAR descriptions
> DOS Requester APAR descriptions
> Query Manager APAR descriptions

OTHER CHANGES
> Database Manager
> DOS Requester
> Query Manager

QUESTIONS AND ANSWERS





INSTALLATION


To start the Presentation Manager Service Pak install, type DB2FIX.  To begin
the installation select action from the pull down menu.

For DB2/2 CID service pak install, please use the sample response file
DB2FIX.RSP provided on diskette 1.  This file should be modified to fit your
installation needs.

The service pak CID install program (DBFIXCID.EXE) uses the same syntax as the
DB2/2 CID install program.  Refer to the installation guide for a description.

For a description of the CID install key words, refer to Appendix B of the
DB2/2 Installation Guide.  Two keywords have been added to support the
Service Pak install:

> DBEngine  - install the database engine (1=YES 0=NO).
> DBReplace - replaces files on the target system if they have a later
              date/time stamp than the ones shipped with the Service
              Pak (1=YES 0=NO).





THE DB2 FAMILY NEWSLETTER


This is a bi-monthly newsletter that reports the latest news for the family
of DB2 products (DB2 and DDCS on all available platforms: OS2, AIX, MVS...)

If you are interested in receiving this newsletter, please mail or fax
your request to

  IBM Canada Ltd.
  Database Technology Planning
  31/110/895/TOR
  895 Don Mills Rd.
  North York, Ontario
  Canada, M3C 1W3

  Attn: L. G. Pedron
  Fax:  416-448-2114





SUBMITTING SUGGESTIONS TO IBM


If you have any suggestions to enhance our products, there are two
vehicles to communicate your requirements to IBM.

* If your organization has an IBM Representative, discuss your
  requirements with your IBM Representative, and have them submit your
  requirements to the DATABASE TECHNOLOGY PLANNING group at TOROLAB2(DBMREQ).

* Or, send your detailed requirements to the following address:

  IBM Canada Ltd.
  Database Technology Planning
  31/110/895/TOR
  895 Don Mills Rd.
  North York, Ontario
  Canada, M3C 1W3

  Attn: L. G. Pedron
  Fax:  416-448-2114





WHAT'S CHANGED  -  APAR DESCRIPTIONS


The following changes have been made as a result of direct customer feedback.

The fixes include those from Select Paks 7010 and 7012.


Database Engine APAR Descriptions


APAR JR06426 - Referential Integrity Check Error

Before this fix, it was possible for a user creating a foreign key
from one table to another to encounter an error (SQLCODE -632, rc 2) even
though the definition of the referential integrity constraint was
valid.  The verification process for checking for referential integrity
cycles has been fixed to properly identify only those referential integrity
constraints that form a delete connected cycle.


APAR JR06827 - Blocking Selects

This fixes a problem that occurs when you initiate a blocking select
against an SQL/DS database using the command line processor, and then interrupt
the select and issue a second query.  The second query would then return rows
continuing from where the first query ended, rather than starting at the top of
the table.


APAR JR06867 - Running in a LAN security shell

Previously, when running DB2/2 in a LAN security shell, the processes started
by database manager would take their authorizations from the shell rather
than the parent process.  As a result, the processes would not have privileged
status and would soon fail.  This has been changed so that the processes now
inherit the authorization of their parents.

This, however, creates a potential security risk.  If a remote user calls the
SQLEPROC, any dynamic link library files (.DLL) specified in the server library
path will be granted privileged authorization.  These files can then execute
any operations allowed with a privileged status.  Hence, you must be cautious
in choosing the dynamic link library files in your libpath.


APAR JR06918 - Message Tokens

Message tokens are now being properly supplied for sqlcodes -1113, -1114,
and -1115.  Previously the tokens were missing from these messages.


APAR JR06964 - BETWEEN Predicates with Character Host Variables

Previously, if character host variables were used as limit values for BETWEEN
predicates, incorrect results (wrong number of rows) could be returned
when an index ORing plan was selected.  Such queries will now return correct
results.


APAR JR06975 - Guest ID support not allowed

The LAN server product supports guest accounts. This means that a user can
log on to the server without having the USERID explicitly defined in UPM.  The
user is then given the same access as the guest userid.  The database manager,
however, does not support guest accounts.

If a workstation is configured as both a database manager server and a LAN
server, guest accounts will not be supported by the database manager.  If the
user attempts to log on to DB2/2 using the guest account, a message will be
displayed indicating that the logon failed.  The user will be prompted again for
another USERID and password.  If the user is already logged on (to the LAN) as
the guest USERID, the user will be prompted to logon using another USERID.


APAR JR06984 - Incorrect results on Query with Joins

Incorrect results were returned for a query that performed a join on two
views, where the views were based on queries that contain subqueries with
correlated references.  The problem has been corrected.


APAR JR07076 - Referential Integrity Trap

This fix corrects a problem related to the referential integrity checking
during insertion using a SELECT clause.  If the primary and foreign keys were
DATE/TIME types, and the data being inserted into the foreign key was a
character string, the character data was not converted to the DATE/TIME type
before the referential integrity constraint was checked.  This could result
in a trap or incorrect results.


APAR JR07102 - Backwards Table scan

During a backwards table scan, it was possible that an incorrect number of
rows would be returned when there were gaps (deletions)
among the slots of the table.  The problem has been corrected.


APAR JR07196 - Communication Performance

Client/Server communications performance via NetBIOS is slower when receiving
data on clients or servers.

To improve the performance, the receive processing has been redesigned
on both the client and the server.


APAR JR07196 - Thread Termination

When using NetBIOS, the DB2/2 cleanup thread can terminate prematurely.
All client/server operations continue to operate normally, however, and
users will not notice any symptoms.

The situation has been changed so that the thread will no longer terminate.


APAR JR07196/JR07197 - NetBIOS Communication Error

When connecting to a DB2/2 server, if the first data block arrives
at a NetBIOS client before the session is fully established, the client
will receive a 30080 000a message, and the attempt to connect to the server
fails.

The connection and first receive are now sequenced to
ensure that the agent cannot proceed with the first receive until the
connection has been completely established.


APAR JR07198 - Stopdbm Hang

STOP USING DATABASE followed by STOPDBM causes a session hang
when using the Application Program Interface.

The code has been fixed to ensure that the processes involved in the
STOP USING DATABASE and the STOPDBM will not compete for
the same resources to cause the deadlock.


APAR JR07282 - MicroFocus Cobol Applications

If an application was compiled using 16-bit Microfocus Cobol, it could
experience a floating point inexact exception during the connection to a
dtabase.  This exception will no longer occur.


APAR JR07300 - FFST Trap

When DB2/2 encounters an error, it calls FFST to log the error.  FFST
requires a lot of stack which in turn traps the application.

To fix this problem, DB2/2 now provides a larger stack for the application
to use while inside the engine.


APAR JR07310 - MAXLOCKS

If MAXAPPLS is set to greater than 100, then MAXLOCKS is always set to one.
This has been changed so that the user can alter the maxlocks value.

However, in order to avoid excessive numbers of deadlocks, as you increase
MAXAPPLS, you should decrease MAXLOCKS.


APAR JR07324 - Invalid Records

Formerly, when a record was fetched that was not a user type, it was assumed
to be a control record.
Now, the record type is checked to ensure it is valid.  If it is not, a
-902 "25" error message will be returned.


APAR JR07368 - Remote Client Hang

If a server had either

* one physical LAN adapter installed and logically assigned as adapter 1; or
* two physical adapters installed with only adapter 1 specified for use
  by DB2/2 (i.e. SQLNADPT=1),

remote clients would hang when trying to connect to the database.  Now, any
combination of valid logical and/or physical adapters and SQLNADPT values will
allow successful remote database connection and communication.


APAR JR07373 - BACKUP/RESTORE From a Privileged Window

If a LAN administrator had started a privileged window and a "normal" user
attempted to backup or restore a database in that window, the backup/restore
would fail.  These operations will now succeed in this situation.


APAR JR07387 - Trap E

It was possible to get a trap E when using DB2/2 on a machine which was close
to the end of its memory.  This trap will no longer occur.


APAR JR07388 - Vendor Application State

Previously, if a vendor application was being used with DB2/2, it was left
to the application to keep track of it's state.  However, as many of the
applications did not do this, DB2/2 has been modified to check the state of the
application when the SQLDCSR API is called.


APAR JR07408 - SQLVAR verification

When a literal string was passed as data to the input SQLDA, the input SQLDA's
SQLVARs were being verified for READ/WRITE access when they should only have
been verified for READ access.  This also occurred for an input "C
Nul-terminated string".  In these cases, the SQLVARs will now only be verified
for READ access.


APAR JR07418 - Memory Failure

This fix corrects a potential memory failure when a REORG is performed on a
table with small physical files.


APAR JR07430 - OS/2 2.1 - START USING DATABASE Returns -1042

When using OS/2 2.1, if a START USING DATABASE was called from within a DLL
initialization routine, the operating system would return a new return code that
DB2/2 did not anticipate.  As a result, the START USING DATABASE would return
with an SQLCODE of -1402.  DB2/2 will now recognize the new return code.


APAR JR07438 - GET DATABASE STATUS

The REXX SQL returned a value of 65535 into a REXX stem variable XXX.1 when
a GET DATABASE STATUS USING :XXX command was passed to the external
function SQLDBS.  This has been corrected to return a value of -1 when no
database status is returned.


APAR JR07439 - Applications with no SQL Statements

In DB2/2, when a bind file containing no SQL statements was bound to the
database, a package was not created.  A fix has been implemented so that
a package will be created.


APAR JR07453 - SQLCODE -902 from SQLRASSM

An incorrect SQLCODE -902 was returned from the function SQLRASSM when executing
a large SQL statement.  This has been corrected.


APAR JR07659 - Trap in UPDATE.SQB

Previously, if the UPDATE.SQB file (included in samples.zip) was compiled
with Microfocus Cobol v 3.1, the UPDATE.EXE program would trap.  The BLDCOB.CMD
file has been altered so that this will no longer occur.





Database Administration Tools APAR Descriptions


APAR JR07468 - Recover Database with REPLACE EXISTING Option

Previously, when a user tried to recover a database from a backup using
the REPLACE EXISTING option, the drive D was not listed in the drop down
combination box for the source drive.  This has been altered so that the drive
letter of the selected database will not be shown in the source drive drop down
combination box.





DOS/WINDOWS Requester APAR Descriptions


APAR JR05949 - SQLWARN0

The SQLWARN0 indicator is now set as documented when accessing Database
Manager from a remote application.





Query Manager APAR Descriptions


APAR JR06270 - Premature Termination when using Panels

This fixes a problem that causes Query Manager to terminate unexpectedly.
The problem occurs when you change the size of a repeated rows field in a panel
where the field has a one to many relationship (Only on 8515 monitors).

Under OS/2 2.0 there is a formatting problem with repeated rows
on the 8515 monitor.  This problem, as well as the unexpected Query Manager
termination can be corrected by installing OS/2 corrective Service Pak 6055.


APAR JR06371 - Negative Zeros (-0)

In Extended Services 1.0, it is possible to get a result of -0 when
subtracting two decimal columns with the same value.  This fix corrects the
problem and is applicable whether the database was migrated from OS/2 Extended
Edition 1.3 or created under Extended Services 1.0.


APAR JR06499 - Numeric Global Variables

A Query Manager GLOBAL variable was not displayed in the PROMPT field of
a VARIABLE name associated with a MENU ACTION ITEM if the GLOBAL variable was
set to a numeric value.  These variables will now be correctly displayed.


APAR JR06684 - Premature termination using list boxes

Query Manager has been corrected to prevent termination in situations where no
items in a list box are selected  and the cursor has been scrolled off the
screen.


APAR JR06851 - Dutch Translation Error

In the Dutch language version, default and ascending indexes were shown as
'Dalend', which is Dutch for descending.  This has been corrected.


APAR JR06882 - Exceptions when using Callable Interface

This fix corrects a problem where Query Manager incorrectly releases
storage in a process where the callable interface is being used from a REXX
procedure. One symptom of the problem is an addressing exception in some
non-Query Manager piece of code running in the same process.


APAR JR06913 - Report Text Length

This fix corrects a problem where the maximum length of report text was
reduced by one character for each variable inserted in the text.  The condition
is fixed in all of the report text fields. (page heading text, break heading
text, etc.)


APAR JR06969 - Index Display of Column Names

This fix corrects the problem where a column name is truncated to 15-1/2
when using the 'Show Index' function.


APAR JR06986 - TAB/Arrow Keys in Procedures

TAB and arrow keys now work as intended in message boxes created by the
SAY command.


APAR JR07179 - Package Name For Query Manager in DB2/2

Formerly, all levels and versions of Query Manager used the same package
name when binding to a database.  However, because of the different dates on
the bind files for Extended Services 1.0 and DB2/2, a rebind was required
each time a client of one type accessed a database following a client of the
other type.  Consequently, unless the user(s) had database administrator
authority, they were allowed to perform the rebind.  Thus, in an
environment with a mix of Extended Services 1.0 and DB2/2 clients, users could
be denied access to Query Manager.

This problem is fixed by using different package names for different versions
of Query Manager.  The files:

* qrwn.dll
* qrw3*.bnd  (8 files)

should be applied to every DB2/2 client and server on the system.  Omitting
even one client will cause the problem to reoccur if that client is allowed to
connect to the database.


APAR JR07253 - Accessing Views from a Remote Client

If Query Manager was used to access a database on a server, a user that had
implicit access to a view but no access to the underlying base tables would
not have the view presented to them in the tables and views panel.  The user
will now be able to see the view.

This fix requires that a database or system administrator use Query Manager
to open existing databases so that they can be rebound.  Once rebound,
Query Manager will work correctly for other users.


APAR JR07278 - Large Numbers of Query Manager Variables

This fix corrects problems which are caused when a large number of Query
Manager variables have been set.  The problems could materialize in different
ways, but a memory addressing trap was the most likely result.


APAR JR07400 - Query Manager Icon Titles

Query Manager has been updated so that when the Icon title has been customized
by the user, the customized title will appear on the title line and under the
minimized icon if there is adequate space available.





OTHER CHANGES


DATABASE MANAGER

Explain Support for Numeric Scalars

The Explain tool now supports numeric scalars.


DOS\WINDOWS REQUESTER

DOS\WINDOWS applications using Japanese Code pages

It is now possible to have DOS and DOS Windows client applications running on
Japanese code page 932 connect to DB2/2 server databases created with the
Japanese code page 942.


QUERY MANAGER

Large Output Queries

Query Manager has been changed to display an error message when it runs out
of disk space on its 'working' drive while doing a 'save data' operation.  The
data produced by the query is no longer available following this condition.
The user should free some additional space on the working drive and run the
query again.





QUESTIONS AND ANSWERS


Q: I'm migrating from ES 1.0 to DB2/2 and received message
"SQL5122N: Access to the database was invalid because of a machine
dependent check".  What is the cause?

A: The database and database configuration file cannot be
accessed because of copy protection.  To correct this error, return to the
original database and modify the database configuration to turn the copy
protection off, then create a new backup which may be used to restore the
database.

Q: What do I look for if my application ABENDED while connected to a database?

A: Look for a .TRP file in the x:\SQLLIB directory, where x is the
installation drive for DB2/2.  This file is created when DB2/2 ABENDs.
The file contains the user's stack and current register information.  Using
this information you should be able to find the problem.  If you are unable to
resolve the condition phone IBM support.

Q: What are the recommended trace settings for DB2/2?

A:
>sqltrc on -l 1000000 -e 10
>sqltrc dump trace.dmp
>sqltrc fmt trace.dmp trace.fmt

This procedure will create a 1 MB trace file which is used by IBM support
to help resolve any DB2/2 problems.  The TRACE.FMT file will be an ASCII
file with DB2/2 activity recorded during the problem recreation.

Q: I have printing problems after installing DB2/2 on OS/2 2.1.  I lose the
ability to print any file to a printer.  The file goes to the PM print spooler.
What is wrong?

A: As documented in the OS/2 2.1 README file, you must REMark the
RUN=C:\OS2\EPW.EXE and DETACH C:\OS2\EPWROUT.EXE 1 statements out of
the config.sys files and the DETACH C:\OS2\EPW.EXE and
DETACH C:\OS2\EPWROUT.EXE -1 statements out of the startup.cmd file.  DB2/2
will install the FFST/2 code (EPW) and update your config.sys file.

Q: When using DB2/2 with the Lotus Datalens product, I receive the following
message when attempting to connect to a DB2/2 database:

  Error Code sql0804N and you are unable to connect.

What is wrong?

A: Lotus 1-2-3 for OS/2 has a driver called DATALENS that allows you to bring
data from a database into your spreadsheet.

This is a known problem with the Lotus Datalens product.  The fix should
be available from your local Lotus Technical Support centre in a SLIPSTREAM
driver package by the end of August 1993.

