program celstat;

uses dos,tpdate,records;


type

     mstr=string[30];



type
     realarray = array [1..7] of real;
     stringarray = array [1..7] of string;


const
  maxnodes = 15;
  linelen = 41;

var
  nodepercent : array [1..maxnodes] of realarray;
  nodetime : array [1..maxnodes] of stringarray;
  callerlog : file of logrec;
  year,month,day: integer;
  byear,bmonth,bday: integer;
  currentlog : logrec;
  logdate : datetime;
  yesterday,daybefore : date;
  i,l : integer;
  nodestr : string[2];
  ext : string[3];
  maxcalls : integer;
  linediv2 : real;
  linediv : integer;
  line : string[linelen];
  spacespace : string[2];
  outfile : text;
  space2 : string;
  datestr : string;
  position : word;
  beg_count : boolean;
  temptime,outtime,newtime : time;
  diffhour,diffmin,diffsec : byte;
  totalhour,totalmin,totalsec : longint;
  totaltime : time;
  timestring : string;
  totaltimesec : longint;
  percent : real;
  percents : string;
  percentint : integer;
  datafile : text;
  nodedir : string;
  numofnodes : integer;
  intday : integer;
  daycount,k,numofdays : integer;
  dirinfo : searchrec;



begin
  if paramstr(3) = '' then begin
    writeln('command line: CELSTAT path_to_data_dir filename_of_outputfile num_of_days_to_go_back');
    writeln;
    writeln('example: CELSTAT c:\celerity\data\ c:\celerity\bulletin\celstat.out 1');
    writeln;
    halt(1);
   end;
  space2 := paramstr(3);
  val(space2,numofdays,percentint);
  space2 := paramstr(1);

  numofnodes := 0;
  while true do
  begin
  inc(numofnodes);
  str(numofnodes,ext);
  assign(callerlog,space2+'syslog.'+ext);
  {$I-}
  reset(callerlog);
  {$I+}
  if ioresult <> 0 then
    break;
  position := filesize(callerlog);
  beg_count := true;
  totaltime := HMStoTIME(0,0,0);
  totalhour := 0;
  totalmin := 0;
  totalsec := 0;
  daycount := 1;
  while (position > 1) and (daycount <= numofdays) do
   begin
    yesterday := incdate(today,(daycount * (-1)),0,0);
    daybefore := incdate(today,((daycount+1) * (-1)),0,0);
    datetodmy(yesterday,day,month,year);
    datetodmy(daybefore,bday,bmonth,byear);
    datestr := datetodatestring('mm/dd/yy',yesterday);
    dec(position);
    seek(callerlog,position);
    read(callerlog,currentlog);
    unpacktime(currentlog.when,logdate);
    if (year = logdate.year) and (month = logdate.month) and (day = logdate.day) then
     begin
      if beg_count then
       begin
         outtime := HMStotime(logdate.hour,logdate.min,logdate.sec);
         beg_count := false;
         continue;
       end;
        if (currentlog.menu = 0) and (currentlog.subcommand = 0) then
         begin
            newtime := HMStotime(logdate.hour,logdate.min,logdate.sec);
            TimeDiff(outtime,newtime,diffhour,diffmin,diffsec);
            totaltime := inctime(totaltime,diffhour,diffmin,diffsec);
            totalhour := totalhour + diffhour;
            totalmin := totalmin + diffmin;
            totalsec := totalsec + diffsec;
            dec(position);
            seek(callerlog,position);
            read(callerlog,currentlog);
            unpacktime(currentlog.when,logdate);
            outtime := HMStotime(logdate.hour,logdate.min,logdate.sec);
         end
        else
            temptime := HMStotime(logdate.hour,logdate.min,logdate.sec);
     end;
      if (year > logdate.year) or (month > logdate.month) or (day > logdate.day) {or (eof(callerlog))} then
        begin
            TimeDiff(temptime,newtime,diffhour,diffmin,diffsec);
            totaltime := inctime(totaltime,diffhour,diffmin,diffsec);
            totalhour := totalhour + diffhour;
            totalmin := totalmin + diffmin;
            totalsec := totalsec + diffsec;
            nodetime[daycount][numofnodes] := timetotimestring('hh:mm:ss',totaltime);
            totaltimesec := (totalhour * 60 * 60 ) ;
            totaltimesec := totaltimesec + (totalmin * 60);
            totaltimesec := totaltimesec + totalsec;
            nodepercent[daycount][numofnodes] := ((totaltimesec / 86400));
            inc(daycount);
            beg_count := true;
            totaltime := HMStoTIME(0,0,0);
            totalhour := 0;
            totalmin := 0;
            totalsec := 0;
         end;
     end;
     close(callerlog);
  end;



  assign(outfile,paramstr(2));
  rewrite(outfile);
  writeln(outfile,'Ŀ');
  writeln(outfile,'                         Histogram of node activity                          ');
  writeln(outfile,'Ĵ');
  writeln(outfile,'                                                                             ');
  for k := 1 to numofdays do
  begin
  yesterday := incdate(today,(k * (-1)),0,0);
  datestr := datetodatestring('mm/dd/yy',yesterday);
  for i := 1 to  (numofnodes-1) do
   begin
     str(nodepercent[k][i]*100:3:0,percents);
     linediv := round(nodepercent[k][i] * linelen);
     if linediv < 1 then
       linediv := 1;
     line := '';
     line := copy(line,1,linediv);
     str(i,nodestr);
     if i < 9 then
       spacespace := '  '
     else
       spacespace := ' ';
     space2 := '';
     for l := 1 to (42 - linediv) do
       space2 := space2 + ' ';
     if nodetime[k][i] = '' then
       nodetime[k][i] := '00:00:00';
     writeln(outfile,' '+datestr+ ' Node ['+nodestr+']'+spacespace+nodetime[k][i]+' '+percents+ '%  ' + line + space2 + '');
   end;
   end;

writeln(outfile,'                                                                             ');
writeln(outfile,'');
writeln(outfile);
close(outfile);




end.


