/* 
WINTASK.C
*/ 
 
#include <stdlib.h> 
#include <string.h>
#include <dos.h> 
#include <pharlap.h>
#include "wintask.h" 
 
#define CLEAR(x)    memset(&x, 0, sizeof(x)) 
 
unsigned VMId(void) 
{ 
    SWI_REGS r; 
    CLEAR(r); 
    r.eax = 0x1683; 
    _dx_real_int(0x2f, &r);
    return r.ebx & 0xFFFF;  // VM# returned in BX 
} 
 
void BeginCriticalSection(void) 
{ 
    SWI_REGS r; 
    CLEAR(r); 
    r.eax = 0x1681; 
    _dx_real_int(0x2f, &r);
} 
 
void EndCriticalSection(void) 
{ 
    SWI_REGS r; 
    CLEAR(r); 
    r.eax = 0x1682; 
    _dx_real_int(0x2f, &r);
} 

void Yield(void)
{
    SWI_REGS r;
    memset(&r, 0, sizeof(r));
    r.eax = 0x1680;
    _dx_real_int(0x2f, &r);
    return;
}

int win3e(int *pmaj, int *pmin) 
{ 
   SWI_REGS regs;

   memset(&regs, 0, sizeof(regs));
   regs.eax = 0x1600;
   _dx_real_int(0x2f, &regs);
   *pmaj = regs.eax & 0xff;
   *pmin = (regs.eax >> 8) & 0xff;
   return (*pmaj > 1 && *pmaj != 0x80);
} 

