/* 
TASKTEST.C
*/ 
 
#include <stdlib.h> 
#include <stdio.h> 
#include <time.h> 
#include "wintask.h" 
 
void wait(int seconds) 
{ 
    time_t t1, t2; 
    time(&t1); 
    while ((time(&t2)-t1) < seconds) 
        Yield(); 
} 
 
void fail(char *s) { puts(s); exit(1); } 
 
main() 
{ 
    int dummy; 
    if (! win3e(&dummy, &dummy)) 
        fail("This program requires Windows 3.0 Enhanced mode"); 
    printf("VM Id: %u\n", VMId()); 
    fputs("You should be able to switch to another task...", stdout);
    fflush(stdout);
    wait(5);  // give user chance to switch to other task 
    puts("done\n"); 
    fputs("In critical section; can't switch tasks...", stdout); 
    fflush(stdout); 
    Yield();  // Yield so task that produces output gets to run! 
    BeginCriticalSection(); 
    /* No other Windows tasks can run; also can't switch  
       away with mouse or ALT ESC or CTRL ESC! */ 
    wait(5); 
    EndCriticalSection(); 
    /* Now other tasks can run; can also switch away again */ 
    puts("done\n"); 
    return 0; 
} 
