/* 
POKE_OFS.C -- poke video display memory one million  
times, using Phar Lap Map Physical Memory at End of 
Segment (INT 21h AX=250Ah) call
*/ 
 
#include <stdlib.h> 
#include <stdio.h> 
#include <string.h>
#include <dos.h> 
#include <time.h> 
#include <pharlap.h>
 
#define MAX 1000000 
 
void fail(char *s) { puts(s); exit(1); } 
 
main() 
{ 
    CONFIG_INF config;
    UCHAR buf[256];
    unsigned short *p;  /* NEAR pointer */ 
    time_t t1, t2; 
    unsigned i; 
     
    _dx_config_inf(&config, buf);
    // map 4k at b800:0000
    if (_dx_map_phys(config.c_ds_sel, 0xb8000, 1, (ULONG *) (&p)) != 0) 
        fail("can't map physical memory"); 
    time(&t1); 
    for (i=MAX; i--; ) 
        p[i%2000] = i; 
    time(&t2); 
    printf("\n\n%u POKE_OFS/second (%u seconds)\n",  
        MAX/(t2-t1), t2-t1); 
    return 0; 
} 
 
