/* 
POKEB800.C -- poke video display memory 1 million times
*/ 
 
#include <stdlib.h> 
#include <stdio.h> 
#include <dos.h> 
#include <time.h> 
#include <pharlap.h>
 
#define MAX 1000000 
 
main()
{ 
    FARPTR basep;
    FARPTR fp;
    time_t t1, t2; 
    unsigned i; 
 
/*  Either of the following techniques will work. */     
#if 1 
/*  Selector 1Ch maps physical memory for the screen, and is 
    automatically updated by 386|DOS Extender any time the 
    BIOS Set Video Mode call (INT 10h AH=0) call is made. */ 
 
    FP_SET(basep, 0, 0x1c);
#else 
/*  Selector 34h maps the entire first megabyte of memory:   
    real mode pointers such as B800:0000 become offsets into 
    this large 32 bit segment. */ 
 
    FP_SET(basep, 0xb8000, 0x34);
#endif 
 
    time(&t1); 
    for (i=MAX; i--; ) 
    {
	FP_SET(fp, FP_OFF(basep) + (i%2000)*2, FP_SEL(basep));
	PokeFarWord(fp, (USHORT)i);
    }
    time(&t2); 
    printf("\n\n%u POKEB800/second (%u seconds)\n",  
        MAX/(t2-t1), t2-t1); 
    return 0; 
} 
