#include <windows.h>
#include <process.h>
#include <stdio.h>
#include <conio.h>

/* global declarations */
#define STACK_SIZE 4096
void get_input (int *);
char ch;
HANDLE hEvent;

#define UPPER  1
#define LOWER  2
#define EITHER 3

void main ()
{
    DWORD dwEvent;
    int   convert;

//  create the event object
    hEvent = CreateEvent(
                   NULL,   // no security attributes
                   FALSE,  // auto-reset event object
                   FALSE,  // initial state is non-signaled
                   NULL);  // unnamed event
    if (hEvent == NULL)
       {
            printf("Error creating event object");
            exit(1);
       }
    convert = EITHER;
    _beginthread(get_input, STACK_SIZE, &convert);

//  other processing not dependent on ch
//  in a larger application, this would be a good place to do 
//  initialization and background processing


//  make sure get_input() thread has updated ch

    dwEvent=WaitForSingleObject(hEvent, INFINITE);
    printf("Hello, world -- you entered the character %c\n",ch);

    _endthread(); //terminate all threads

}

void get_input(int *convertp)
{
    cputs("Type any character\n");
    while ( !_kbhit() );
    ch = getch();
    switch (*convertp)
    {
         case UPPER :  ch = toupper(ch);
                       break;
         case LOWER :  ch = tolower(ch);
                       break;
         case EITHER : break;
         default     : printf("invalid case conversion switch\n");
    }

    // signal availability of ch
    SetEvent(hEvent);
}

