#include <stdio.h>
#include <time.h>

extern long total_time; /* Total execution time */

extern long time_pc286;	/* 286 PC total */

FILE *res_fiop = {0};		/* Result file pointer */


/*

open_resf - Open a result file

*/

void open_resf(argc, argvp)

int argc;		/* Argument count */
char **argvp;		/* Argument vector pointer */

{

	res_fiop = 0;
	if(argc < 2)
		return;
	res_fiop = fopen(*(argvp + 1), "w");
	if(!res_fiop)
	{
		printf("Cannot open result file.....\n\n");
	}
	
	return;

}




/*

DoBench - Do a benchmark

*/

long DoBench(strp, liters, funcp, initfuncp, EOL)

char *strp;			/* Pointer to benchmark name */
long liters;			/* Number of iterations */	
int (*funcp)();			/* Pointer to benchmark function */
int (*initfuncp)();	        /* Pointer to benchmark function */

{

	long stime;		/* Start time */
	clock_t etime;		/* End time */
	clock_t time;		/* Elapse time */

	printf("%-22s  %6ld  ", strp, liters);
	if(res_fiop)
		fprintf(res_fiop, "%-18s", strp);
	(*initfuncp)();
	stime = clock();
	(*funcp)();
	etime = clock();
	time = etime - stime;
	total_time += time;
	print_time(time);
	if(EOL)
	{
		printf("\n");
		if(res_fiop)
			fprintf(res_fiop, "\n");
	}
	return time;

}


/*

DoTotals - Print total execution time and Performance index 

*/

DoTotals()

{

	long pi;		/* Performance index times 100 */
	long temp;		/* Temp. which holds total_time
				   converted to 1/100 */

	temp = total_time;
	if(CLK_TCK > 100)
		temp = temp / (CLK_TCK / 100);
	else
		temp = temp * (100 / CLK_TCK);
	pi = (time_pc286 * 100L) / temp;

#if 0
printf("total_time=%ld, temp=%ld, time_pc286=%ld, pi*100=%ld\n",
        total_time, temp, time_pc286, pi);
#endif

	printf("                                -------\n");
	if(res_fiop)
		fprintf(res_fiop, "                  -------\n");
	printf("Total execution time            ");
	if(res_fiop)
		fprintf(res_fiop, "Total time        ");
	print_time(total_time);
	printf("    Performance index -- <<%ld.%02ld>> *\n", pi / 100, pi % 100);
	if(res_fiop)
	{
		fprintf(res_fiop, "\n%ld.%02ld\n",
		       pi / 100, pi % 100);
	}
	printf("\n");
	printf("*  The performance index gives the number of times faster\n");
	printf("   this machine runs compared to an 80286 PC (6 Mhz)\n");
	printf("\n");

}


/*

print_time - Print execution time

*/

print_time(time)

clock_t time;		/* Time in CLK_TCK units */

{

	int secs;		/* Seconds */
	int hunds;		/* 1/100 seconds */
	clock_t temp;		/* Temporary */

	secs = time / CLK_TCK;
	temp = time;
	if(CLK_TCK > 100)
		temp = temp / (CLK_TCK / 100);
	else
		temp = temp * (100 / CLK_TCK);
	hunds = temp % 100;
	printf("<<%4d.%02d secs>>", secs, hunds);
	if(res_fiop)
		fprintf(res_fiop, "%4d.%02d secs", secs, hunds);

}
