/* MYDLL.C */

#define _DLL	// to turn on efficient function import for printf for Msoft 
		// Visual C++

#include <stdio.h>
#include <pharlap.h>
#define DLL_PROCESS_DETACH 0    
#define DLL_PROCESS_ATTACH 1    

_declspec(dllimport) int GlobVal;
_declspec(dllexport) int GetDllVal(int Val);

int DerefInt(int *pInt);
void WriteStr(char *pStr);

ULONG __stdcall DllEntryPoint(void *hDll, ULONG Reason, void *Reserved)
{
	if (Reason == DLL_PROCESS_ATTACH)
	{
		// can't call C library routine (like printf) during process
		// attach:  C library hasn't initialized yet!!
		WriteStr("MYDLL: Process attach\r\n$");
	}
	return TRUE;
}

int GetDllVal(int Val)
{
	if (Val == GlobVal)
		printf("Value passed to GetDllVal same as imported value\n");
	else
		printf("Error in GetDllVal:  passed value = %d, imported "
			"value = %d\n", Val, GlobVal);

	// test taking address of imported variable
	return DerefInt(&GlobVal);
}

int DerefInt(int *pInt)
{
	return *pInt;
}

void WriteStr(char *pStr)
{
	_asm {
		push	edx
		mov	edx,pStr
		mov	ah,9
		int	21h
		pop	edx
	}
	return;
}
