/* MYDLL.C */

#include <stdio.h>
#include <pharlap.h>
#define DLL_PROCESS_DETACH 0    
#define DLL_PROCESS_ATTACH 1    

//
// For imported data, we redefine the imported name with the
// -import switch when linking, and then use a macro to dereference the
// imported name to get to the real variable.
//
#define IMP_PREFIX(VarName) imp_##VarName
#define IMPVAR(varname, type) \
                        (***(type ***)((UCHAR *)(&IMP_PREFIX(varname)) + 2))

extern int IMP_PREFIX(GlobVal);
#define GlobVal IMPVAR(GlobVal, int)

int GetDllVal(int Val);
int DerefInt(int *pInt);
void WriteStr(char *pStr);

ULONG __stdcall DllEntryPoint(void *hDll, ULONG Reason, void *Reserved)
{
	if (Reason == DLL_PROCESS_ATTACH)
	{
		// can't call C library routine (like printf) during process
		// attach:  C library hasn't initialized yet!!
		WriteStr("MYDLL: Process attach\r\n$");
	}
	return TRUE;
}

int GetDllVal(int Val)
{
	if (Val == GlobVal)
		printf("Value passed to GetDllVal same as imported value\n");
	else
		printf("Error in GetDllVal:  passed value = %d, imported "
			"value = %d\n", Val, GlobVal);

	// test taking address of imported variable
	return DerefInt(&GlobVal);
}

int DerefInt(int *pInt)
{
	return *pInt;
}
