/* 
PVIDEO.C -- protected mode program to poke video display memory 
            1 million times using a real mode FAR pointer.
*/ 
 
#include <stdlib.h> 
#include <stdio.h> 
#include <dos.h>
#include <pldos32.h>
#include <pharlap.h>

#ifdef __WATCOMC__
#define _REGS REGS
#define _int86 int386
// Names of regs in _REGS union are nonstandard
#define ax eax
#endif

#define MAX 1000000L
 
unsigned short GetVidSeg(void);

int main()
{ 
    unsigned short VidSeg;
    REALPTR pVid;
    FARPTR fp;
    long i; 

//
// Get real mode paragraph addr of video memory, and use it to construct
// a real mode FAR pointer to video memory.
//
    VidSeg = GetVidSeg();
    if (VidSeg == 0)
    	return 1;
    RP_SET(pVid, 0, VidSeg);

 //
 // Poke video memory MAX times
 //
    for (i=MAX; i--; ) 
    	PokeRealWord(pVid + (i % 2000)*2, (USHORT) i);

    return 0; 
} 

unsigned short GetVidSeg(void)
{
    char VidMode;
    char ActivePage;
    union _REGS r;

//
// Get video mode
//

    r.h.ah = 0xF;
    _int86(0x10,&r,&r);
    VidMode = r.h.al;
    ActivePage = r.h.bh;

//
// This simple program only supports video page 0, 80x25 text modes
//
    if (ActivePage != 0)
    {
    	printf("Only video page 0 is supported\n");
	return 0;
    }
    if (VidMode == 7)
    	return (unsigned short) 0xB000;	// monochrome
    else if (VidMode == 2 || VidMode == 3)
        return (unsigned short) 0xB800;
    else
    {
    	printf("Only 80x25 text modes are supported\n");
	return 0;
    }
}
