//
// EXCEP.C -- Sample structured exception handler.
//            Detects NULL pointers passed to strcpy().
//            Link this program with -OFFSET 1000h so NULL pointer references
//            will cause a page fault exception.
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <excpt.h>

char *SafeStrcpy(char *dstp, char *srcp);

int main()
{
	char	buf[256];

	if (SafeStrcpy(buf, "string1") == NULL)
		printf("First call to SafeStrcpy failed!\n");
	else 
		printf("Buffer contains: %s\n", buf);

	if (SafeStrcpy(buf, NULL) == NULL)
		printf("Second call to SafeStrcpy failed!\n");
	else
		printf("Buffer contains: %s\n", buf);

	return 0;
}

char *SafeStrcpy(char *dstp, char *srcp)
{
	__try
	{
		return strcpy(dstp, srcp);
	}
	__except (EXCEPTION_EXECUTE_HANDLER)
	{
		return NULL;
	}
}
