//
// REALVECS.C -- Print out real mode interrupt vector table
//
#include <stdio.h>
#include <pharlap.h>
int main()
{
	REALPTR pRealVecs;
	REALPTR RealVec;
	int i;

//
// Print out the first 40 real mode interrupt vectors from the 
// real mode interrupt table located at real mode address 0:0
//
	RP_SET(pRealVecs, 0, 0);
	for (i = 0; i < 40; ++ i, RP_INCR(pRealVecs, 4))
	{
		RealVec = PeekRealDWord(pRealVecs);
		printf("INT %02Xh:  %04X:%04X\n", i, RP_SEG(RealVec),
							RP_OFF(RealVec));
	}
	return 0;
}
