//
// PRINTENV.C -- Print the environment strings
//
#include <stdio.h>
#include <string.h>
#include <pharlap.h>
int main()
{
	CONFIG_INF config;
	UCHAR buf[256];
	FARPTR pEnv;

//
// Read the strings from the environment segment in a 
// compiler-independent fashion.
//
	_dx_config_inf(&config, buf);
	FP_SET(pEnv, 0, config.c_env_sel);
	printf("Environment strings:\n");
	while (PeekFarByte(pEnv) != 0)
	{
		ReadFarString(buf, pEnv);
		printf("   %s\n", buf);
		FP_INCR(pEnv, strlen((const char *)buf) + 1);
	}
	return 0;
}
