//
// NTPRENV.C -- Print the environment strings
//              using the NtStyle interface
//
#include <stdio.h>
#include <string.h>
#include <windows.h>
int main()
{
    LPVOID pEnv;
    LPTSTR charptr;

//
//  This code takes advantage of knowing that the environment variable
//  strings are separated by a NULL byte and the block is terminated by a
//  NULL byte.
//
//  The Windows NT documentation states that you should NOT use the 
//  return value from GetEnvironmentStrings() to get or set environment
//  variables.  However, the [Get|Set]EnvironmentVariable() functions
//  require that you know the name of the variable you want to get or
//  set.  Be warned if you use this code.

    pEnv = GetEnvironmentStrings();
    printf("Environment strings:\n");

    for (charptr = (LPTSTR) pEnv; *charptr; charptr++)
        {
            printf("   ");
            while (*charptr)
                putchar(*charptr++);
            putchar('\n');
        }

    return 0;
}
