//
// MIXPRENV.C -- print environment strings
//               dynamically determine if TNT DOS-Extender is running
//               use DosStyle interface if TNT is running
//               otherwise use NtStyle interface
//

#include <stdlib.h>
#include <stdio.h>
#include <pharlap.h>
#include <windows.h>

void DosStyle()
{
	CONFIG_INF config;
	UCHAR buf[256];
	FARPTR pEnv;

//
// Read the strings from the environment segment in a 
// compiler-independent fashion.
//
	_dx_config_inf(&config, buf);
	FP_SET(pEnv, 0, config.c_env_sel);
	printf("Environment strings DosStyle calls:\n");
	while (PeekFarByte(pEnv) != 0)
	{
		ReadFarString(buf, pEnv);
		printf("   %s\n", buf);
		FP_INCR(pEnv, strlen((const char *)buf) + 1);
	}
	return;
}

void NtStyle()
{
    LPVOID pEnv;
    LPTSTR charptr;

//
//  This code takes advantage of knowing that the environment variable
//  strings are separated by a NULL byte and the bock is terminated by a
//  NULL byte.
//
//  The Windows NT documentation states that you should NOT use the 
//  return value from GetEnvironmentStrings() to get or set environment
//  variables.  However, the [Get|Set]EnvironmentVariable() functions
//  require that you know the name of the variable you want to get ot
//  set.  Be warned if you use this code.

    pEnv = GetEnvironmentStrings();
    printf("Environment strings NtStyle calls:\n");

    for (charptr = (LPSTR) pEnv; *charptr; charptr++)
        {
            printf("   ");
            while (*charptr)
                putchar(*charptr++);
            putchar('\n');
        }

    return ;
}

void main()
{
    HINSTANCE h;
    FARPROC p;
    BOOL fIsTNT;

    if (!(h = LoadLibrary("kernel32.dll")))
    {
    	printf("LoadLibrary failed!\n");
	exit(1);
    }

    if (!(p = GetProcAddress(h, "IsTNT")))
    {
    	/* GetProcAddress failed - must be NT */
	fIsTNT = FALSE;
    }
    else
    {
	/* call IsTNT() to determine whether we are running
	   under NT or under TNT */

	fIsTNT = (*p)();
    }

    printf("This program is running under ");

    if (fIsTNT)
    {
	printf("TNT DOS-Extender.\n");
        DosStyle();
    }
    else
    {
	printf("Windows NT.\n");
        NtStyle();
    }

    exit(0);
}
