//
// LIBTEST.C
// This program demonstrates calling routines in the C library, the 
// DOSX32 library of _dx_ routines, and the DOS32 library of _dos_ routines.
//
#include <stdlib.h>        // C library header
#include <stdio.h>         // C library header
#include <dos.h>           // C library header

#include <pharlap.h>       // Phar Lap header for _dx_ routines
#include <pldos32.h>       // Phar Lap header for _dos_ routines 

#ifdef __WATCOMC__
#define _dosdate_t dosdate_t
#endif

int main()
{
   CONFIG_INF config;                  // 386|DOS-Extender configuration info
   UCHAR buf[256];                     // buffer for _dx_config_inf call
   struct _dosdate_t date;             // current system date

//
// Call _dx_config_inf in the DOSX32.LIB library
//
   _dx_config_inf(&config, buf);

//
// Call _dos_getdate in the DOS32.LIB library.
// For MetaWare High C/C++ and Watcom C/386, the _dos_ routines are included
// in the C library, so you don't link in DOS32.LIB.
//
   _dos_getdate(&date);

//
// Call printf in the standard C library.
//
   printf("386|DOS-Extender version %d.%d, on a %d86 machine\n",
          config.c_major, config.c_minor, config.c_processor);
   printf("Date is %d/%d/%d\n", date.month, date.day, date.year);

   return 0;
}
