/* 
CHGDIR.C - Change Directory
*/ 
 
#include <stdlib.h> 
#include <stdio.h> 
#include <string.h>
#include <ctype.h>
#include <dos.h> 
#include <pharlap.h>
#include <pldos32.h>	// prototypes for _dos_ routines in DOS32.LIB

#ifdef __WATCOMC__
#define _intdos intdos
#define _toupper toupper
#define _REGS REGS
// Names of regs in _REGS union are nonstandard
#define ax              eax 
#define dx              edx 
#define si              esi 
#endif
 
int main(int argc, UCHAR **argvp)
{ 
    union _REGS r; 
    unsigned Drive;
    UCHAR *pNewDir;
    UCHAR DirBuf[64];

    // get current disk drive
    _dos_getdrive(&Drive);

    if (argc >= 2)
    {
        // set current disk and directory to specified path, and get
	// drive code for use below.
	pNewDir = argvp[1];
	printf("Setting current directory to %s\n", pNewDir);
        memset(&r, 0, sizeof(r));
        r.h.ah = 0x3B;
	r.x.dx = (UINT) pNewDir;
        _intdos(&r, &r); 
        if (r.x.cflag)
        {
            printf("Error %d from Set Current Directory\n", r.x.ax & 0xFFFF);
            return 1;
        }
	if (*(pNewDir + 1) == ':')
	    Drive = (unsigned) (_toupper(*pNewDir) - 'A' + 1);
    }

    // get current directory and print it
    memset(&r, 0, sizeof(r));
    r.h.ah = 0x47;
    r.h.dl = (UCHAR) Drive;
    r.x.si = (UINT) DirBuf;
    _intdos(&r, &r); 
    if (r.x.cflag)
    {
        printf("Error %d from Get Current Directory\n", r.x.ax & 0xFFFF);
	return 1;
    }
    printf("Current directory on drive %c is %s\n", Drive + 'A' - 1, DirBuf);
    return 0;
} 
