;************************************************************************/
;*	Copyright (C) 1986-1988 Phar Lap Software, Inc.			*/
;*	Unpublished - rights reserved under the Copyright Laws of the	*/
;*	United States.  Use, duplication, or disclosure by the 		*/
;*	Government is subject to restrictions as set forth in 		*/
;*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 	*/
;*	Computer Software clause at 252.227-7013.			*/
;*	Phar Lap Software, Inc., 60 Aberdeen Ave., Cambridge, MA 02138	*/
;************************************************************************/
;
; SCRTEST - Screen test program
;
; This program illustrates directly accessing screen memory when
; running in 386 protected mode.  Selector # 1C points to the
; screen memory.  
;


;	Screen defines

scr_height	equ	24		; Screen height
scr_width	equ	80		; Screen width
normal		equ	00700H		; Normal attribute byte
SS_USCREEN 	equ	01CH		; Screen memory selector


;	Special characters

ulcorner	equ	0C9H		; Double upper left corner
urcorner	equ	0BBH		; Double upper right corner
llcorner	equ	0C8H		; Double lower left corner
lrcorner	equ	0BCH		; Double lower right corner
dvline		equ	0BAH		; Double vertical line
dhline		equ	0CDH		; Double horizontal line

;
;	Start of the program
;

_text	segment	byte public use32 'code'

	assume	cs:_text,ds:_data

	public	_start_

_start_	proc	near

	mov	ax,SS_USCREEN		; Move the screen memory selector
	mov	es,ax			;    to ES.

	mov	ax,normal+' '		; Clear the screen.
	mov	ecx,scr_height*scr_width ;
	mov	edi,0			;
	rep stosw			;

	mov	ax,normal		; Load the normal attribute into AH,
	mov	dx,line_cnt		;    the line count in DX, a pointer
	mov	esi,offset line_tab	;    to the first text line into SI.

	mov	edi,scr_width-line_width ; Set up DI to address screen mem.
	add	edi,((scr_height-line_cnt)/2)*(scr_width*2) ;

#loop1:	mov	cx,line_width		; Load the line width into CX.

#loop2:	mov	al,[esi]		; Move the next text character to the
	mov	es:[edi],ax		;    screen with a normal attribute.

	add	esi,1			; Increment the text and screen 
	add	edi,2			;    pointers.

	dec	cx			; Decrement the character count and
	jne	#loop2			;    loop if not zero.

	add	edi,(scr_width-line_width) * 2 ; Dump up DI to the next
					          ;    line.

	dec	dx			; Decrement the line count and loop
	jne	#loop1			;    if not zero.

	mov	ax,04C00H		; Exit the program.
	int	21h			;


_start_	endp

_text	ends

_data	segment	public byte use32 'data'

; 	The line table

line_width	equ	50
line_cnt	equ	14

line_tab	label	byte

line1	db	ulcorner,(line_width - 2) dup (dhline),urcorner

line2	db	dvline,(line_width - 2) dup (' '),dvline

line3	db	dvline
	db	'   Screen test program for 386 protected mode   '
	db	dvline

line4	db	dvline,(line_width - 2) dup (' '),dvline

line5	db	dvline,8 dup (' ')
	db	000H,001H,002H,003H,004H,005H,006H,007H
	db	008H,009H,00AH,00BH,00CH,00DH,00EH,00FH
	db	010H,011H,012H,013H,014H,015H,016H,017H
	db	018H,019H,01AH,01BH,01CH,01DH,01EH,01FH
	db	8 dup (' '),dvline

line6	db	dvline,8 dup (' ')
	db	020H,021H,022H,023H,024H,025H,026H,027H
	db	028H,029H,02AH,02BH,02CH,02DH,02EH,02FH
	db	030H,031H,032H,033H,034H,035H,036H,037H
	db	038H,039H,03AH,03BH,03CH,03DH,03EH,03FH
	db	8 dup (' '),dvline

line7	db	dvline,8 dup (' ')
	db	040H,041H,042H,043H,044H,045H,046H,047H
	db	048H,049H,04AH,04BH,04CH,04DH,04EH,04FH
	db	050H,051H,052H,053H,054H,055H,056H,057H
	db	058H,059H,05AH,05BH,05CH,05DH,05EH,05FH
	db	8 dup (' '),dvline

line8	db	dvline,8 dup (' ')
	db	060H,061H,062H,063H,064H,065H,066H,067H
	db	068H,069H,06AH,06BH,06CH,06DH,06EH,06FH
	db	070H,071H,072H,073H,074H,075H,076H,077H
	db	078H,079H,07AH,07BH,07CH,07DH,07EH,07FH
	db	8 dup (' '),dvline

line9	db	dvline,8 dup (' ')
	db	080H,081H,082H,083H,084H,085H,086H,087H
	db	088H,089H,08AH,08BH,08CH,08DH,08EH,08FH
	db	090H,091H,092H,093H,094H,095H,096H,097H
	db	098H,099H,09AH,09BH,09CH,09DH,09EH,09FH
	db	8 dup (' '),dvline

line10	db	dvline,8 dup (' ')
	db	0A0H,0A1H,0A2H,0A3H,0A4H,0A5H,0A6H,0A7H
	db	0A8H,0A9H,0AAH,0ABH,0ACH,0ADH,0AEH,0AFH
	db	0B0H,0B1H,0B2H,0B3H,0B4H,0B5H,0B6H,0B7H
	db	0B8H,0B9H,0BAH,0BBH,0BCH,0BDH,0BEH,0BFH
	db	8 dup (' '),dvline

line11	db	dvline,8 dup (' ')
	db	0C0H,0C1H,0C2H,0C3H,0C4H,0C5H,0C6H,0C7H
	db	0C8H,0C9H,0CAH,0CBH,0CCH,0CDH,0CEH,0CFH
	db	0D0H,0D1H,0D2H,0D3H,0D4H,0D5H,0D6H,0D7H
	db	0D8H,0D9H,0DAH,0DBH,0DCH,0DDH,0DEH,0DFH
	db	8 dup (' '),dvline

line12	db	dvline,8 dup (' ')
	db	0E0H,0E1H,0E2H,0E3H,0E4H,0E5H,0E6H,0E7H
	db	0E8H,0E9H,0EAH,0EBH,0ECH,0EDH,0EEH,0EFH
	db	0F0H,0F1H,0F2H,0F3H,0F4H,0F5H,0F6H,0F7H
	db	0F8H,0F9H,0FAH,0FBH,0FCH,0FDH,0FEH,0FFH
	db	8 dup (' '),dvline

line13	db	dvline,(line_width - 2) dup (' '),dvline

line14	db	llcorner,(line_width - 2) dup (dhline),lrcorner

_data	ends

_stack	segment	byte stack use32 'stack'

	db	8192 dup (?)		; An 8K stack

_stack	ends

	end _start_
